/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.commands;

import java.util.Collection;
import java.util.Comparator;
import java.util.TreeMap;
import tk.wurst_client.WurstClient;
import tk.wurst_client.commands.AddAltCmd;
import tk.wurst_client.commands.AnnoyCmd;
import tk.wurst_client.commands.AuthorCmd;
import tk.wurst_client.commands.BindsCmd;
import tk.wurst_client.commands.BlinkCmd;
import tk.wurst_client.commands.ClearCmd;
import tk.wurst_client.commands.Cmd;
import tk.wurst_client.commands.DamageCmd;
import tk.wurst_client.commands.DropCmd;
import tk.wurst_client.commands.EnchantCmd;
import tk.wurst_client.commands.FastBreakCmd;
import tk.wurst_client.commands.FeaturesCmd;
import tk.wurst_client.commands.FollowCmd;
import tk.wurst_client.commands.FriendsCmd;
import tk.wurst_client.commands.GetPosCmd;
import tk.wurst_client.commands.GhostHandCmd;
import tk.wurst_client.commands.GiveCmd;
import tk.wurst_client.commands.GmCmd;
import tk.wurst_client.commands.GoToCmd;
import tk.wurst_client.commands.HelpCmd;
import tk.wurst_client.commands.InvseeCmd;
import tk.wurst_client.commands.IpCmd;
import tk.wurst_client.commands.JumpCmd;
import tk.wurst_client.commands.LeaveCmd;
import tk.wurst_client.commands.NothingCmd;
import tk.wurst_client.commands.NukerCmd;
import tk.wurst_client.commands.PathCmd;
import tk.wurst_client.commands.PotionCmd;
import tk.wurst_client.commands.ProtectCmd;
import tk.wurst_client.commands.RenameCmd;
import tk.wurst_client.commands.RvCmd;
import tk.wurst_client.commands.SayCmd;
import tk.wurst_client.commands.SearchCmd;
import tk.wurst_client.commands.SpammerCmd;
import tk.wurst_client.commands.SvCmd;
import tk.wurst_client.commands.TCmd;
import tk.wurst_client.commands.TacoCmd;
import tk.wurst_client.commands.ThrowCmd;
import tk.wurst_client.commands.TpCmd;
import tk.wurst_client.commands.VClipCmd;
import tk.wurst_client.commands.WmsCmd;
import tk.wurst_client.commands.XRayCmd;
import tk.wurst_client.events.ChatOutputEvent;
import tk.wurst_client.events.listeners.ChatOutputListener;

public class CmdManager
implements ChatOutputListener {
    private final TreeMap<String, Cmd> cmds = new TreeMap(new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    });

    public CmdManager() {
        this.addCommand(new AddAltCmd());
        this.addCommand(new AnnoyCmd());
        this.addCommand(new AuthorCmd());
        this.addCommand(new BindsCmd());
        this.addCommand(new BlinkCmd());
        this.addCommand(new ClearCmd());
        this.addCommand(new DamageCmd());
        this.addCommand(new DropCmd());
        this.addCommand(new EnchantCmd());
        this.addCommand(new FastBreakCmd());
        this.addCommand(new FeaturesCmd());
        this.addCommand(new FollowCmd());
        this.addCommand(new FriendsCmd());
        this.addCommand(new GetPosCmd());
        this.addCommand(new GhostHandCmd());
        this.addCommand(new GiveCmd());
        this.addCommand(new GmCmd());
        this.addCommand(new GoToCmd());
        this.addCommand(new HelpCmd());
        this.addCommand(new InvseeCmd());
        this.addCommand(new IpCmd());
        this.addCommand(new JumpCmd());
        this.addCommand(new LeaveCmd());
        this.addCommand(new NothingCmd());
        this.addCommand(new NukerCmd());
        this.addCommand(new PathCmd());
        this.addCommand(new PotionCmd());
        this.addCommand(new ProtectCmd());
        this.addCommand(new RenameCmd());
        this.addCommand(new RvCmd());
        this.addCommand(new SvCmd());
        this.addCommand(new SayCmd());
        this.addCommand(new SearchCmd());
        this.addCommand(new SpammerCmd());
        this.addCommand(new TacoCmd());
        this.addCommand(new TCmd());
        this.addCommand(new ThrowCmd());
        this.addCommand(new TpCmd());
        this.addCommand(new VClipCmd());
        this.addCommand(new WmsCmd());
        this.addCommand(new XRayCmd());
    }

    @Override
    public void onSentMessage(ChatOutputEvent event) {
        String message = event.getMessage();
        if (message.startsWith(".")) {
            event.cancel();
            String input = message.substring(1);
            String commandName = input.split(" ")[0];
            String[] args = input.contains(" ") ? input.substring(input.indexOf(" ") + 1).split(" ") : new String[]{};
            Cmd cmd = this.getCommandByName(commandName);
            if (cmd != null) {
                try {
                    cmd.execute(args);
                    if (!event.isAutomatic()) {
                        WurstClient.INSTANCE.analytics.trackEvent("command", commandName);
                    }
                }
                catch (Cmd.SyntaxError e) {
                    if (e.getMessage() != null) {
                        WurstClient.INSTANCE.chat.message("\u00a74Syntax error:\u00a7r " + e.getMessage());
                    } else {
                        WurstClient.INSTANCE.chat.message("\u00a74Syntax error!\u00a7r");
                    }
                    cmd.printSyntax();
                }
                catch (Cmd.Error e) {
                    WurstClient.INSTANCE.chat.error(e.getMessage());
                }
                catch (Exception e) {
                    WurstClient.INSTANCE.eventManager.handleException(e, cmd, "executing", "Exact input: `" + event.getMessage() + "`");
                }
            } else {
                WurstClient.INSTANCE.chat.error("\"." + commandName + "\" is not a valid command.");
            }
        }
    }

    public Cmd getCommandByClass(Class<?> commandClass) {
        return this.cmds.get(commandClass.getAnnotation(Cmd.Info.class).name());
    }

    public Cmd getCommandByName(String name) {
        return this.cmds.get(name);
    }

    public Collection<Cmd> getAllCommands() {
        return this.cmds.values();
    }

    public int countCommands() {
        return this.cmds.size();
    }

    private void addCommand(Cmd commmand) {
        this.cmds.put(commmand.getName(), commmand);
    }
}

