/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.commands;

import java.util.Iterator;
import tk.wurst_client.WurstClient;
import tk.wurst_client.commands.Cmd;
import tk.wurst_client.utils.MiscUtils;

@Cmd.Info(help="Manages your friends list.", name="friends", syntax={"(add | remove) <player>", "list [<page>]"})
public class FriendsCmd
extends Cmd {
    @Override
    public void execute(String[] args) throws Cmd.Error {
        if (args.length == 0) {
            this.syntaxError();
        }
        if (args[0].equalsIgnoreCase("list")) {
            if (args.length == 1) {
                this.execute(new String[]{"list", "1"});
                return;
            }
            int pages = (int)Math.ceil((double)WurstClient.INSTANCE.friends.size() / 8.0);
            if (MiscUtils.isInteger(args[1])) {
                int page = Integer.valueOf(args[1]);
                if (page > pages || page < 1) {
                    this.syntaxError();
                }
                WurstClient.INSTANCE.chat.message("Current friends: " + WurstClient.INSTANCE.friends.size());
                WurstClient.INSTANCE.chat.message("Friends list (page " + page + "/" + pages + "):");
                Iterator itr = WurstClient.INSTANCE.friends.iterator();
                int i = 0;
                while (itr.hasNext()) {
                    String friend = (String)itr.next();
                    if (i >= (page - 1) * 8 && i < (page - 1) * 8 + 8) {
                        WurstClient.INSTANCE.chat.message(friend);
                    }
                    ++i;
                }
            } else {
                this.syntaxError();
            }
        } else if (args.length < 2) {
            this.syntaxError();
        } else if (args[0].equalsIgnoreCase("add")) {
            if (WurstClient.INSTANCE.friends.contains(args[1])) {
                WurstClient.INSTANCE.chat.error("\"" + args[1] + "\" is already in your friends list.");
                return;
            }
            WurstClient.INSTANCE.friends.add(args[1]);
            WurstClient.INSTANCE.fileManager.saveFriends();
            WurstClient.INSTANCE.chat.message("Added friend \"" + args[1] + "\".");
        } else if (args[0].equalsIgnoreCase("remove")) {
            if (WurstClient.INSTANCE.friends.remove(args[1])) {
                WurstClient.INSTANCE.fileManager.saveFriends();
                WurstClient.INSTANCE.chat.message("Removed friend \"" + args[1] + "\".");
            } else {
                WurstClient.INSTANCE.chat.error("\"" + args[1] + "\" is not in your friends list.");
            }
        } else {
            this.syntaxError();
        }
    }
}

