/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.commands;

import net.minecraft.client.Minecraft;
import net.minecraft.util.BlockPos;
import tk.wurst_client.WurstClient;
import tk.wurst_client.ai.PathFinder;
import tk.wurst_client.commands.Cmd;
import tk.wurst_client.mods.GoToCmdMod;

@Cmd.Info(help="Walks or flies you to a specific location.", name="goto", syntax={"<x> <y> <z>", "<entity>"})
public class GoToCmd
extends Cmd {
    @Override
    public void execute(String[] args) throws Cmd.Error {
        int[] pos = this.argsToPos(args);
        if (Math.abs((double)pos[0] - Minecraft.getMinecraft().thePlayer.posX) > 256.0 || Math.abs((double)pos[2] - Minecraft.getMinecraft().thePlayer.posZ) > 256.0) {
            WurstClient.INSTANCE.chat.error("Goal is out of range!");
            WurstClient.INSTANCE.chat.message("Maximum range is 256 blocks.");
            return;
        }
        GoToCmdMod.setGoal(new BlockPos(pos[0], pos[1], pos[2]));
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                System.out.println("Finding path");
                long startTime = System.nanoTime();
                PathFinder pathFinder = new PathFinder(GoToCmdMod.getGoal());
                if (pathFinder.find()) {
                    GoToCmdMod.setPath(pathFinder.formatPath());
                    WurstClient.INSTANCE.modManager.getModByClass(GoToCmdMod.class).setEnabled(true);
                } else {
                    WurstClient.INSTANCE.chat.error("Could not find a path.");
                }
                System.out.println("Done after " + (double)(System.nanoTime() - startTime) / 1000000.0 + "ms");
            }
        });
        thread.setPriority(1);
        thread.start();
    }
}

