/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.commands;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.gui.inventory.GuiInventory;
import tk.wurst_client.WurstClient;
import tk.wurst_client.commands.Cmd;
import tk.wurst_client.events.listeners.RenderListener;

@Cmd.Info(help="Allows you to see parts of another player's inventory.", name="invsee", syntax={"<player>"})
public class InvseeCmd
extends Cmd
implements RenderListener {
    private String playerName;

    @Override
    public void execute(String[] args) throws Cmd.Error {
        if (args.length != 1) {
            this.syntaxError();
        }
        if (Minecraft.getMinecraft().thePlayer.capabilities.isCreativeMode) {
            WurstClient.INSTANCE.chat.error("Survival mode only.");
            return;
        }
        this.playerName = args[0];
        WurstClient.INSTANCE.eventManager.add(RenderListener.class, this);
    }

    @Override
    public void onRender() {
        boolean found = false;
        for (Object entity : Minecraft.getMinecraft().theWorld.loadedEntityList) {
            EntityOtherPlayerMP player;
            if (!(entity instanceof EntityOtherPlayerMP) || !(player = (EntityOtherPlayerMP)entity).getName().equals(this.playerName)) continue;
            WurstClient.INSTANCE.chat.message("Showing inventory of " + player.getName() + ".");
            Minecraft.getMinecraft().displayGuiScreen(new GuiInventory(player));
            found = true;
        }
        if (!found) {
            WurstClient.INSTANCE.chat.error("Player not found.");
        }
        this.playerName = null;
        WurstClient.INSTANCE.eventManager.remove(RenderListener.class, this);
    }
}

