/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.commands;

import net.minecraft.client.Minecraft;
import net.minecraft.network.play.client.C01PacketChatMessage;
import tk.wurst_client.WurstClient;
import tk.wurst_client.commands.Cmd;

@Cmd.Info(help="Leaves the current server or changes the mode of AutoLeave.", name="leave", syntax={"[chars|quit]", "mode chars|quit"})
public class LeaveCmd
extends Cmd {
    @Override
    public void execute(String[] args) throws Cmd.Error {
        if (args.length > 2) {
            this.syntaxError();
        }
        if (Minecraft.getMinecraft().isIntegratedServerRunning() && Minecraft.getMinecraft().thePlayer.sendQueue.getPlayerInfo().size() == 1) {
            this.error("Cannot leave server when in singleplayer.");
        }
        switch (args.length) {
            case 0: {
                this.disconnectWithMode(WurstClient.INSTANCE.options.autoLeaveMode);
                break;
            }
            case 1: {
                if (args[0].equalsIgnoreCase("taco")) {
                    int i = 0;
                    while (i < 128) {
                        Minecraft.getMinecraft().thePlayer.sendAutomaticChatMessage("Taco!");
                        ++i;
                    }
                    break;
                }
                this.disconnectWithMode(this.parseMode(args[0]));
                break;
            }
            case 2: {
                WurstClient.INSTANCE.options.autoLeaveMode = this.parseMode(args[1]);
                WurstClient.INSTANCE.fileManager.saveOptions();
                WurstClient.INSTANCE.chat.message("AutoLeave mode set to \"" + args[1] + "\".");
                break;
            }
        }
    }

    private void disconnectWithMode(int mode) {
        switch (mode) {
            case 0: {
                Minecraft.getMinecraft().theWorld.sendQuittingDisconnectingPacket();
                break;
            }
            case 1: {
                Minecraft.getMinecraft().thePlayer.sendQueue.addToSendQueue(new C01PacketChatMessage("\u00a7"));
                break;
            }
        }
    }

    private int parseMode(String input) throws Cmd.SyntaxError {
        if (input.equalsIgnoreCase("quit")) {
            return 0;
        }
        if (input.equalsIgnoreCase("chars")) {
            return 1;
        }
        this.syntaxError("Invalid mode: " + input);
        return 0;
    }
}

