/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.error.gui;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.util.ResourceLocation;
import tk.wurst_client.WurstClient;
import tk.wurst_client.commands.Cmd;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.utils.MiscUtils;

public class GuiError
extends GuiScreen {
    private final ResourceLocation bugTexture = new ResourceLocation("wurst/bug.png");
    private final Exception e;
    private final Object cause;
    private final String action;
    private final String comment;

    public GuiError(Exception e, Object cause, String action, String comment) {
        this.e = e;
        this.cause = cause;
        this.action = action;
        this.comment = comment;
    }

    @Override
    public void initGui() {
        this.buttonList.add(new GuiButton(0, this.width / 2 - 100, this.height / 3 * 2, 200, 20, "\u00a7a\u00a7l\u00a7nReport Bug"));
        this.buttonList.add(new GuiButton(1, this.width / 2 - 100, this.height / 3 * 2 + 24, 98, 20, "View Bug"));
        this.buttonList.add(new GuiButton(2, this.width / 2 + 2, this.height / 3 * 2 + 24, 98, 20, "Back to Game"));
        WurstClient.INSTANCE.analytics.trackPageView("/error", "Error");
    }

    @Override
    protected void actionPerformed(GuiButton button) throws IOException {
        if (!button.enabled) {
            return;
        }
        StringWriter stacktraceWriter = new StringWriter();
        this.e.printStackTrace(new PrintWriter(stacktraceWriter));
        String trace = stacktraceWriter.toString();
        final String report = this.generateReport(trace);
        System.err.println(report);
        switch (button.id) {
            case 0: {
                if (WurstClient.INSTANCE.updater.isOutdated() || WurstClient.INSTANCE.updater.getLatestVersion() == null) {
                    this.backToGame();
                    WurstClient.INSTANCE.chat.error("Error reports can only be sent from the latest version.");
                    return;
                }
                try {
                    JsonObject gist = new JsonObject();
                    gist.addProperty("description", this.getReportDescription());
                    gist.addProperty("public", Boolean.valueOf(true));
                    JsonObject gistFiles = new JsonObject();
                    JsonObject gistError = new JsonObject();
                    gistError.addProperty("content", report);
                    gistFiles.add("Wurst-Client-v2.5-Error-Report.md", (JsonElement)gistError);
                    gist.add("files", (JsonElement)gistFiles);
                    JsonObject gistResponse = new JsonParser().parse(MiscUtils.post(new URL("https://api.github.com/gists"), new Gson().toJson((JsonElement)gist))).getAsJsonObject();
                    MiscUtils.openLink(gistResponse.get("html_url").getAsString());
                    String reportUrl = MiscUtils.get(new URL("https://www.wurst-client.tk/api/v1/submit-error-report.txt")).trim();
                    String reportResponse = MiscUtils.get(new URL(String.valueOf(reportUrl) + "?id=" + gistResponse.get("id").getAsString() + "&version=" + WurstClient.INSTANCE.updater.getCurrentVersion() + "&class=" + this.cause.getClass().getName() + "&action=" + this.action));
                    this.backToGame();
                    WurstClient.INSTANCE.analytics.trackEvent("error", "report");
                    WurstClient.INSTANCE.chat.message("Server response: " + reportResponse);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    WurstClient.INSTANCE.chat.error("Something went wrong with that error report.");
                    WurstClient.INSTANCE.analytics.trackEvent("error", "report failed");
                }
                break;
            }
            case 1: {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        switch (JOptionPane.showOptionDialog(Minecraft.getMinecraft().getFrame(), report, "Stacktrace", -1, 1, null, new String[]{"Close", "Copy to Clipboard", "Save to File"}, 0)) {
                            case 1: {
                                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(report), null);
                                break;
                            }
                            case 2: {
                                JFileChooser fileChooser = new JFileChooser(){

                                    @Override
                                    protected JDialog createDialog(Component parent) throws HeadlessException {
                                        JDialog dialog = super.createDialog(parent);
                                        dialog.setAlwaysOnTop(true);
                                        return dialog;
                                    }
                                };
                                fileChooser.setFileSelectionMode(0);
                                fileChooser.setAcceptAllFileFilterUsed(false);
                                fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Markdown files", "md"));
                                int action = fileChooser.showSaveDialog(Minecraft.getMinecraft().getFrame());
                                if (action != 0) break;
                                try {
                                    File file = fileChooser.getSelectedFile();
                                    if (!file.getName().endsWith(".md")) {
                                        file = new File(String.valueOf(file.getPath()) + ".md");
                                    }
                                    PrintWriter save = new PrintWriter(new FileWriter(file));
                                    save.println(report);
                                    save.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                    MiscUtils.simpleError(e, fileChooser);
                                }
                                break;
                            }
                        }
                    }
                }).start();
                WurstClient.INSTANCE.analytics.trackEvent("error", "view");
                break;
            }
            case 2: {
                mc.displayGuiScreen(new GuiYesNo(this, "Are you absolutely sure you don't want to report this error?", "We can't fix it that way!", "\u00a74Yes", "\u00a72No", 0));
                break;
            }
        }
    }

    @Override
    public void confirmClicked(boolean result, int id) {
        super.confirmClicked(result, id);
        if (result) {
            this.backToGame();
            WurstClient.INSTANCE.analytics.trackEvent("error", "back");
        } else {
            mc.displayGuiScreen(this);
        }
    }

    private void backToGame() {
        if (this.cause instanceof Mod) {
            WurstClient.INSTANCE.modManager.getModByClass(this.cause.getClass()).setEnabled(false);
        }
        mc.displayGuiScreen(null);
    }

    private String getReportDescription() {
        String title = "An error occurred ";
        if (this.cause instanceof Mod) {
            title = String.valueOf(title) + "in `" + WurstClient.INSTANCE.modManager.getModByClass(this.cause.getClass()).getName() + "` ";
        } else if (this.cause instanceof Cmd) {
            title = String.valueOf(title) + "in `." + ((Cmd)this.cause).getName() + "` ";
        }
        title = String.valueOf(title) + "while " + this.action + ".";
        return title;
    }

    private String generateReport(String trace) {
        try {
            String line;
            BufferedReader input = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("assets/minecraft/wurst/error-report.md")));
            StringWriter writer = new StringWriter();
            PrintWriter output = new PrintWriter(writer);
            while ((line = input.readLine()) != null) {
                output.println(line);
            }
            String content = writer.toString();
            content = content.replace("\u00a7time", new SimpleDateFormat("yyyy.MM.dd-hh:mm:ss").format(new Date()));
            content = content.replace("\u00a7trace", trace);
            content = content.replace("\u00a7os", String.valueOf(System.getProperty("os.name")) + " (" + System.getProperty("os.arch") + ")");
            content = content.replace("\u00a7java", String.valueOf(System.getProperty("java.version")) + " (" + System.getProperty("java.vendor") + ")");
            content = content.replace("\u00a7wurst", String.valueOf(WurstClient.INSTANCE.updater.getCurrentVersion()) + " (latest: " + WurstClient.INSTANCE.updater.getLatestVersion() + ")");
            content = content.replace("\u00a7desc", String.valueOf(this.getReportDescription()) + (this.comment.isEmpty() ? "" : "\n" + this.comment));
            return content;
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter stacktraceWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stacktraceWriter));
            String eString = stacktraceWriter.toString();
            return "Could not generate error report. Stack trace:\n```\n" + eString + "\n```";
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        mc.getTextureManager().bindTexture(this.bugTexture);
        GuiError.drawScaledCustomSizeModalRect(this.width / 2 - 48, this.height / 3, 0.0f, 0.0f, 256, 256, 96, 96, 256.0f, 256.0f);
        this.drawCenteredString(this.fontRendererObj, "\u00a7nError!\u00a7r", this.width / 2, this.height / 4, -1);
        this.drawCenteredString(this.fontRendererObj, this.getReportDescription(), this.width / 2, this.height / 4 + 16, -1);
        super.drawScreen(mouseX, mouseY, partialTicks);
    }
}

