/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.events;

import java.util.EventListener;
import javax.swing.event.EventListenerList;
import net.minecraft.client.Minecraft;
import tk.wurst_client.error.gui.GuiError;
import tk.wurst_client.events.ChatInputEvent;
import tk.wurst_client.events.ChatOutputEvent;
import tk.wurst_client.events.DeathEvent;
import tk.wurst_client.events.Event;
import tk.wurst_client.events.GUIRenderEvent;
import tk.wurst_client.events.LeftClickEvent;
import tk.wurst_client.events.PacketInputEvent;
import tk.wurst_client.events.RenderEvent;
import tk.wurst_client.events.UpdateEvent;
import tk.wurst_client.events.listeners.ChatInputListener;
import tk.wurst_client.events.listeners.ChatOutputListener;
import tk.wurst_client.events.listeners.DeathListener;
import tk.wurst_client.events.listeners.GUIRenderListener;
import tk.wurst_client.events.listeners.LeftClickListener;
import tk.wurst_client.events.listeners.PacketInputListener;
import tk.wurst_client.events.listeners.RenderListener;
import tk.wurst_client.events.listeners.UpdateListener;

public final class EventManager {
    private static final EventListenerList listenerList = new EventListenerList();

    public synchronized <T extends Event> void fireEvent(Class<T> type, T event) {
        block10: {
            try {
                if (type == GUIRenderEvent.class) {
                    this.fireGuiRender();
                    break block10;
                }
                if (type == RenderEvent.class) {
                    this.fireRender();
                    break block10;
                }
                if (type == PacketInputEvent.class) {
                    this.firePacketInput((PacketInputEvent)event);
                    break block10;
                }
                if (type == UpdateEvent.class) {
                    this.fireUpdate();
                    break block10;
                }
                if (type == ChatInputEvent.class) {
                    this.fireChatInput((ChatInputEvent)event);
                    break block10;
                }
                if (type == ChatOutputEvent.class) {
                    this.fireChatOutput((ChatOutputEvent)event);
                    break block10;
                }
                if (type == LeftClickEvent.class) {
                    this.fireLeftClick();
                    break block10;
                }
                if (type == DeathEvent.class) {
                    this.fireDeath();
                    break block10;
                }
                throw new IllegalArgumentException("Invalid event type: " + type.getName());
            }
            catch (Exception e) {
                this.handleException(e, this, "processing events", "Event type: " + event.getClass().getSimpleName());
            }
        }
    }

    private void fireChatInput(ChatInputEvent event) {
        Object[] listeners = listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ChatInputListener.class) {
                ((ChatInputListener)listeners[i + 1]).onReceivedMessage(event);
            }
            if (event.isCancelled()) break;
            i -= 2;
        }
    }

    private void fireChatOutput(ChatOutputEvent event) {
        Object[] listeners = listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ChatOutputListener.class) {
                ((ChatOutputListener)listeners[i + 1]).onSentMessage(event);
            }
            if (event.isCancelled()) break;
            i -= 2;
        }
    }

    private void fireDeath() {
        Object[] listeners = listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == DeathListener.class) {
                ((DeathListener)listeners[i + 1]).onDeath();
            }
            i -= 2;
        }
    }

    private void fireGuiRender() {
        Object[] listeners = listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == GUIRenderListener.class) {
                ((GUIRenderListener)listeners[i + 1]).onRenderGUI();
            }
            i -= 2;
        }
    }

    private void fireLeftClick() {
        Object[] listeners = listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == LeftClickListener.class) {
                ((LeftClickListener)listeners[i + 1]).onLeftClick();
            }
            i -= 2;
        }
    }

    private void firePacketInput(PacketInputEvent event) {
        Object[] listeners = listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == PacketInputListener.class) {
                ((PacketInputListener)listeners[i + 1]).onReceivedPacket(event);
            }
            i -= 2;
        }
    }

    private void fireRender() {
        Object[] listeners = listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == RenderListener.class) {
                ((RenderListener)listeners[i + 1]).onRender();
            }
            i -= 2;
        }
    }

    private void fireUpdate() {
        Object[] listeners = listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == UpdateListener.class) {
                ((UpdateListener)listeners[i + 1]).onUpdate();
            }
            i -= 2;
        }
    }

    public void handleException(final Exception e, final Object cause, final String action, final String comment) {
        if (e.getMessage() != null && e.getMessage().equals("No OpenGL context found in the current thread.")) {
            return;
        }
        this.add(UpdateListener.class, new UpdateListener(){

            @Override
            public void onUpdate() {
                Minecraft.getMinecraft().displayGuiScreen(new GuiError(e, cause, action, comment));
                EventManager.this.remove(UpdateListener.class, this);
            }
        });
    }

    public <T extends EventListener> void add(Class<T> type, T listener) {
        listenerList.add(type, listener);
    }

    public <T extends EventListener> void remove(Class<T> type, T listener) {
        listenerList.remove(type, listener);
    }
}

