/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import org.darkstorm.minecraft.gui.AbstractGuiManager;
import org.darkstorm.minecraft.gui.component.Button;
import org.darkstorm.minecraft.gui.component.ComboBox;
import org.darkstorm.minecraft.gui.component.Component;
import org.darkstorm.minecraft.gui.component.Frame;
import org.darkstorm.minecraft.gui.component.Slider;
import org.darkstorm.minecraft.gui.component.basic.BasicButton;
import org.darkstorm.minecraft.gui.component.basic.BasicComboBox;
import org.darkstorm.minecraft.gui.component.basic.BasicFrame;
import org.darkstorm.minecraft.gui.component.basic.BasicSlider;
import org.darkstorm.minecraft.gui.layout.Constraint;
import org.darkstorm.minecraft.gui.layout.GridLayoutManager;
import org.darkstorm.minecraft.gui.listener.ButtonListener;
import org.darkstorm.minecraft.gui.listener.ComboBoxListener;
import org.darkstorm.minecraft.gui.listener.SliderListener;
import org.darkstorm.minecraft.gui.theme.Theme;
import org.darkstorm.minecraft.gui.theme.wurst.WurstTheme;
import tk.wurst_client.WurstClient;
import tk.wurst_client.gui.TargetFrame;
import tk.wurst_client.mods.AutoBuildMod;
import tk.wurst_client.mods.Mod;

public final class GuiManager
extends AbstractGuiManager {
    private final AtomicBoolean setup;
    private final Map<Mod.Category, ModuleFrame> categoryFrames = new HashMap<Mod.Category, ModuleFrame>();

    public GuiManager() {
        this.setup = new AtomicBoolean();
    }

    @Override
    public void setup() {
        if (!this.setup.compareAndSet(false, true)) {
            return;
        }
        ModuleFrame settings = new ModuleFrame("Settings");
        settings.setTheme(this.theme);
        settings.setLayoutManager(new GridLayoutManager(1, 0));
        settings.setVisible(true);
        settings.setClosable(false);
        settings.setMinimized(true);
        settings.setPinnable(true);
        this.addFrame(settings);
        for (final Mod mod : WurstClient.INSTANCE.modManager.getAllMods()) {
            String moduleDescription;
            ModuleFrame frame = this.categoryFrames.get((Object)mod.getCategory());
            if (frame == null) {
                String name = mod.getCategory().name().toLowerCase();
                if (WurstClient.INSTANCE.fileManager.options.exists()) {
                    WurstClient.INSTANCE.fileManager.loadOptions();
                }
                if (name.equalsIgnoreCase("HIDDEN")) continue;
                if ((name = String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1)).equalsIgnoreCase("AUTOBUILD")) {
                    name = "AutoBuild";
                }
                frame = new ModuleFrame(name);
                frame.setTheme(this.theme);
                frame.setLayoutManager(new GridLayoutManager(1, 0));
                frame.setVisible(true);
                frame.setClosable(false);
                frame.setMinimized(true);
                frame.setPinnable(true);
                this.addFrame(frame);
                this.categoryFrames.put(mod.getCategory(), frame);
            }
            if ((moduleDescription = mod.getDescription()).equals("")) {
                moduleDescription = "Error! This is a bug. Please report it.";
            }
            final Mod updateModule = mod;
            BasicButton button = new BasicButton(mod.getName(), moduleDescription){

                @Override
                public void update() {
                    this.setForegroundColor(updateModule.isEnabled() ? Color.BLACK : Color.WHITE);
                    if (updateModule.isEnabled()) {
                        if (updateModule.isBlocked()) {
                            this.setBackgroundColor(new Color(255, 0, 0, 96));
                        } else {
                            this.setBackgroundColor(new Color(0, 255, 0, 96));
                        }
                    } else {
                        this.setBackgroundColor(new Color(0, 0, 0, 0));
                    }
                }
            };
            button.addButtonListener(new ButtonListener(){

                @Override
                public void onButtonPress(Button button) {
                    updateModule.toggle();
                }
            });
            frame.add(button, new Constraint[0]);
            if (mod.getSliders().isEmpty()) continue;
            for (BasicSlider slider : mod.getSliders()) {
                slider.addSliderListener(new SliderListener(){

                    @Override
                    public void onSliderValueChanged(Slider slider) {
                        ArrayList<BasicSlider> moduleSliders = mod.getSliders();
                        if (moduleSliders.contains(slider)) {
                            int id = moduleSliders.indexOf(slider);
                            moduleSliders.set(id, (BasicSlider)slider);
                            WurstClient.INSTANCE.fileManager.saveSliders();
                        }
                        mod.setSliders(moduleSliders);
                        mod.updateSettings();
                    }
                });
                settings.add(slider, new Constraint[0]);
            }
        }
        ModuleFrame autobuild = this.categoryFrames.get((Object)Mod.Category.AUTOBUILD);
        BasicComboBox autoBuildBox = new BasicComboBox(AutoBuildMod.names.toArray(new String[AutoBuildMod.names.size()]));
        autoBuildBox.addComboBoxListener(new ComboBoxListener(){

            @Override
            public void onComboBoxSelectionChanged(ComboBox comboBox) {
                WurstClient.INSTANCE.options.autobuildMode = comboBox.getSelectedIndex();
                WurstClient.INSTANCE.fileManager.saveOptions();
            }
        });
        autoBuildBox.setSelectedIndex(WurstClient.INSTANCE.options.autobuildMode);
        autobuild.add(autoBuildBox, GridLayoutManager.HorizontalGridConstraint.CENTER);
        this.categoryFrames.remove((Object)Mod.Category.AUTOBUILD);
        this.addFrame(new TargetFrame());
        if (!WurstClient.INSTANCE.fileManager.sliders.exists()) {
            WurstClient.INSTANCE.fileManager.saveSliders();
        } else {
            WurstClient.INSTANCE.fileManager.loadSliders();
        }
        this.resizeComponents();
        Minecraft minecraft = Minecraft.getMinecraft();
        int offsetX = 5;
        int offsetY = 5;
        int scale = minecraft.gameSettings.guiScale;
        if (scale == 0) {
            scale = 1000;
        }
        int scaleFactor = 0;
        while (scaleFactor < scale && minecraft.displayWidth / (scaleFactor + 1) >= 320 && minecraft.displayHeight / (scaleFactor + 1) >= 240) {
            ++scaleFactor;
        }
        Frame[] frameArray = this.getFrames();
        int n = frameArray.length;
        int n2 = 0;
        while (n2 < n) {
            Frame frame = frameArray[n2];
            frame.setX(offsetX);
            frame.setY(offsetY);
            Dimension frameSize = frame.getSize();
            if ((offsetX += frameSize.width + 5) + frameSize.width + 5 > minecraft.displayWidth / scaleFactor) {
                offsetX = 5;
                int height = 0;
                if (frame.isMinimized()) {
                    Rectangle[] rectangleArray = frame.getTheme().getUIForComponent(frame).getInteractableRegions(frame);
                    int n3 = rectangleArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Rectangle area = rectangleArray[n4];
                        height = Math.max(height, area.height);
                        ++n4;
                    }
                } else {
                    height = frameSize.height;
                }
                offsetY += height + 5;
            }
            ++n2;
        }
        if (WurstClient.INSTANCE.fileManager.gui.exists()) {
            WurstClient.INSTANCE.fileManager.loadGUI(this.getFrames());
        }
    }

    @Override
    protected void resizeComponents() {
        Theme theme = this.getTheme();
        Frame[] frames = this.getFrames();
        BasicButton enable = new BasicButton("Enable", "");
        BasicButton disable = new BasicButton("Disable", "");
        Dimension enableSize = theme.getUIForComponent(enable).getDefaultSize(enable);
        Dimension disableSize = theme.getUIForComponent(disable).getDefaultSize(disable);
        int buttonWidth = Math.max(enableSize.width, disableSize.width);
        int buttonHeight = Math.max(enableSize.height, disableSize.height);
        Frame[] frameArray = frames;
        int n = frames.length;
        int n2 = 0;
        while (n2 < n) {
            Frame frame = frameArray[n2];
            if (frame instanceof ModuleFrame) {
                Component[] componentArray = frame.getChildren();
                int n3 = componentArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Component component = componentArray[n4];
                    if (component instanceof Button) {
                        component.setWidth(buttonWidth);
                        component.setHeight(buttonHeight);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        this.recalculateSizes();
    }

    private void recalculateSizes() {
        Frame frame;
        Frame[] frames;
        Frame[] frameArray = frames = this.getFrames();
        int n = frames.length;
        int n2 = 0;
        while (n2 < n) {
            frame = frameArray[n2];
            Dimension defaultDimension = frame.getTheme().getUIForComponent(frame).getDefaultSize(frame);
            frame.setWidth(defaultDimension.width);
            frame.setHeight(defaultDimension.height);
            ++n2;
        }
        frameArray = frames;
        n = frames.length;
        n2 = 0;
        while (n2 < n) {
            frame = frameArray[n2];
            FontRenderer fontRenderer = ((WurstTheme)this.theme).getFontRenderer();
            int minWidth = Math.max(fontRenderer.getStringWidth(frame.getTitle()), fontRenderer.getStringWidth("+++++")) + 6;
            if (frame.isMinimizable()) {
                minWidth += fontRenderer.FONT_HEIGHT + 2;
            }
            if (frame.isPinnable()) {
                minWidth += fontRenderer.FONT_HEIGHT + 2;
            }
            if (frame.isClosable()) {
                minWidth += fontRenderer.FONT_HEIGHT + 2;
            }
            if (frame.getWidth() < minWidth) {
                frame.setWidth(minWidth);
            }
            frame.layoutChildren();
            ++n2;
        }
    }

    private class ModuleFrame
    extends BasicFrame {
        private ModuleFrame() {
        }

        private ModuleFrame(String title) {
            super(title);
        }
    }
}

