/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockPos;
import org.darkstorm.minecraft.gui.component.BoundedRangeComponent;
import org.darkstorm.minecraft.gui.component.Component;
import org.darkstorm.minecraft.gui.component.Frame;
import org.darkstorm.minecraft.gui.component.Label;
import org.darkstorm.minecraft.gui.component.basic.BasicFrame;
import org.darkstorm.minecraft.gui.component.basic.BasicLabel;
import org.darkstorm.minecraft.gui.component.basic.BasicSlider;
import org.darkstorm.minecraft.gui.layout.GridLayoutManager;
import org.darkstorm.minecraft.gui.theme.wurst.WurstTheme;
import tk.wurst_client.WurstClient;
import tk.wurst_client.events.ChatInputEvent;
import tk.wurst_client.events.listeners.ChatInputListener;
import tk.wurst_client.events.listeners.DeathListener;
import tk.wurst_client.events.listeners.RenderListener;
import tk.wurst_client.events.listeners.UpdateListener;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.utils.BlockUtils;
import tk.wurst_client.utils.EntityUtils;
import tk.wurst_client.utils.MiscUtils;
import tk.wurst_client.utils.RenderUtils;

@Mod.Info(category=Mod.Category.MISC, description="Makes ArenaBrawl on mc.hypixel.net a lot easier.\nThis is a collection of mods that have been optimized\nfor ArenaBrawl. It will bypass everything that Hypixel\nhas to offer.", name="ArenaBrawl")
public class ArenaBrawlMod
extends Mod
implements ChatInputListener,
DeathListener,
RenderListener,
UpdateListener {
    private EntityLivingBase friend;
    public static float range = 4.25f;
    public static ArrayList<String> scoreboard = new ArrayList();
    private ArrayList<int[]> matchingBlocks = new ArrayList();
    private ArrayList<int[]> enemyTotems = new ArrayList();
    private ArrayList<int[]> friendTotems = new ArrayList();
    private String friendsName;
    private Frame frame;
    private int target;
    private TargetType targetType;
    private EntityLivingBase entityTarget;
    private int[] blockTarget;
    private long lastAttack = 0L;
    public int level = 40;

    @Override
    public String getRenderName() {
        if (this.friendsName != null) {
            return "ArenaBrawl with " + this.friendsName;
        }
        return "ArenaBrawl";
    }

    @Override
    public void initSliders() {
        this.sliders.add(new BasicSlider("ArenaBrawl level", this.level, 20.0, 100.0, 10.0, BoundedRangeComponent.ValueDisplay.INTEGER));
    }

    @Override
    public void updateSettings() {
        this.level = (int)((BasicSlider)this.sliders.get(0)).getValue();
    }

    @Override
    public void onEnable() {
        this.reset();
        WurstClient.INSTANCE.eventManager.add(ChatInputListener.class, this);
        WurstClient.INSTANCE.eventManager.add(DeathListener.class, this);
        WurstClient.INSTANCE.eventManager.add(RenderListener.class, this);
        WurstClient.INSTANCE.eventManager.add(UpdateListener.class, this);
    }

    @Override
    public void onRender() {
        double z;
        double y;
        double x;
        double z2;
        double y2;
        double x2;
        if (this.targetType == TargetType.BLOCK_E) {
            x2 = this.blockTarget[0];
            y2 = this.blockTarget[1];
            z2 = this.blockTarget[2];
            RenderUtils.box(x2, y2, z2, x2 + 1.0, y2 + 2.0, z2 + 1.0, new Color(255, 0, 0, 64));
        } else if (this.targetType == TargetType.BLOCK_F) {
            x2 = this.blockTarget[0];
            y2 = this.blockTarget[1];
            z2 = this.blockTarget[2];
            RenderUtils.box(x2, y2, z2, x2 + 1.0, y2 + 2.0, z2 + 1.0, new Color(0, 255, 0, 64));
        } else if (this.targetType == TargetType.ENTITY_E && this.entityTarget != null) {
            x2 = this.entityTarget.posX;
            y2 = this.entityTarget.posY;
            z2 = this.entityTarget.posZ;
            RenderUtils.box(x2 - 0.35, y2, z2 - 0.35, x2 + 0.35, y2 + 1.9, z2 + 0.35, new Color(255, 0, 0, 64));
        } else if (this.targetType == TargetType.ENTITY_F && this.entityTarget != null) {
            x2 = this.entityTarget.posX;
            y2 = this.entityTarget.posY;
            z2 = this.entityTarget.posZ;
            RenderUtils.box(x2 - 0.35, y2, z2 - 0.35, x2 + 0.35, y2 + 1.9, z2 + 0.35, new Color(0, 255, 0, 64));
        }
        if (EntityUtils.searchEntityByNameRaw(this.formatSBName(5)) != null) {
            RenderUtils.entityESPBox(EntityUtils.searchEntityByNameRaw(this.formatSBName(5)), RenderUtils.target);
            RenderUtils.tracerLine((Entity)EntityUtils.searchEntityByNameRaw(this.formatSBName(5)), RenderUtils.target);
        }
        if (EntityUtils.searchEntityByNameRaw(this.formatSBName(4)) != null) {
            RenderUtils.entityESPBox(EntityUtils.searchEntityByNameRaw(this.formatSBName(4)), RenderUtils.target);
            RenderUtils.tracerLine((Entity)EntityUtils.searchEntityByNameRaw(this.formatSBName(4)), RenderUtils.target);
        }
        if (this.friend != null) {
            RenderUtils.entityESPBox(this.friend, RenderUtils.team);
            RenderUtils.tracerLine((Entity)this.friend, RenderUtils.team);
        }
        if (!this.enemyTotems.isEmpty()) {
            for (int[] totem : this.enemyTotems) {
                x = totem[0];
                y = totem[1];
                z = totem[2];
                RenderUtils.frame(x, y, z, x + 1.0, y + 2.0, z + 1.0, new Color(255, 0, 0, 128));
                RenderUtils.tracerLine((int)x, (int)y, (int)z, new Color(255, 0, 0, 128));
            }
        }
        if (!this.friendTotems.isEmpty()) {
            for (int[] totem : this.friendTotems) {
                x = totem[0];
                y = totem[1];
                z = totem[2];
                RenderUtils.frame(x, y, z, x + 1.0, y + 2.0, z + 1.0, new Color(0, 255, 0, 128));
            }
        }
    }

    @Override
    public void onUpdate() {
        if (scoreboard != null && (scoreboard.size() == 13 || scoreboard.size() == 11)) {
            WurstClient.INSTANCE.chat.message("You need to be in a 2v2 arena.");
            this.setEnabled(false);
            return;
        }
        if (scoreboard == null) {
            return;
        }
        if (this.frame == null && scoreboard.size() == 8) {
            try {
                this.setupFrame();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.frame = null;
                return;
            }
        }
        if (this.friend == null || this.friend.isDead) {
            this.friend = EntityUtils.searchEntityByName(this.friendsName);
        }
        this.updateMS();
        try {
            this.scanTotems();
            this.getTarget();
            this.updateFrame();
            if (!Minecraft.getMinecraft().thePlayer.isCollidedHorizontally && Minecraft.getMinecraft().thePlayer.moveForward > 0.0f && !Minecraft.getMinecraft().thePlayer.isSneaking()) {
                Minecraft.getMinecraft().thePlayer.setSprinting(true);
                if (Minecraft.getMinecraft().thePlayer.onGround && Minecraft.getMinecraft().thePlayer.isSprinting()) {
                    Minecraft.getMinecraft().thePlayer.jump();
                }
            }
            if (this.targetType == TargetType.BLOCK_E) {
                float distX = (float)((double)this.blockTarget[0] - Minecraft.getMinecraft().thePlayer.posX);
                float distY = (float)((double)this.blockTarget[1] - Minecraft.getMinecraft().thePlayer.posY);
                float distZ = (float)((double)this.blockTarget[2] - Minecraft.getMinecraft().thePlayer.posZ);
                if ((double)BlockUtils.getBlockDistance(distX, distY, distZ) <= 4.25) {
                    this.faceTarget();
                    this.attackTarget();
                } else {
                    KeyBinding.setKeyBindState(Minecraft.getMinecraft().gameSettings.keyBindAttack.getKeyCode(), false);
                    KeyBinding.setKeyBindState(Minecraft.getMinecraft().gameSettings.keyBindUseItem.getKeyCode(), false);
                }
            } else if (this.targetType == TargetType.ENTITY_E) {
                if ((double)Minecraft.getMinecraft().thePlayer.getDistanceToEntity(this.entityTarget) <= 4.25) {
                    this.faceTarget();
                    this.attackTarget();
                } else {
                    KeyBinding.setKeyBindState(Minecraft.getMinecraft().gameSettings.keyBindAttack.getKeyCode(), false);
                    KeyBinding.setKeyBindState(Minecraft.getMinecraft().gameSettings.keyBindUseItem.getKeyCode(), false);
                }
            } else {
                KeyBinding.setKeyBindState(Minecraft.getMinecraft().gameSettings.keyBindAttack.getKeyCode(), false);
                KeyBinding.setKeyBindState(Minecraft.getMinecraft().gameSettings.keyBindUseItem.getKeyCode(), false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onDisable() {
        WurstClient.INSTANCE.eventManager.remove(ChatInputListener.class, this);
        WurstClient.INSTANCE.eventManager.remove(DeathListener.class, this);
        WurstClient.INSTANCE.eventManager.remove(RenderListener.class, this);
        WurstClient.INSTANCE.eventManager.remove(UpdateListener.class, this);
        Minecraft.getMinecraft().gameSettings.keyBindForward.pressed = false;
        if (this.friendsName != null) {
            WurstClient.INSTANCE.chat.message("No longer playing ArenaBrawl with " + this.friendsName + ".");
        }
        this.reset();
    }

    @Override
    public void onReceivedMessage(ChatInputEvent event) {
        String message = event.getComponent().getUnformattedText();
        if (message.startsWith("[Arena]: ") && message.endsWith(" has won the game!")) {
            event.cancel();
            WurstClient.INSTANCE.chat.message(message.substring(9));
            this.setEnabled(false);
        }
    }

    @Override
    public void onDeath() {
        Minecraft.getMinecraft().thePlayer.respawnPlayer();
        GuiScreen.mc.displayGuiScreen(null);
        WurstClient.INSTANCE.chat.message("You died.");
        this.setEnabled(false);
    }

    private void setupFrame() {
        this.friendsName = this.formatSBName(0);
        WurstClient.INSTANCE.chat.message("Now playing ArenaBrawl with " + this.friendsName + ".");
        this.frame = new BasicFrame("ArenaBrawl");
        this.frame.setTheme(new WurstTheme());
        this.frame.setLayoutManager(new GridLayoutManager(2, 0));
        this.frame.setClosable(false);
        this.frame.setMinimized(false);
        this.frame.setMinimizable(false);
        this.frame.setPinnable(true);
        this.frame.setPinned(true);
        this.frame.setWidth(137);
        this.frame.add(new BasicLabel("NAME"), GridLayoutManager.HorizontalGridConstraint.LEFT);
        this.frame.add(new BasicLabel("HEALTH"), GridLayoutManager.HorizontalGridConstraint.RIGHT);
        this.frame.add(new BasicLabel(this.formatSBName(1)), GridLayoutManager.HorizontalGridConstraint.LEFT);
        this.frame.add(new BasicLabel("???? / 2000"), GridLayoutManager.HorizontalGridConstraint.RIGHT);
        this.frame.add(new BasicLabel(this.friendsName), GridLayoutManager.HorizontalGridConstraint.LEFT);
        this.frame.add(new BasicLabel("???? / 2000"), GridLayoutManager.HorizontalGridConstraint.RIGHT);
        this.frame.add(new BasicLabel(this.formatSBName(5)), GridLayoutManager.HorizontalGridConstraint.LEFT);
        this.frame.add(new BasicLabel("???? / 2000"), GridLayoutManager.HorizontalGridConstraint.RIGHT);
        this.frame.add(new BasicLabel(this.formatSBName(4)), GridLayoutManager.HorizontalGridConstraint.LEFT);
        this.frame.add(new BasicLabel("???? / 2000"), GridLayoutManager.HorizontalGridConstraint.RIGHT);
        this.frame.setHeight(this.frame.getTheme().getUIForComponent((Component)this.frame).getDefaultSize((Component)this.frame).height);
        this.frame.layoutChildren();
        WurstClient.INSTANCE.guiManager.addFrame(this.frame);
        this.frame.setBackgroundColor(new Color(64, 64, 64, 224));
        ((Label)this.frame.getChildren()[0]).setForegroundColor(Color.CYAN);
        ((Label)this.frame.getChildren()[1]).setForegroundColor(Color.CYAN);
        ((Label)this.frame.getChildren()[2]).setForegroundColor(Color.GREEN);
        ((Label)this.frame.getChildren()[4]).setForegroundColor(Color.GREEN);
        ((Label)this.frame.getChildren()[6]).setForegroundColor(Color.BLUE);
        ((Label)this.frame.getChildren()[8]).setForegroundColor(Color.BLUE);
        this.frame.setVisible(true);
    }

    private void updateFrame() {
        ScaledResolution sr = new ScaledResolution(Minecraft.getMinecraft(), Minecraft.getMinecraft().displayWidth, Minecraft.getMinecraft().displayHeight);
        int width = sr.getScaledWidth();
        int height = sr.getScaledHeight();
        this.frame.setX(width - this.frame.getWidth() - 1);
        this.frame.setY((height - this.frame.getHeight()) / 2 - 16);
        this.frame.setDragging(false);
        this.frame.setPinned(true);
        this.updateLabel(2, 1);
        this.updateLabel(4, 0);
        this.updateLabel(6, 5);
        this.updateLabel(8, 4);
        while (this.frame.getChildren().length > 10) {
            this.frame.remove(this.frame.getChildren()[10]);
        }
        int i = 0;
        while (i < this.friendTotems.size()) {
            this.frame.add(new BasicLabel("Totem " + (i + 1)), GridLayoutManager.HorizontalGridConstraint.LEFT);
            this.frame.add(new BasicLabel(""), GridLayoutManager.HorizontalGridConstraint.RIGHT);
            ((Label)this.frame.getChildren()[8 + (i + 1) * 2]).setForegroundColor(Color.GREEN);
            ++i;
        }
        i = 0;
        while (i < this.enemyTotems.size()) {
            this.frame.add(new BasicLabel("Totem " + (this.friendTotems.size() + i + 1)), GridLayoutManager.HorizontalGridConstraint.LEFT);
            this.frame.add(new BasicLabel(""), GridLayoutManager.HorizontalGridConstraint.RIGHT);
            ((Label)this.frame.getChildren()[8 + (this.friendTotems.size() + i + 1) * 2]).setForegroundColor(Color.BLUE);
            ++i;
        }
    }

    private Color getColorForHealth(String health) {
        if (health.endsWith(" / 2000")) {
            health = health.substring(0, health.length() - 7);
        }
        if (!MiscUtils.isInteger(health) || Integer.valueOf(health) == 0) {
            return Color.BLACK;
        }
        return new Color(0, Integer.valueOf(health) * 255 / 2200, 255 - Integer.valueOf(health) * 255 / 2200);
    }

    private String formatSBName(int index) {
        try {
            return scoreboard.get(index).split(" ")[0].substring(2, scoreboard.get(index).split(" ")[0].length() - 2);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String formatSBHealth(int index) {
        try {
            String health = scoreboard.get(index).split(" ")[1];
            if (!MiscUtils.isInteger(health)) {
                return health;
            }
            return String.valueOf(health) + " / 2000";
        }
        catch (Exception e) {
            return "???? / 2000";
        }
    }

    private void updateLabel(int labelIndex, int sbIndex) {
        ((Label)this.frame.getChildren()[labelIndex]).setText(String.valueOf(this.target == labelIndex ? ">" : "") + this.formatSBName(sbIndex));
        ((Label)this.frame.getChildren()[labelIndex]).setHorizontalAlignment(Label.TextAlignment.LEFT);
        ((Label)this.frame.getChildren()[labelIndex + 1]).setText(this.formatSBHealth(sbIndex));
        ((Label)this.frame.getChildren()[labelIndex + 1]).setHorizontalAlignment(Label.TextAlignment.RIGHT);
        ((Label)this.frame.getChildren()[labelIndex + 1]).setForegroundColor(this.getColorForHealth(this.formatSBHealth(sbIndex)));
    }

    private void scanTotems() {
        this.matchingBlocks.clear();
        int y = 3;
        while (y >= -3) {
            int x = 50;
            while (x >= -50) {
                int z = 50;
                while (z >= -50) {
                    int posX = (int)(Minecraft.getMinecraft().thePlayer.posX + (double)x);
                    int posY = (int)(Minecraft.getMinecraft().thePlayer.posY + (double)y);
                    int posZ = (int)(Minecraft.getMinecraft().thePlayer.posZ + (double)z);
                    if (Block.getIdFromBlock(Minecraft.getMinecraft().theWorld.getBlockState(new BlockPos(posX, posY, posZ)).getBlock()) == Block.getIdFromBlock(Block.getBlockFromName("wool"))) {
                        this.matchingBlocks.add(new int[]{posX, posY, posZ});
                    }
                    --z;
                }
                --x;
            }
            --y;
        }
        this.enemyTotems.clear();
        int i = 0;
        while (i < this.matchingBlocks.size()) {
            IBlockState blockState = Minecraft.getMinecraft().theWorld.getBlockState(new BlockPos(this.matchingBlocks.get(i)[0], this.matchingBlocks.get(i)[1] + 1, this.matchingBlocks.get(i)[2]));
            if (blockState.getBlock().getMetaFromState(blockState) == 14 && Block.getIdFromBlock(blockState.getBlock()) != 0) {
                this.enemyTotems.add(new int[]{this.matchingBlocks.get(i)[0], this.matchingBlocks.get(i)[1] + 1, this.matchingBlocks.get(i)[2]});
            }
            ++i;
        }
        this.friendTotems.clear();
        i = 0;
        while (i < this.matchingBlocks.size()) {
            IBlockState blockState = Minecraft.getMinecraft().theWorld.getBlockState(new BlockPos(this.matchingBlocks.get(i)[0], this.matchingBlocks.get(i)[1] + 1, this.matchingBlocks.get(i)[2]));
            if (blockState.getBlock().getMetaFromState(blockState) == 5 && Block.getIdFromBlock(blockState.getBlock()) != 0) {
                this.friendTotems.add(new int[]{this.matchingBlocks.get(i)[0], this.matchingBlocks.get(i)[1] + 1, this.matchingBlocks.get(i)[2]});
            }
            ++i;
        }
    }

    private void getTarget() {
        float distC;
        float distZC;
        float distYC;
        float distXC;
        float distZ;
        float distY;
        float distX;
        int[] closestTotem;
        this.blockTarget = null;
        this.entityTarget = null;
        this.target = -1;
        this.targetType = null;
        if (!this.enemyTotems.isEmpty()) {
            closestTotem = null;
            float dist = 1.0E9f;
            for (int[] totem : this.enemyTotems) {
                distX = (float)((double)totem[0] - Minecraft.getMinecraft().thePlayer.posX);
                distY = (float)((double)totem[1] - Minecraft.getMinecraft().thePlayer.posY);
                distZ = (float)((double)totem[2] - Minecraft.getMinecraft().thePlayer.posZ);
                dist = BlockUtils.getBlockDistance(distX, distY, distZ);
                if (closestTotem == null) {
                    closestTotem = totem;
                    continue;
                }
                distXC = (float)((double)closestTotem[0] - Minecraft.getMinecraft().thePlayer.posX);
                distYC = (float)((double)closestTotem[1] - Minecraft.getMinecraft().thePlayer.posY);
                distZC = (float)((double)closestTotem[2] - Minecraft.getMinecraft().thePlayer.posZ);
                distC = BlockUtils.getBlockDistance(distXC, distYC, distZC);
                if (!(dist < distC)) continue;
                closestTotem = totem;
            }
            this.target = 8 + (this.friendTotems.size() + this.enemyTotems.indexOf(closestTotem) + 1) * 2;
            this.targetType = TargetType.BLOCK_E;
            this.blockTarget = closestTotem;
            if ((double)dist <= 4.25) {
                return;
            }
        }
        if (EntityUtils.searchEntityByName(this.formatSBName(4)) != null || EntityUtils.searchEntityByName(this.formatSBName(5)) != null) {
            EntityLivingBase enemy1 = EntityUtils.searchEntityByName(this.formatSBName(5));
            EntityLivingBase enemy2 = EntityUtils.searchEntityByName(this.formatSBName(4));
            if (enemy2 == null) {
                this.entityTarget = enemy1;
                this.target = 6;
            } else if (enemy1 == null) {
                this.entityTarget = enemy2;
                this.target = 8;
            } else if (Minecraft.getMinecraft().thePlayer.getDistanceToEntity(enemy1) <= Minecraft.getMinecraft().thePlayer.getDistanceToEntity(enemy2)) {
                this.entityTarget = enemy1;
                this.target = 6;
            } else {
                this.entityTarget = enemy2;
                this.target = 8;
            }
            this.targetType = TargetType.ENTITY_E;
            if ((double)Minecraft.getMinecraft().thePlayer.getDistanceToEntity(this.entityTarget) <= 4.25) {
                return;
            }
        }
        if (!this.friendTotems.isEmpty()) {
            closestTotem = null;
            float dist = 1.0E9f;
            for (int[] totem : this.friendTotems) {
                distX = (float)((double)totem[0] - Minecraft.getMinecraft().thePlayer.posX);
                distY = (float)((double)totem[1] - Minecraft.getMinecraft().thePlayer.posY);
                distZ = (float)((double)totem[2] - Minecraft.getMinecraft().thePlayer.posZ);
                dist = BlockUtils.getBlockDistance(distX, distY, distZ);
                if (closestTotem == null) {
                    closestTotem = totem;
                    continue;
                }
                distXC = (float)((double)closestTotem[0] - Minecraft.getMinecraft().thePlayer.posX);
                distYC = (float)((double)closestTotem[1] - Minecraft.getMinecraft().thePlayer.posY);
                distZC = (float)((double)closestTotem[2] - Minecraft.getMinecraft().thePlayer.posZ);
                distC = BlockUtils.getBlockDistance(distXC, distYC, distZC);
                if (!(dist < distC)) continue;
                closestTotem = totem;
            }
            this.target = 8 + (this.friendTotems.indexOf(closestTotem) + 1) * 2;
            this.targetType = TargetType.BLOCK_F;
            this.blockTarget = closestTotem;
            return;
        }
        if (this.target == -1) {
            this.entityTarget = this.friend;
            this.target = 4;
            this.targetType = TargetType.ENTITY_F;
            return;
        }
    }

    private void faceTarget() {
        if (this.targetType == TargetType.BLOCK_E) {
            BlockUtils.faceBlockClient(new BlockPos(this.blockTarget[0], this.blockTarget[1], this.blockTarget[2]));
        } else if (this.targetType == TargetType.ENTITY_E || this.targetType == TargetType.ENTITY_F) {
            EntityUtils.faceEntityClient(this.entityTarget);
        }
    }

    private void attackTarget() {
        if (this.targetType == TargetType.BLOCK_E) {
            if (System.currentTimeMillis() >= this.lastAttack + 50L) {
                Minecraft.getMinecraft().gameSettings.keyBindAttack.pressed = !Minecraft.getMinecraft().gameSettings.keyBindAttack.pressed;
                this.lastAttack = System.currentTimeMillis();
                Minecraft.getMinecraft().gameSettings.keyBindUseItem.pressed = false;
            }
        } else if (this.targetType == TargetType.ENTITY_E && System.currentTimeMillis() >= this.lastAttack + 100L) {
            if (Minecraft.getMinecraft().thePlayer.experienceLevel >= this.level) {
                Minecraft.getMinecraft().gameSettings.keyBindUseItem.pressed = !Minecraft.getMinecraft().gameSettings.keyBindUseItem.pressed;
            } else {
                Minecraft.getMinecraft().gameSettings.keyBindUseItem.pressed = false;
                Minecraft.getMinecraft().thePlayer.swingItem();
                Minecraft.getMinecraft().playerController.attackEntity(Minecraft.getMinecraft().thePlayer, this.entityTarget);
            }
            this.lastAttack = System.currentTimeMillis();
        }
    }

    private void reset() {
        Minecraft.getMinecraft().gameSettings.keyBindUseItem.pressed = false;
        this.matchingBlocks.clear();
        this.enemyTotems.clear();
        this.friendTotems.clear();
        WurstClient.INSTANCE.guiManager.removeFrame(this.frame);
        this.frame = null;
        this.friend = null;
        this.entityTarget = null;
        this.blockTarget = null;
        this.targetType = null;
        this.friendsName = null;
    }

    private static enum TargetType {
        BLOCK_E,
        BLOCK_F,
        ENTITY_E,
        ENTITY_F;

    }
}

