/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import tk.wurst_client.WurstClient;
import tk.wurst_client.events.listeners.LeftClickListener;
import tk.wurst_client.events.listeners.UpdateListener;
import tk.wurst_client.mods.Mod;

@Mod.Info(category=Mod.Category.BLOCKS, description="Automatically uses the best tool in your hotbar to\nmine blocks. Tip: This works with Nuker.", name="AutoTool")
public class AutoToolMod
extends Mod
implements LeftClickListener,
UpdateListener {
    private boolean isActive = false;
    private int oldSlot;

    @Override
    public void onEnable() {
        WurstClient.INSTANCE.eventManager.add(LeftClickListener.class, this);
        WurstClient.INSTANCE.eventManager.add(UpdateListener.class, this);
    }

    @Override
    public void onUpdate() {
        if (!Minecraft.getMinecraft().gameSettings.keyBindAttack.pressed && this.isActive) {
            this.isActive = false;
            Minecraft.getMinecraft().thePlayer.inventory.currentItem = this.oldSlot;
        } else if (this.isActive && Minecraft.getMinecraft().objectMouseOver != null && Minecraft.getMinecraft().objectMouseOver.getBlockPos() != null && Minecraft.getMinecraft().theWorld.getBlockState(Minecraft.getMinecraft().objectMouseOver.getBlockPos()).getBlock().getMaterial() != Material.air) {
            AutoToolMod.setSlot(Minecraft.getMinecraft().objectMouseOver.getBlockPos());
        }
    }

    @Override
    public void onDisable() {
        WurstClient.INSTANCE.eventManager.remove(LeftClickListener.class, this);
        WurstClient.INSTANCE.eventManager.remove(UpdateListener.class, this);
        this.isActive = false;
        Minecraft.getMinecraft().thePlayer.inventory.currentItem = this.oldSlot;
    }

    @Override
    public void onLeftClick() {
        if (Minecraft.getMinecraft().objectMouseOver == null || Minecraft.getMinecraft().objectMouseOver.getBlockPos() == null) {
            return;
        }
        if (Minecraft.getMinecraft().theWorld.getBlockState(Minecraft.getMinecraft().objectMouseOver.getBlockPos()).getBlock().getMaterial() != Material.air) {
            this.isActive = true;
            this.oldSlot = Minecraft.getMinecraft().thePlayer.inventory.currentItem;
            AutoToolMod.setSlot(Minecraft.getMinecraft().objectMouseOver.getBlockPos());
        }
    }

    public static void setSlot(BlockPos blockPos) {
        float bestSpeed = 1.0f;
        int bestSlot = -1;
        Block block = Minecraft.getMinecraft().theWorld.getBlockState(blockPos).getBlock();
        int i = 0;
        while (i < 9) {
            float speed;
            ItemStack item = Minecraft.getMinecraft().thePlayer.inventory.getStackInSlot(i);
            if (item != null && (speed = item.getStrVsBlock(block)) > bestSpeed) {
                bestSpeed = speed;
                bestSlot = i;
            }
            ++i;
        }
        if (bestSlot != -1) {
            Minecraft.getMinecraft().thePlayer.inventory.currentItem = bestSlot;
        }
    }
}

