/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.network.play.client.C08PacketPlayerBlockPlacement;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MovingObjectPosition;
import tk.wurst_client.WurstClient;
import tk.wurst_client.events.listeners.UpdateListener;
import tk.wurst_client.mods.FastPlaceMod;
import tk.wurst_client.mods.FreecamMod;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.mods.RemoteViewMod;
import tk.wurst_client.utils.BlockUtils;

@Mod.Info(category=Mod.Category.BLOCKS, description="Places random blocks around you.", name="BuildRandom")
public class BuildRandomMod
extends Mod
implements UpdateListener {
    private float range = 6.0f;

    @Override
    public void onEnable() {
        WurstClient.INSTANCE.eventManager.add(UpdateListener.class, this);
    }

    @Override
    public void onUpdate() {
        if (WurstClient.INSTANCE.modManager.getModByClass(FreecamMod.class).isActive() || WurstClient.INSTANCE.modManager.getModByClass(RemoteViewMod.class).isActive() || Minecraft.getMinecraft().objectMouseOver == null || Minecraft.getMinecraft().objectMouseOver.typeOfHit != MovingObjectPosition.MovingObjectType.BLOCK) {
            return;
        }
        if (Minecraft.getMinecraft().rightClickDelayTimer > 0 && !WurstClient.INSTANCE.modManager.getModByClass(FastPlaceMod.class).isActive()) {
            return;
        }
        float xDiff = 0.0f;
        float yDiff = 0.0f;
        float zDiff = 0.0f;
        float distance = this.range + 1.0f;
        boolean hasBlocks = false;
        int y = (int)this.range;
        while ((float)y >= -this.range) {
            int x = (int)this.range;
            while ((float)x >= -this.range - 1.0f) {
                int z = (int)this.range;
                while ((float)z >= -this.range) {
                    if (Block.getIdFromBlock(Minecraft.getMinecraft().theWorld.getBlockState(new BlockPos((int)((double)x + Minecraft.getMinecraft().thePlayer.posX), (int)((double)y + Minecraft.getMinecraft().thePlayer.posY), (int)((double)z + Minecraft.getMinecraft().thePlayer.posZ))).getBlock()) != 0 && BlockUtils.getBlockDistance(x, y, z) <= this.range) {
                        hasBlocks = true;
                        break;
                    }
                    --z;
                }
                if (hasBlocks) break;
                --x;
            }
            if (hasBlocks) break;
            --y;
        }
        if (!hasBlocks) {
            return;
        }
        BlockPos randomPos = null;
        while (distance > this.range || distance < -this.range || randomPos == null || Block.getIdFromBlock(Minecraft.getMinecraft().theWorld.getBlockState(randomPos).getBlock()) == 0) {
            xDiff = (int)(Math.random() * (double)this.range * 2.0 - (double)this.range - 1.0);
            yDiff = (int)(Math.random() * (double)this.range * 2.0 - (double)this.range);
            zDiff = (int)(Math.random() * (double)this.range * 2.0 - (double)this.range);
            distance = BlockUtils.getBlockDistance(xDiff, yDiff, zDiff);
            int randomPosX = (int)((double)xDiff + Minecraft.getMinecraft().thePlayer.posX);
            int randomPosY = (int)((double)yDiff + Minecraft.getMinecraft().thePlayer.posY);
            int randomPosZ = (int)((double)zDiff + Minecraft.getMinecraft().thePlayer.posZ);
            randomPos = new BlockPos(randomPosX, randomPosY, randomPosZ);
        }
        MovingObjectPosition fakeObjectMouseOver = Minecraft.getMinecraft().objectMouseOver;
        if (fakeObjectMouseOver == null || randomPos == null) {
            return;
        }
        fakeObjectMouseOver.setBlockPos(randomPos);
        BlockUtils.faceBlockPacket(randomPos);
        Minecraft.getMinecraft().thePlayer.swingItem();
        Minecraft.getMinecraft().thePlayer.sendQueue.addToSendQueue(new C08PacketPlayerBlockPlacement(randomPos, fakeObjectMouseOver.sideHit.getIndex(), Minecraft.getMinecraft().thePlayer.inventory.getCurrentItem(), (float)fakeObjectMouseOver.hitVec.xCoord - (float)fakeObjectMouseOver.getBlockPos().getX(), (float)fakeObjectMouseOver.hitVec.yCoord - (float)fakeObjectMouseOver.getBlockPos().getY(), (float)fakeObjectMouseOver.hitVec.zCoord - (float)fakeObjectMouseOver.getBlockPos().getZ()));
    }

    @Override
    public void onDisable() {
        WurstClient.INSTANCE.eventManager.remove(UpdateListener.class, this);
    }
}

