/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import org.darkstorm.minecraft.gui.component.basic.BasicSlider;
import tk.wurst_client.WurstClient;
import tk.wurst_client.error.gui.GuiError;

public class Mod {
    private final String name = this.getClass().getAnnotation(Info.class).name();
    private final String description = this.getClass().getAnnotation(Info.class).description();
    private final Category category = this.getClass().getAnnotation(Info.class).category();
    private boolean enabled;
    private boolean blocked;
    protected ArrayList<BasicSlider> sliders = new ArrayList();
    private long currentMS = 0L;
    protected long lastMS = -1L;

    public final String getName() {
        return this.name;
    }

    public String getRenderName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final Category getCategory() {
        return this.category;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final boolean isActive() {
        return this.enabled && !this.blocked;
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.blocked && enabled) {
            return;
        }
        try {
            this.onToggle();
        }
        catch (Exception e) {
            Minecraft.getMinecraft().displayGuiScreen(new GuiError(e, this, "toggling", "Mod was toggled " + (enabled ? "on" : "off") + "."));
        }
        if (enabled) {
            try {
                this.onEnable();
            }
            catch (Exception e) {
                Minecraft.getMinecraft().displayGuiScreen(new GuiError(e, this, "enabling", ""));
            }
        } else {
            try {
                this.onDisable();
            }
            catch (Exception e) {
                Minecraft.getMinecraft().displayGuiScreen(new GuiError(e, this, "disabling", ""));
            }
        }
        WurstClient.INSTANCE.fileManager.saveMods();
        WurstClient.INSTANCE.analytics.trackEvent("mod", this.name, enabled ? "enable" : "disable");
    }

    public final void enableOnStartup() {
        this.enabled = true;
        try {
            this.onToggle();
        }
        catch (Exception e) {
            Minecraft.getMinecraft().displayGuiScreen(new GuiError(e, this, "toggling", "Mod was toggled " + (this.enabled ? "on" : "off") + "."));
        }
        try {
            this.onEnable();
        }
        catch (Exception e) {
            Minecraft.getMinecraft().displayGuiScreen(new GuiError(e, this, "enabling", ""));
        }
    }

    public final void toggle() {
        this.setEnabled(!this.isEnabled());
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
        if (this.enabled) {
            try {
                this.onToggle();
            }
            catch (Exception e) {
                Minecraft.getMinecraft().displayGuiScreen(new GuiError(e, this, "toggling", "Mod was toggled " + (blocked ? "off" : "on") + "."));
            }
            try {
                if (blocked) {
                    this.onDisable();
                } else {
                    this.onEnable();
                }
            }
            catch (Exception e) {
                Minecraft.getMinecraft().displayGuiScreen(new GuiError(e, this, blocked ? "disabling" : "enabling", ""));
            }
        }
    }

    public final ArrayList<BasicSlider> getSliders() {
        return this.sliders;
    }

    public final void setSliders(ArrayList<BasicSlider> newSliders) {
        this.sliders = newSliders;
    }

    public final void noCheatMessage() {
        WurstClient.INSTANCE.chat.warning(String.valueOf(this.name) + " cannot bypass NoCheat+.");
    }

    public final void updateMS() {
        this.currentMS = System.currentTimeMillis();
    }

    public final void updateLastMS() {
        this.lastMS = System.currentTimeMillis();
    }

    public final boolean hasTimePassedM(long MS) {
        return this.currentMS >= this.lastMS + MS;
    }

    public final boolean hasTimePassedS(float speed) {
        return this.currentMS >= this.lastMS + (long)(1000.0f / speed);
    }

    public void onToggle() {
    }

    public void onEnable() {
    }

    public void onDisable() {
    }

    public void initSliders() {
    }

    public void updateSettings() {
    }

    public static enum Category {
        AUTOBUILD,
        BLOCKS,
        CHAT,
        COMBAT,
        EXPLOITS,
        FUN,
        HIDDEN,
        RENDER,
        MISC,
        MOVEMENT;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Info {
        public String name();

        public String description();

        public Category category();

        public boolean noCheatCompatible() default true;
    }
}

