/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.network.play.client.C07PacketPlayerDigging;
import net.minecraft.network.play.client.C0APacketAnimation;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import org.darkstorm.minecraft.gui.component.BoundedRangeComponent;
import org.darkstorm.minecraft.gui.component.basic.BasicSlider;
import tk.wurst_client.WurstClient;
import tk.wurst_client.events.listeners.LeftClickListener;
import tk.wurst_client.events.listeners.RenderListener;
import tk.wurst_client.events.listeners.UpdateListener;
import tk.wurst_client.mods.AutoToolMod;
import tk.wurst_client.mods.FastBreakMod;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.mods.NukerLegitMod;
import tk.wurst_client.mods.SpeedNukerMod;
import tk.wurst_client.mods.TunnellerMod;
import tk.wurst_client.mods.YesCheatMod;
import tk.wurst_client.utils.BlockUtils;
import tk.wurst_client.utils.RenderUtils;

@Mod.Info(category=Mod.Category.BLOCKS, description="Destroys blocks around you.\nUse .nuker mode <mode> to change the mode.", name="Nuker")
public class NukerMod
extends Mod
implements LeftClickListener,
RenderListener,
UpdateListener {
    public float normalRange = 5.0f;
    public float yesCheatRange = 4.25f;
    private float realRange;
    private static Block currentBlock;
    private float currentDamage;
    private EnumFacing side = EnumFacing.UP;
    private byte blockHitDelay = 0;
    public static int id;
    private BlockPos pos;
    private boolean shouldRenderESP;
    private int oldSlot = -1;

    static {
        id = 0;
    }

    @Override
    public String getRenderName() {
        if (WurstClient.INSTANCE.options.nukerMode == 1) {
            return "IDNuker [" + id + "]";
        }
        if (WurstClient.INSTANCE.options.nukerMode == 2) {
            return "FlatNuker";
        }
        if (WurstClient.INSTANCE.options.nukerMode == 3) {
            return "SmashNuker";
        }
        return "Nuker";
    }

    @Override
    public void initSliders() {
        this.sliders.add(new BasicSlider("Nuker range", this.normalRange, 1.0, 6.0, 0.05, BoundedRangeComponent.ValueDisplay.DECIMAL));
    }

    @Override
    public void updateSettings() {
        this.normalRange = (float)((BasicSlider)this.sliders.get(0)).getValue();
        this.yesCheatRange = Math.min(this.normalRange, 4.25f);
    }

    @Override
    public void onEnable() {
        if (WurstClient.INSTANCE.modManager.getModByClass(NukerLegitMod.class).isEnabled()) {
            WurstClient.INSTANCE.modManager.getModByClass(NukerLegitMod.class).setEnabled(false);
        }
        if (WurstClient.INSTANCE.modManager.getModByClass(SpeedNukerMod.class).isEnabled()) {
            WurstClient.INSTANCE.modManager.getModByClass(SpeedNukerMod.class).setEnabled(false);
        }
        if (WurstClient.INSTANCE.modManager.getModByClass(TunnellerMod.class).isEnabled()) {
            WurstClient.INSTANCE.modManager.getModByClass(TunnellerMod.class).setEnabled(false);
        }
        WurstClient.INSTANCE.eventManager.add(LeftClickListener.class, this);
        WurstClient.INSTANCE.eventManager.add(UpdateListener.class, this);
        WurstClient.INSTANCE.eventManager.add(RenderListener.class, this);
    }

    @Override
    public void onRender() {
        if (this.blockHitDelay == 0 && this.shouldRenderESP) {
            if (!Minecraft.getMinecraft().thePlayer.capabilities.isCreativeMode && currentBlock.getPlayerRelativeBlockHardness(Minecraft.getMinecraft().thePlayer, Minecraft.getMinecraft().theWorld, this.pos) < 1.0f) {
                RenderUtils.nukerBox(this.pos, this.currentDamage);
            } else {
                RenderUtils.nukerBox(this.pos, 1.0f);
            }
        }
    }

    @Override
    public void onUpdate() {
        this.realRange = WurstClient.INSTANCE.modManager.getModByClass(YesCheatMod.class).isActive() ? this.yesCheatRange : this.normalRange;
        this.shouldRenderESP = false;
        BlockPos newPos = this.find();
        if (newPos == null) {
            if (this.oldSlot != -1) {
                Minecraft.getMinecraft().thePlayer.inventory.currentItem = this.oldSlot;
                this.oldSlot = -1;
            }
            return;
        }
        if (this.pos == null || !this.pos.equals(newPos)) {
            this.currentDamage = 0.0f;
        }
        this.pos = newPos;
        currentBlock = Minecraft.getMinecraft().theWorld.getBlockState(this.pos).getBlock();
        if (this.blockHitDelay > 0) {
            this.blockHitDelay = (byte)(this.blockHitDelay - 1);
            return;
        }
        BlockUtils.faceBlockPacket(this.pos);
        if (this.currentDamage == 0.0f) {
            Minecraft.getMinecraft().thePlayer.sendQueue.addToSendQueue(new C07PacketPlayerDigging(C07PacketPlayerDigging.Action.START_DESTROY_BLOCK, this.pos, this.side));
            if (WurstClient.INSTANCE.modManager.getModByClass(AutoToolMod.class).isActive() && this.oldSlot == -1) {
                this.oldSlot = Minecraft.getMinecraft().thePlayer.inventory.currentItem;
            }
            if (Minecraft.getMinecraft().thePlayer.capabilities.isCreativeMode || currentBlock.getPlayerRelativeBlockHardness(Minecraft.getMinecraft().thePlayer, Minecraft.getMinecraft().theWorld, this.pos) >= 1.0f) {
                this.currentDamage = 0.0f;
                if (Minecraft.getMinecraft().thePlayer.capabilities.isCreativeMode && !WurstClient.INSTANCE.modManager.getModByClass(YesCheatMod.class).isActive()) {
                    this.nukeAll();
                } else {
                    this.shouldRenderESP = true;
                    Minecraft.getMinecraft().thePlayer.swingItem();
                    Minecraft.getMinecraft().playerController.onPlayerDestroyBlock(this.pos, this.side);
                }
                return;
            }
        }
        if (WurstClient.INSTANCE.modManager.getModByClass(AutoToolMod.class).isActive()) {
            AutoToolMod.setSlot(this.pos);
        }
        Minecraft.getMinecraft().thePlayer.sendQueue.addToSendQueue(new C0APacketAnimation());
        this.shouldRenderESP = true;
        BlockUtils.faceBlockPacket(this.pos);
        this.currentDamage += currentBlock.getPlayerRelativeBlockHardness(Minecraft.getMinecraft().thePlayer, Minecraft.getMinecraft().theWorld, this.pos) * (WurstClient.INSTANCE.modManager.getModByClass(FastBreakMod.class).isActive() && WurstClient.INSTANCE.options.fastbreakMode == 0 ? ((FastBreakMod)WurstClient.INSTANCE.modManager.getModByClass(FastBreakMod.class)).speed : 1.0f);
        Minecraft.getMinecraft().theWorld.sendBlockBreakProgress(Minecraft.getMinecraft().thePlayer.getEntityId(), this.pos, (int)(this.currentDamage * 10.0f) - 1);
        if (this.currentDamage >= 1.0f) {
            Minecraft.getMinecraft().thePlayer.sendQueue.addToSendQueue(new C07PacketPlayerDigging(C07PacketPlayerDigging.Action.STOP_DESTROY_BLOCK, this.pos, this.side));
            Minecraft.getMinecraft().playerController.onPlayerDestroyBlock(this.pos, this.side);
            this.blockHitDelay = (byte)4;
            this.currentDamage = 0.0f;
        } else if (WurstClient.INSTANCE.modManager.getModByClass(FastBreakMod.class).isActive() && WurstClient.INSTANCE.options.fastbreakMode == 1) {
            Minecraft.getMinecraft().thePlayer.sendQueue.addToSendQueue(new C07PacketPlayerDigging(C07PacketPlayerDigging.Action.STOP_DESTROY_BLOCK, this.pos, this.side));
        }
    }

    @Override
    public void onDisable() {
        WurstClient.INSTANCE.eventManager.remove(LeftClickListener.class, this);
        WurstClient.INSTANCE.eventManager.remove(UpdateListener.class, this);
        WurstClient.INSTANCE.eventManager.remove(RenderListener.class, this);
        if (this.oldSlot != -1) {
            Minecraft.getMinecraft().thePlayer.inventory.currentItem = this.oldSlot;
            this.oldSlot = -1;
        }
        this.currentDamage = 0.0f;
        this.shouldRenderESP = false;
        id = 0;
        WurstClient.INSTANCE.fileManager.saveOptions();
    }

    @Override
    public void onLeftClick() {
        if (Minecraft.getMinecraft().objectMouseOver == null || Minecraft.getMinecraft().objectMouseOver.getBlockPos() == null) {
            return;
        }
        if (WurstClient.INSTANCE.options.nukerMode == 1 && Minecraft.getMinecraft().theWorld.getBlockState(Minecraft.getMinecraft().objectMouseOver.getBlockPos()).getBlock().getMaterial() != Material.air) {
            id = Block.getIdFromBlock(Minecraft.getMinecraft().theWorld.getBlockState(Minecraft.getMinecraft().objectMouseOver.getBlockPos()).getBlock());
            WurstClient.INSTANCE.fileManager.saveOptions();
        }
    }

    private BlockPos find() {
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        HashSet<BlockPos> alreadyProcessed = new HashSet<BlockPos>();
        queue.add(new BlockPos(Minecraft.getMinecraft().thePlayer));
        while (!queue.isEmpty()) {
            BlockPos currentPos = (BlockPos)queue.poll();
            if (alreadyProcessed.contains(currentPos)) continue;
            alreadyProcessed.add(currentPos);
            if (BlockUtils.getPlayerBlockDistance(currentPos) > this.realRange) continue;
            int currentID = Block.getIdFromBlock(Minecraft.getMinecraft().theWorld.getBlockState(currentPos).getBlock());
            if (currentID != 0) {
                switch (WurstClient.INSTANCE.options.nukerMode) {
                    case 1: {
                        if (currentID != id) break;
                        return currentPos;
                    }
                    case 2: {
                        if (!((double)currentPos.getY() >= Minecraft.getMinecraft().thePlayer.posY)) break;
                        return currentPos;
                    }
                    case 3: {
                        if (!(Minecraft.getMinecraft().theWorld.getBlockState(currentPos).getBlock().getPlayerRelativeBlockHardness(Minecraft.getMinecraft().thePlayer, Minecraft.getMinecraft().theWorld, currentPos) >= 1.0f)) break;
                        return currentPos;
                    }
                    default: {
                        return currentPos;
                    }
                }
            }
            if (WurstClient.INSTANCE.modManager.getModByClass(YesCheatMod.class).isActive() && Minecraft.getMinecraft().theWorld.getBlockState(currentPos).getBlock().getMaterial().blocksMovement()) continue;
            queue.add(currentPos.add(0, 0, -1));
            queue.add(currentPos.add(0, 0, 1));
            queue.add(currentPos.add(-1, 0, 0));
            queue.add(currentPos.add(1, 0, 0));
            queue.add(currentPos.add(0, -1, 0));
            queue.add(currentPos.add(0, 1, 0));
        }
        return null;
    }

    private void nukeAll() {
        int y = (int)this.realRange;
        while ((float)y >= (WurstClient.INSTANCE.options.nukerMode == 2 ? 0.0f : -this.realRange)) {
            int x = (int)this.realRange;
            while ((float)x >= -this.realRange - 1.0f) {
                int z = (int)this.realRange;
                while ((float)z >= -this.realRange) {
                    int posX = (int)(Math.floor(Minecraft.getMinecraft().thePlayer.posX) + (double)x);
                    int posY = (int)(Math.floor(Minecraft.getMinecraft().thePlayer.posY) + (double)y);
                    int posZ = (int)(Math.floor(Minecraft.getMinecraft().thePlayer.posZ) + (double)z);
                    BlockPos blockPos = new BlockPos(posX, posY, posZ);
                    Block block = Minecraft.getMinecraft().theWorld.getBlockState(blockPos).getBlock();
                    float xDiff = (float)(Minecraft.getMinecraft().thePlayer.posX - (double)posX);
                    float yDiff = (float)(Minecraft.getMinecraft().thePlayer.posY - (double)posY);
                    float zDiff = (float)(Minecraft.getMinecraft().thePlayer.posZ - (double)posZ);
                    float currentDistance = BlockUtils.getBlockDistance(xDiff, yDiff, zDiff);
                    MovingObjectPosition fakeObjectMouseOver = Minecraft.getMinecraft().objectMouseOver;
                    fakeObjectMouseOver.setBlockPos(blockPos);
                    if (!(Block.getIdFromBlock(block) == 0 || posY < 0 || !(currentDistance <= this.realRange) || WurstClient.INSTANCE.options.nukerMode == 1 && Block.getIdFromBlock(block) != id || WurstClient.INSTANCE.options.nukerMode == 3 && block.getPlayerRelativeBlockHardness(Minecraft.getMinecraft().thePlayer, Minecraft.getMinecraft().theWorld, blockPos) < 1.0f)) {
                        this.side = fakeObjectMouseOver.sideHit;
                        this.shouldRenderESP = true;
                        BlockUtils.faceBlockPacket(this.pos);
                        Minecraft.getMinecraft().thePlayer.sendQueue.addToSendQueue(new C07PacketPlayerDigging(C07PacketPlayerDigging.Action.START_DESTROY_BLOCK, blockPos, this.side));
                        block.onBlockDestroyedByPlayer(Minecraft.getMinecraft().theWorld, blockPos, Minecraft.getMinecraft().theWorld.getBlockState(blockPos));
                    }
                    --z;
                }
                --x;
            }
            --y;
        }
    }
}

