/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.util.BlockPos;
import tk.wurst_client.WurstClient;
import tk.wurst_client.events.listeners.RenderListener;
import tk.wurst_client.events.listeners.UpdateListener;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.utils.RenderUtils;

@Mod.Info(category=Mod.Category.RENDER, description="Helps you to find specific blocks.\nUse .search id <block id> or .search name <block name>\nto specify it.", name="Search")
public class SearchMod
extends Mod
implements UpdateListener,
RenderListener {
    private ArrayList<BlockPos> matchingBlocks = new ArrayList();
    private int range = 50;
    private int maxBlocks = 1000;
    public boolean notify = true;

    @Override
    public String getRenderName() {
        return String.valueOf(this.getName()) + " [" + WurstClient.INSTANCE.options.searchID + "]";
    }

    @Override
    public void onEnable() {
        this.notify = true;
        WurstClient.INSTANCE.eventManager.add(UpdateListener.class, this);
        WurstClient.INSTANCE.eventManager.add(RenderListener.class, this);
    }

    @Override
    public void onRender() {
        for (BlockPos blockPos : this.matchingBlocks) {
            RenderUtils.searchBox(blockPos);
        }
    }

    @Override
    public void onUpdate() {
        this.updateMS();
        if (this.hasTimePassedM(3000L)) {
            this.matchingBlocks.clear();
            int y = this.range;
            while (y >= -this.range) {
                int x = this.range;
                while (x >= -this.range) {
                    int z = this.range;
                    while (z >= -this.range) {
                        int posX = (int)(Minecraft.getMinecraft().thePlayer.posX + (double)x);
                        int posY = (int)(Minecraft.getMinecraft().thePlayer.posY + (double)y);
                        int posZ = (int)(Minecraft.getMinecraft().thePlayer.posZ + (double)z);
                        BlockPos pos = new BlockPos(posX, posY, posZ);
                        if (Block.getIdFromBlock(Minecraft.getMinecraft().theWorld.getBlockState(pos).getBlock()) == WurstClient.INSTANCE.options.searchID) {
                            this.matchingBlocks.add(pos);
                        }
                        if (this.matchingBlocks.size() >= this.maxBlocks) break;
                        --z;
                    }
                    if (this.matchingBlocks.size() >= this.maxBlocks) break;
                    --x;
                }
                if (this.matchingBlocks.size() >= this.maxBlocks) break;
                --y;
            }
            if (this.matchingBlocks.size() >= this.maxBlocks && this.notify) {
                WurstClient.INSTANCE.chat.warning(String.valueOf(this.getName()) + " found \u00a7lA LOT\u00a7r of blocks.");
                WurstClient.INSTANCE.chat.message("To prevent lag, it will only show the first " + this.maxBlocks + " blocks.");
                this.notify = false;
            } else if (this.matchingBlocks.size() < this.maxBlocks) {
                this.notify = true;
            }
            this.updateLastMS();
        }
    }

    @Override
    public void onDisable() {
        WurstClient.INSTANCE.eventManager.remove(UpdateListener.class, this);
        WurstClient.INSTANCE.eventManager.remove(RenderListener.class, this);
    }
}

