/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.network.play.client.C07PacketPlayerDigging;
import net.minecraft.network.play.client.C0APacketAnimation;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import tk.wurst_client.WurstClient;
import tk.wurst_client.events.listeners.RenderListener;
import tk.wurst_client.events.listeners.UpdateListener;
import tk.wurst_client.mods.AutoToolMod;
import tk.wurst_client.mods.FastBreakMod;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.mods.NukerLegitMod;
import tk.wurst_client.mods.NukerMod;
import tk.wurst_client.mods.SpeedNukerMod;
import tk.wurst_client.mods.YesCheatMod;
import tk.wurst_client.utils.BlockUtils;
import tk.wurst_client.utils.RenderUtils;

@Mod.Info(category=Mod.Category.BLOCKS, description="Digs a 3x3 tunnel around you.", name="Tunneller")
public class TunnellerMod
extends Mod
implements RenderListener,
UpdateListener {
    private static Block currentBlock;
    private float currentDamage;
    private EnumFacing side = EnumFacing.UP;
    private byte blockHitDelay = 0;
    private BlockPos pos;
    private boolean shouldRenderESP;
    private int oldSlot = -1;

    @Override
    public void onEnable() {
        if (WurstClient.INSTANCE.modManager.getModByClass(NukerMod.class).isEnabled()) {
            WurstClient.INSTANCE.modManager.getModByClass(NukerMod.class).setEnabled(false);
        }
        if (WurstClient.INSTANCE.modManager.getModByClass(NukerLegitMod.class).isEnabled()) {
            WurstClient.INSTANCE.modManager.getModByClass(NukerLegitMod.class).setEnabled(false);
        }
        if (WurstClient.INSTANCE.modManager.getModByClass(SpeedNukerMod.class).isEnabled()) {
            WurstClient.INSTANCE.modManager.getModByClass(SpeedNukerMod.class).setEnabled(false);
        }
        WurstClient.INSTANCE.eventManager.add(UpdateListener.class, this);
        WurstClient.INSTANCE.eventManager.add(RenderListener.class, this);
    }

    @Override
    public void onRender() {
        if (this.blockHitDelay == 0 && this.shouldRenderESP) {
            if (!Minecraft.getMinecraft().thePlayer.capabilities.isCreativeMode && currentBlock.getPlayerRelativeBlockHardness(Minecraft.getMinecraft().thePlayer, Minecraft.getMinecraft().theWorld, this.pos) < 1.0f) {
                RenderUtils.nukerBox(this.pos, this.currentDamage);
            } else {
                RenderUtils.nukerBox(this.pos, 1.0f);
            }
        }
    }

    @Override
    public void onUpdate() {
        this.shouldRenderESP = false;
        BlockPos newPos = this.find();
        if (newPos == null) {
            if (this.oldSlot != -1) {
                Minecraft.getMinecraft().thePlayer.inventory.currentItem = this.oldSlot;
                this.oldSlot = -1;
            }
            return;
        }
        if (this.pos == null || !this.pos.equals(newPos)) {
            this.currentDamage = 0.0f;
        }
        this.pos = newPos;
        currentBlock = Minecraft.getMinecraft().theWorld.getBlockState(this.pos).getBlock();
        if (this.blockHitDelay > 0) {
            this.blockHitDelay = (byte)(this.blockHitDelay - 1);
            return;
        }
        BlockUtils.faceBlockPacket(this.pos);
        if (this.currentDamage == 0.0f) {
            Minecraft.getMinecraft().thePlayer.sendQueue.addToSendQueue(new C07PacketPlayerDigging(C07PacketPlayerDigging.Action.START_DESTROY_BLOCK, this.pos, this.side));
            if (WurstClient.INSTANCE.modManager.getModByClass(AutoToolMod.class).isActive() && this.oldSlot == -1) {
                this.oldSlot = Minecraft.getMinecraft().thePlayer.inventory.currentItem;
            }
            if (Minecraft.getMinecraft().thePlayer.capabilities.isCreativeMode || currentBlock.getPlayerRelativeBlockHardness(Minecraft.getMinecraft().thePlayer, Minecraft.getMinecraft().theWorld, this.pos) >= 1.0f) {
                this.currentDamage = 0.0f;
                if (Minecraft.getMinecraft().thePlayer.capabilities.isCreativeMode && !WurstClient.INSTANCE.modManager.getModByClass(YesCheatMod.class).isActive()) {
                    this.nukeAll();
                } else {
                    this.shouldRenderESP = true;
                    Minecraft.getMinecraft().thePlayer.swingItem();
                    Minecraft.getMinecraft().playerController.onPlayerDestroyBlock(this.pos, this.side);
                }
                return;
            }
        }
        if (WurstClient.INSTANCE.modManager.getModByClass(AutoToolMod.class).isActive()) {
            AutoToolMod.setSlot(this.pos);
        }
        Minecraft.getMinecraft().thePlayer.sendQueue.addToSendQueue(new C0APacketAnimation());
        this.shouldRenderESP = true;
        BlockUtils.faceBlockPacket(this.pos);
        this.currentDamage += currentBlock.getPlayerRelativeBlockHardness(Minecraft.getMinecraft().thePlayer, Minecraft.getMinecraft().theWorld, this.pos) * (WurstClient.INSTANCE.modManager.getModByClass(FastBreakMod.class).isActive() && WurstClient.INSTANCE.options.fastbreakMode == 0 ? ((FastBreakMod)WurstClient.INSTANCE.modManager.getModByClass(FastBreakMod.class)).speed : 1.0f);
        Minecraft.getMinecraft().theWorld.sendBlockBreakProgress(Minecraft.getMinecraft().thePlayer.getEntityId(), this.pos, (int)(this.currentDamage * 10.0f) - 1);
        if (this.currentDamage >= 1.0f) {
            Minecraft.getMinecraft().thePlayer.sendQueue.addToSendQueue(new C07PacketPlayerDigging(C07PacketPlayerDigging.Action.STOP_DESTROY_BLOCK, this.pos, this.side));
            Minecraft.getMinecraft().playerController.onPlayerDestroyBlock(this.pos, this.side);
            this.blockHitDelay = (byte)4;
            this.currentDamage = 0.0f;
        } else if (WurstClient.INSTANCE.modManager.getModByClass(FastBreakMod.class).isActive() && WurstClient.INSTANCE.options.fastbreakMode == 1) {
            Minecraft.getMinecraft().thePlayer.sendQueue.addToSendQueue(new C07PacketPlayerDigging(C07PacketPlayerDigging.Action.STOP_DESTROY_BLOCK, this.pos, this.side));
        }
    }

    @Override
    public void onDisable() {
        WurstClient.INSTANCE.eventManager.remove(UpdateListener.class, this);
        WurstClient.INSTANCE.eventManager.remove(RenderListener.class, this);
        if (this.oldSlot != -1) {
            Minecraft.getMinecraft().thePlayer.inventory.currentItem = this.oldSlot;
            this.oldSlot = -1;
        }
        this.currentDamage = 0.0f;
        this.shouldRenderESP = false;
    }

    private BlockPos find() {
        BlockPos closest = null;
        float closestDistance = 16.0f;
        int y = 2;
        while (y >= 0) {
            int x = 1;
            while (x >= -1) {
                int z = 1;
                while (z >= -1) {
                    if (Minecraft.getMinecraft().thePlayer != null) {
                        int posX = (int)(Math.floor(Minecraft.getMinecraft().thePlayer.posX) + (double)x);
                        int posY = (int)(Math.floor(Minecraft.getMinecraft().thePlayer.posY) + (double)y);
                        int posZ = (int)(Math.floor(Minecraft.getMinecraft().thePlayer.posZ) + (double)z);
                        BlockPos blockPos = new BlockPos(posX, posY, posZ);
                        Block block = Minecraft.getMinecraft().theWorld.getBlockState(blockPos).getBlock();
                        float xDiff = (float)(Minecraft.getMinecraft().thePlayer.posX - (double)posX);
                        float yDiff = (float)(Minecraft.getMinecraft().thePlayer.posY - (double)posY);
                        float zDiff = (float)(Minecraft.getMinecraft().thePlayer.posZ - (double)posZ);
                        float currentDistance = xDiff + yDiff + zDiff;
                        MovingObjectPosition fakeObjectMouseOver = Minecraft.getMinecraft().objectMouseOver;
                        if (fakeObjectMouseOver != null) {
                            fakeObjectMouseOver.setBlockPos(blockPos);
                            if (!(Block.getIdFromBlock(block) == 0 || posY < 0 || WurstClient.INSTANCE.options.nukerMode == 3 && block.getPlayerRelativeBlockHardness(Minecraft.getMinecraft().thePlayer, Minecraft.getMinecraft().theWorld, blockPos) < 1.0f)) {
                                this.side = fakeObjectMouseOver.sideHit;
                                if (closest == null) {
                                    closest = blockPos;
                                    closestDistance = currentDistance;
                                } else if (currentDistance < closestDistance) {
                                    closest = blockPos;
                                    closestDistance = currentDistance;
                                }
                            }
                        }
                    }
                    --z;
                }
                --x;
            }
            --y;
        }
        return closest;
    }

    private void nukeAll() {
        int y = 2;
        while (y >= 0) {
            int x = 1;
            while (x >= -1) {
                int z = 1;
                while (z >= -1) {
                    int posX = (int)(Math.floor(Minecraft.getMinecraft().thePlayer.posX) + (double)x);
                    int posY = (int)(Math.floor(Minecraft.getMinecraft().thePlayer.posY) + (double)y);
                    int posZ = (int)(Math.floor(Minecraft.getMinecraft().thePlayer.posZ) + (double)z);
                    BlockPos blockPos = new BlockPos(posX, posY, posZ);
                    Block block = Minecraft.getMinecraft().theWorld.getBlockState(blockPos).getBlock();
                    MovingObjectPosition fakeObjectMouseOver = Minecraft.getMinecraft().objectMouseOver;
                    fakeObjectMouseOver.setBlockPos(blockPos);
                    if (!(Block.getIdFromBlock(block) == 0 || posY < 0 || WurstClient.INSTANCE.options.nukerMode == 3 && block.getPlayerRelativeBlockHardness(Minecraft.getMinecraft().thePlayer, Minecraft.getMinecraft().theWorld, blockPos) < 1.0f)) {
                        this.side = fakeObjectMouseOver.sideHit;
                        this.shouldRenderESP = true;
                        BlockUtils.faceBlockPacket(this.pos);
                        Minecraft.getMinecraft().thePlayer.sendQueue.addToSendQueue(new C07PacketPlayerDigging(C07PacketPlayerDigging.Action.START_DESTROY_BLOCK, blockPos, this.side));
                        block.onBlockDestroyedByPlayer(Minecraft.getMinecraft().theWorld, blockPos, Minecraft.getMinecraft().theWorld.getBlockState(blockPos));
                    }
                    --z;
                }
                --x;
            }
            --y;
        }
    }
}

