/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.options.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import tk.wurst_client.WurstClient;
import tk.wurst_client.options.Options;
import tk.wurst_client.options.gui.GuiKeybindManager;
import tk.wurst_client.options.gui.GuiXRayBlocksManager;
import tk.wurst_client.utils.MiscUtils;

public class GuiWurstOptions
extends GuiScreen {
    private GuiScreen prevMenu;
    private String[] modListModes = new String[]{"Auto", "Count", "Hidden"};
    private String[] toolTips = new String[]{"", "Manage your friends by clicking them\nwith the middle mouse button.", "How the mod list under the Wurst logo\nshould be displayed.\n\u00a7nModes\u00a7r:\n\u00a7lAuto\u00a7r: Renders the whole list if it fits\nonto the screen.\n\u00a7lCount\u00a7r: Only renders the number of active\nmods.\n\u00a7lHidden\u00a7r: Renders nothing.", "Automatically maximizes the Minecraft window.\nWindows & Linux only!", "Whether or not the Wurst news should be\nshown in the main menu", "Sends anonymous usage statistics that help us\nimprove the Wurst Client.", "Manager for the keybinds", "Manager for the blocks that X-Ray will\nshow", "", "", "", "The official Website of the Wurst Client", "Frequently asked questions", "", "", ""};
    private boolean autoMaximize;

    public GuiWurstOptions(GuiScreen par1GuiScreen) {
        this.prevMenu = par1GuiScreen;
    }

    @Override
    public void initGui() {
        this.autoMaximize = WurstClient.INSTANCE.fileManager.loadAutoMaximize();
        this.buttonList.clear();
        this.buttonList.add(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 144 - 16, 200, 20, "Back"));
        this.buttonList.add(new GuiButton(1, this.width / 2 - 154, this.height / 4 + 24 - 16, 100, 20, "Click Friends: " + (WurstClient.INSTANCE.options.middleClickFriends ? "ON" : "OFF")));
        this.buttonList.add(new GuiButton(2, this.width / 2 - 154, this.height / 4 + 48 - 16, 100, 20, "Mod List: " + this.modListModes[WurstClient.INSTANCE.options.modListMode]));
        this.buttonList.add(new GuiButton(3, this.width / 2 - 154, this.height / 4 + 72 - 16, 100, 20, "AutoMaximize: " + (this.autoMaximize ? "ON" : "OFF")));
        this.buttonList.add(new GuiButton(4, this.width / 2 - 154, this.height / 4 + 96 - 16, 100, 20, "Wurst news: " + (WurstClient.INSTANCE.options.wurstNews ? "ON" : "OFF")));
        this.buttonList.add(new GuiButton(5, this.width / 2 - 154, this.height / 4 + 120 - 16, 100, 20, "Analytics: " + (WurstClient.INSTANCE.options.google_analytics.enabled ? "ON" : "OFF")));
        this.buttonList.add(new GuiButton(6, this.width / 2 - 50, this.height / 4 + 24 - 16, 100, 20, "Keybinds"));
        this.buttonList.add(new GuiButton(7, this.width / 2 - 50, this.height / 4 + 48 - 16, 100, 20, "X-Ray Blocks"));
        this.buttonList.add(new GuiButton(11, this.width / 2 + 54, this.height / 4 + 24 - 16, 100, 20, "Wurst Website"));
        this.buttonList.add(new GuiButton(12, this.width / 2 + 54, this.height / 4 + 48 - 16, 100, 20, "FAQ"));
        this.buttonList.add(new GuiButton(13, this.width / 2 + 54, this.height / 4 + 72 - 16, 100, 20, "Report a Bug"));
        this.buttonList.add(new GuiButton(14, this.width / 2 + 54, this.height / 4 + 96 - 16, 100, 20, "Suggest a Feature"));
        ((GuiButton)this.buttonList.get((int)4)).enabled = !Minecraft.isRunningOnMac;
    }

    @Override
    protected void actionPerformed(GuiButton clickedButton) {
        if (clickedButton.enabled) {
            if (clickedButton.id == 0) {
                mc.displayGuiScreen(this.prevMenu);
            } else if (clickedButton.id == 1) {
                WurstClient.INSTANCE.options.middleClickFriends = !WurstClient.INSTANCE.options.middleClickFriends;
                clickedButton.displayString = "Click Friends: " + (WurstClient.INSTANCE.options.middleClickFriends ? "ON" : "OFF");
                WurstClient.INSTANCE.fileManager.saveOptions();
                WurstClient.INSTANCE.analytics.trackEvent("options", "click friends", WurstClient.INSTANCE.options.middleClickFriends ? "ON" : "OFF");
            } else if (clickedButton.id == 2) {
                ++WurstClient.INSTANCE.options.modListMode;
                if (WurstClient.INSTANCE.options.modListMode > 2) {
                    WurstClient.INSTANCE.options.modListMode = 0;
                }
                clickedButton.displayString = "Mod List: " + this.modListModes[WurstClient.INSTANCE.options.modListMode];
                WurstClient.INSTANCE.fileManager.saveOptions();
                WurstClient.INSTANCE.analytics.trackEvent("options", "mod list", this.modListModes[WurstClient.INSTANCE.options.modListMode]);
            } else if (clickedButton.id == 3) {
                this.autoMaximize = !this.autoMaximize;
                clickedButton.displayString = "AutoMaximize: " + (this.autoMaximize ? "ON" : "OFF");
                WurstClient.INSTANCE.fileManager.saveAutoMaximize(this.autoMaximize);
                WurstClient.INSTANCE.analytics.trackEvent("options", "automaximize", this.autoMaximize ? "ON" : "OFF");
            } else if (clickedButton.id == 4) {
                WurstClient.INSTANCE.options.wurstNews = !WurstClient.INSTANCE.options.wurstNews;
                clickedButton.displayString = "Wurst news: " + (WurstClient.INSTANCE.options.wurstNews ? "ON" : "OFF");
                WurstClient.INSTANCE.fileManager.saveOptions();
                WurstClient.INSTANCE.analytics.trackEvent("options", "wurst news", WurstClient.INSTANCE.options.wurstNews ? "ON" : "OFF");
            } else if (clickedButton.id == 5) {
                Options.GoogleAnalytics analytics = WurstClient.INSTANCE.options.google_analytics;
                if (analytics.enabled) {
                    WurstClient.INSTANCE.analytics.trackEvent("options", "analytics", "disable");
                }
                boolean bl = analytics.enabled = !analytics.enabled;
                if (analytics.enabled) {
                    WurstClient.INSTANCE.analytics.trackEvent("options", "analytics", "enable");
                }
                clickedButton.displayString = "Analytics: " + (analytics.enabled ? "ON" : "OFF");
                WurstClient.INSTANCE.fileManager.saveOptions();
            } else if (clickedButton.id == 6) {
                mc.displayGuiScreen(new GuiKeybindManager(this));
            } else if (clickedButton.id == 7) {
                mc.displayGuiScreen(new GuiXRayBlocksManager(this));
            } else if (clickedButton.id != 8 && clickedButton.id != 9 && clickedButton.id != 10) {
                if (clickedButton.id == 11) {
                    MiscUtils.openLink("http://www.wurst-client.tk/");
                    WurstClient.INSTANCE.analytics.trackEvent("options", "wurst client website");
                } else if (clickedButton.id == 12) {
                    MiscUtils.openLink("http://www.wurst-client.tk/faq");
                    WurstClient.INSTANCE.analytics.trackEvent("options", "faq");
                } else if (clickedButton.id == 13) {
                    MiscUtils.openLink("http://www.wurst-client.tk/bugs");
                    WurstClient.INSTANCE.analytics.trackEvent("options", "bug report");
                } else if (clickedButton.id == 14) {
                    MiscUtils.openLink("http://www.wurst-client.tk/ideas");
                    WurstClient.INSTANCE.analytics.trackEvent("options", "suggestion");
                } else {
                    int cfr_ignored_0 = clickedButton.id;
                }
            }
        }
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
    }

    @Override
    public void drawScreen(int par1, int par2, float par3) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRendererObj, "Wurst Options", this.width / 2, 40, 0xFFFFFF);
        this.drawCenteredString(this.fontRendererObj, "Settings", this.width / 2 - 104, this.height / 4 + 24 - 28, 0xCCCCCC);
        this.drawCenteredString(this.fontRendererObj, "Managers", this.width / 2, this.height / 4 + 24 - 28, 0xCCCCCC);
        this.drawCenteredString(this.fontRendererObj, "Online", this.width / 2 + 104, this.height / 4 + 24 - 28, 0xCCCCCC);
        super.drawScreen(par1, par2, par3);
        int i = 0;
        while (i < this.buttonList.size()) {
            GuiButton button = (GuiButton)this.buttonList.get(i);
            if (button.isMouseOver() && !this.toolTips[button.id].isEmpty()) {
                ArrayList toolTip = Lists.newArrayList((Object[])this.toolTips[button.id].split("\n"));
                this.drawHoveringText(toolTip, par1, par2);
                break;
            }
            ++i;
        }
    }
}

