/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.options.gui;

import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import tk.wurst_client.WurstClient;
import tk.wurst_client.mods.XRayMod;
import tk.wurst_client.options.gui.GuiXRayBlocksList;

public class GuiXRayBlocksAdd
extends GuiScreen {
    private GuiScreen prevMenu;
    private GuiTextField nameBox;

    public GuiXRayBlocksAdd(GuiScreen par1GuiScreen) {
        this.prevMenu = par1GuiScreen;
    }

    @Override
    public void updateScreen() {
        this.nameBox.updateCursorCounter();
        Block block = Block.getBlockFromName(this.nameBox.getText());
        ((GuiButton)this.buttonList.get((int)0)).enabled = this.nameBox.getText().trim().length() > 0 && block != null;
    }

    @Override
    public void initGui() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonList.clear();
        this.buttonList.add(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 120 + 12, "Add"));
        this.buttonList.add(new GuiButton(1, this.width / 2 - 100, this.height / 4 + 144 + 12, "Cancel"));
        this.nameBox = new GuiTextField(0, this.fontRendererObj, this.width / 2 - 100, 80, 200, 20);
        this.nameBox.setFocused(true);
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    protected void actionPerformed(GuiButton clickedButton) {
        if (clickedButton.enabled) {
            if (clickedButton.id == 0) {
                Block block = Block.getBlockFromName(this.nameBox.getText());
                XRayMod.xrayBlocks.add(block);
                GuiXRayBlocksList.sortBlocks();
                WurstClient.INSTANCE.fileManager.saveXRayBlocks();
                mc.displayGuiScreen(this.prevMenu);
                WurstClient.INSTANCE.analytics.trackEvent("x-ray blocks", "add", Integer.toString(Block.getIdFromBlock(block)));
            } else if (clickedButton.id == 1) {
                mc.displayGuiScreen(this.prevMenu);
            }
        }
    }

    @Override
    protected void keyTyped(char par1, int par2) {
        this.nameBox.textboxKeyTyped(par1, par2);
        if (par2 == 28 || par2 == 156) {
            this.actionPerformed((GuiButton)this.buttonList.get(0));
        }
    }

    @Override
    protected void mouseClicked(int par1, int par2, int par3) throws IOException {
        super.mouseClicked(par1, par2, par3);
        this.nameBox.mouseClicked(par1, par2, par3);
    }

    @Override
    public void drawScreen(int par1, int par2, float par3) {
        this.drawDefaultBackground();
        this.drawBackground(0);
        Block block = Block.getBlockFromName(this.nameBox.getText());
        int x = this.width / 2 - 9;
        int y = this.height / 2 - 32;
        ItemStack itemStack = new ItemStack(Item.getItemFromBlock(block));
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableBlend();
        RenderHelper.enableGUIStandardItemLighting();
        GlStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
        if (itemStack.getItem() != null) {
            try {
                Minecraft.getMinecraft().getRenderItem().renderItemAndEffectIntoGUI(itemStack, x, y);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            GuiXRayBlocksAdd.mc.fontRendererObj.drawString("?", x + 6, y + 5, 0xA0A0A0);
        }
        Minecraft.getMinecraft().getRenderItem().func_175030_a(Minecraft.getMinecraft().fontRendererObj, itemStack, x + 4, y + 4);
        RenderHelper.disableStandardItemLighting();
        GlStateManager.disableRescaleNormal();
        GlStateManager.disableBlend();
        try {
            this.drawCenteredString(this.fontRendererObj, "Name: " + (itemStack.getItem() == null ? block.getLocalizedName() : itemStack.getDisplayName()), this.width / 2, y + 24, 0xA0A0A0);
            this.drawCenteredString(this.fontRendererObj, "ID: " + Block.getIdFromBlock(block), this.width / 2, y + 36, 0xA0A0A0);
            this.drawCenteredString(this.fontRendererObj, "Block exists: " + (block != null), this.width / 2, y + 48, 0xA0A0A0);
        }
        catch (Exception e) {
            GuiXRayBlocksAdd.mc.fontRendererObj.drawString("?", x + 6, y + 5, 0xA0A0A0);
            this.drawCenteredString(this.fontRendererObj, "Name: unknown", this.width / 2, y + 24, 0xA0A0A0);
            this.drawCenteredString(this.fontRendererObj, "ID: unknown", this.width / 2, y + 36, 0xA0A0A0);
            this.drawCenteredString(this.fontRendererObj, "Block exists: " + (block != null), this.width / 2, y + 48, 0xA0A0A0);
        }
        this.drawCenteredString(this.fontRendererObj, "Add a Block", this.width / 2, 20, 0xFFFFFF);
        this.drawString(this.fontRendererObj, "Name or ID", this.width / 2 - 100, 67, 0xA0A0A0);
        this.nameBox.drawTextBox();
        super.drawScreen(par1, par2, par3);
    }
}

