/*
 * Decompiled with CFR 0.152.
 */
package org.darkstorm.minecraft.gui.theme.wurst;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import org.darkstorm.minecraft.gui.component.CheckButton;
import org.darkstorm.minecraft.gui.component.Container;
import org.darkstorm.minecraft.gui.theme.AbstractComponentUI;
import org.darkstorm.minecraft.gui.theme.wurst.WurstTheme;
import org.darkstorm.minecraft.gui.util.GuiManagerDisplayScreen;
import org.darkstorm.minecraft.gui.util.RenderUtil;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class WurstCheckButtonUI
extends AbstractComponentUI<CheckButton> {
    private final WurstTheme theme;

    WurstCheckButtonUI(WurstTheme theme) {
        super(CheckButton.class);
        this.theme = theme;
        this.foreground = Color.WHITE;
        this.background = new Color(0.125f, 0.125f, 0.125f, 0.25f);
    }

    @Override
    protected void renderComponent(CheckButton button) {
        boolean hovering;
        this.translateComponent(button, false);
        Rectangle area = button.getArea();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3553);
        RenderUtil.setColor(button.getBackgroundColor());
        int size = area.height - 4;
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)2.0, (double)2.0);
        GL11.glVertex2d((double)(size + 2), (double)2.0);
        GL11.glVertex2d((double)(size + 2), (double)(size + 2));
        GL11.glVertex2d((double)2.0, (double)(size + 2));
        GL11.glEnd();
        RenderUtil.boxShadow(2.0, 2.0, size + 2, size + 2);
        Point mouse = RenderUtil.calculateMouseLocation();
        Container parent = button.getParent();
        while (parent != null) {
            mouse.x -= parent.getX();
            mouse.y -= parent.getY();
            parent = parent.getParent();
        }
        boolean bl = hovering = area.contains(mouse) && Minecraft.getMinecraft().currentScreen instanceof GuiManagerDisplayScreen;
        if (button.isSelected()) {
            GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)(hovering ? 0.5f : 0.375f));
            GL11.glBegin((int)7);
            GL11.glVertex2d((double)4.0, (double)(size / 2 + 2));
            GL11.glVertex2d((double)(size / 2 + 1), (double)(size - 1));
            GL11.glVertex2d((double)(size / 2 + 1), (double)(size + 1));
            GL11.glVertex2d((double)3.0, (double)(size / 2 + 3));
            GL11.glVertex2d((double)size, (double)3.0);
            GL11.glVertex2d((double)(size + 1), (double)4.0);
            GL11.glVertex2d((double)(size / 2 + 1), (double)(size + 1));
            GL11.glVertex2d((double)(size / 2 + 1), (double)(size - 1));
            GL11.glEnd();
            GL11.glColor4f((float)0.125f, (float)0.125f, (float)0.125f, (float)(hovering ? 0.75f : 0.5f));
            GL11.glBegin((int)2);
            GL11.glVertex2d((double)4.0, (double)(size / 2 + 2));
            GL11.glVertex2d((double)(size / 2 + 1), (double)(size - 1));
            GL11.glVertex2d((double)size, (double)3.0);
            GL11.glVertex2d((double)(size + 1), (double)4.0);
            GL11.glVertex2d((double)(size / 2 + 1), (double)(size + 1));
            GL11.glVertex2d((double)3.0, (double)(size / 2 + 3));
            GL11.glEnd();
        }
        if (hovering) {
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)(Mouse.isButtonDown((int)0) ? 0.3f : 0.2f));
            GL11.glBegin((int)7);
            GL11.glVertex2d((double)0.0, (double)0.0);
            GL11.glVertex2d((double)area.width, (double)0.0);
            GL11.glVertex2d((double)area.width, (double)area.height);
            GL11.glVertex2d((double)0.0, (double)area.height);
            GL11.glEnd();
        }
        GL11.glEnable((int)3553);
        String text = button.getText();
        this.theme.getFontRenderer().drawString(text, size + 4, area.height / 2 - this.theme.getFontRenderer().FONT_HEIGHT / 2, RenderUtil.toRGBA(button.getForegroundColor()));
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        this.translateComponent(button, true);
    }

    @Override
    protected Dimension getDefaultComponentSize(CheckButton component) {
        return new Dimension(this.theme.getFontRenderer().getStringWidth(component.getText()) + this.theme.getFontRenderer().FONT_HEIGHT + 6, this.theme.getFontRenderer().FONT_HEIGHT + 4);
    }

    @Override
    protected Rectangle[] getInteractableComponentRegions(CheckButton component) {
        return new Rectangle[]{new Rectangle(0, 0, component.getWidth(), component.getHeight())};
    }

    @Override
    protected void handleComponentInteraction(CheckButton component, Point location, int button) {
        if (location.x <= component.getWidth() && location.y <= component.getHeight() && button == 0) {
            component.press();
        }
    }
}

