/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.ai;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.util.BlockPos;
import tk.wurst_client.ai.PathUtils;

public class PathPoint {
    private BlockPos pos;
    private PathPoint previous;
    private int priority;
    private int movementCost;

    public PathPoint(BlockPos pos, PathPoint previous, int movementCost, int priority) {
        this.pos = pos;
        this.previous = previous;
        this.movementCost = movementCost;
        this.priority = priority;
    }

    public ArrayList<BlockPos> getNeighbors() {
        BlockPos playerPos = new BlockPos(Minecraft.getMinecraft().thePlayer);
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>();
        neighbors.add(this.pos.add(0, 0, -1));
        neighbors.add(this.pos.add(0, 0, 1));
        neighbors.add(this.pos.add(1, 0, 0));
        neighbors.add(this.pos.add(-1, 0, 0));
        int i = neighbors.size() - 1;
        while (i > -1) {
            BlockPos neighbor = (BlockPos)neighbors.get(i);
            if (!PathUtils.isSafe(neighbor) || !PathUtils.isSafe(neighbor.add(0, 1, 0)) || Math.abs(playerPos.getX() - neighbor.getX()) > 256 || Math.abs(playerPos.getZ() - neighbor.getZ()) > 256) {
                neighbors.remove(i);
            } else if (!PathUtils.isFlyable(neighbor)) {
                if (!PathUtils.isFallable(neighbor)) {
                    neighbors.remove(i);
                } else if (!PathUtils.isSolid(this.pos.add(0, -1, 0))) {
                    if (!PathUtils.isSolid(neighbor.add(0, -1, 0))) {
                        neighbors.remove(i);
                    } else if (this.previous == null || PathUtils.isSolid(this.previous.getPos().add(0, -1, 0)) && this.previous.getPos().getY() >= this.pos.getY()) {
                        neighbors.remove(i);
                    }
                }
            }
            --i;
        }
        neighbors.add(this.pos.add(0, -1, 0));
        if (PathUtils.isFlyable(this.pos) || PathUtils.isClimbable(this.pos)) {
            neighbors.add(this.pos.add(0, 1, 0));
        }
        return neighbors;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public PathPoint getPrevious() {
        return this.previous;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getMovementCost() {
        return this.movementCost;
    }
}

