/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.bot.commands;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class Command {
    private String name = this.getClass().getAnnotation(Info.class).name();
    private String help = this.getClass().getAnnotation(Info.class).help();
    private String[] syntax = this.getClass().getAnnotation(Info.class).syntax();

    public String getName() {
        return this.name;
    }

    public String getHelp() {
        return this.help;
    }

    public String[] getSyntax() {
        return this.syntax;
    }

    public void printHelp() {
        String[] stringArray = this.help.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            System.out.println(line);
            ++n2;
        }
    }

    public void printSyntax() {
        System.out.println("Syntax:");
        String output = this.name;
        if (this.syntax.length != 0) {
            output = String.valueOf(output) + " ";
            String spaces = "";
            while (spaces.length() < output.length()) {
                spaces = String.valueOf(spaces) + " ";
            }
            output = String.valueOf(output) + this.syntax[0];
            int i = 1;
            while (i < this.syntax.length) {
                output = String.valueOf(output) + "\n" + spaces + this.syntax[i];
                ++i;
            }
        }
        String[] stringArray = output.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            System.out.println(line);
            ++n2;
        }
    }

    protected final void syntaxError() throws SyntaxError {
        throw new SyntaxError();
    }

    protected final void syntaxError(String message) throws SyntaxError {
        throw new SyntaxError(message);
    }

    protected final void error(String message) throws Error {
        throw new Error(message);
    }

    public abstract void execute(String[] var1) throws Error;

    public class Error
    extends Throwable {
        public Error() {
        }

        public Error(String message) {
            super(message);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Info {
        public String name();

        public String help();

        public String[] syntax();
    }

    public class SyntaxError
    extends Error {
        public SyntaxError() {
        }

        public SyntaxError(String message) {
            super(message);
        }
    }
}

