/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.bot.commands;

import java.util.Iterator;
import tk.wurst_client.bot.WurstBot;
import tk.wurst_client.bot.commands.Command;
import tk.wurst_client.utils.MiscUtils;

@Command.Info(help="Shows the command list or the help for a command.", name="help", syntax={"[<page>]", "[<command>]"})
public class HelpCmd
extends Command {
    @Override
    public void execute(String[] args) throws Command.Error {
        if (args.length == 0) {
            this.execute(new String[]{"1"});
            return;
        }
        int pages = (int)Math.ceil((double)WurstBot.getBot().getCommandManager().countCommands() / 8.0);
        if (MiscUtils.isInteger(args[0])) {
            int page = Integer.valueOf(args[0]);
            if (page > pages || page < 1) {
                this.syntaxError("Invalid page: " + page);
            }
            System.out.println("Available commands: " + WurstBot.getBot().getCommandManager().countCommands());
            System.out.println("Command list (page " + page + "/" + pages + "):");
            Iterator<Command> itr = WurstBot.getBot().getCommandManager().getAllCommands().iterator();
            int i = 0;
            while (itr.hasNext()) {
                Command cmd = itr.next();
                if (i >= (page - 1) * 8 && i < (page - 1) * 8 + 8) {
                    System.out.println(cmd.getName());
                }
                ++i;
            }
        } else {
            Command cmd = WurstBot.getBot().getCommandManager().getCommandByName(args[0]);
            if (cmd != null) {
                System.out.println("Available help for \"" + args[0] + "\":");
                cmd.printHelp();
                cmd.printSyntax();
            } else {
                this.syntaxError();
            }
        }
    }
}

