/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.commands;

import net.minecraft.client.Minecraft;
import net.minecraft.network.play.client.C03PacketPlayer;
import net.minecraft.util.BlockPos;
import tk.wurst_client.WurstClient;
import tk.wurst_client.ai.PathUtils;
import tk.wurst_client.commands.Cmd;
import tk.wurst_client.mods.YesCheatMod;
import tk.wurst_client.utils.MiscUtils;

@Cmd.Info(help="Applies the given amount of damage.", name="damage", syntax={"<amount>"})
public class DamageCmd
extends Cmd {
    @Override
    public void execute(String[] args) throws Cmd.Error {
        int dmg;
        if (args.length == 0) {
            this.syntaxError();
        }
        if (!MiscUtils.isInteger(args[0])) {
            this.syntaxError("Amount must be a number.");
        }
        if (Minecraft.getMinecraft().thePlayer.isOnLadder()) {
            this.error("Cannot damage while climbing ladders.");
        }
        if (!Minecraft.getMinecraft().thePlayer.onGround) {
            this.error("Cannot damage in mid-air.");
        }
        if (Minecraft.getMinecraft().thePlayer.capabilities.isCreativeMode) {
            this.error("Cannot damage in creative mode.");
        }
        if ((dmg = Integer.parseInt(args[0])) < 1) {
            this.error("Amount must be at least 1.");
        }
        if (dmg > 40) {
            this.error("Amount must be at most 40.");
        }
        double x = Minecraft.getMinecraft().thePlayer.posX;
        double y = Minecraft.getMinecraft().thePlayer.posY;
        double z = Minecraft.getMinecraft().thePlayer.posZ;
        if (WurstClient.INSTANCE.modManager.getModByClass(YesCheatMod.class).isEnabled()) {
            Minecraft.getMinecraft().getNetHandler().addToSendQueue(new C03PacketPlayer.C04PacketPlayerPosition(x, y + 0.3, z, false));
            Minecraft.getMinecraft().getNetHandler().addToSendQueue(new C03PacketPlayer.C04PacketPlayerPosition(x, y - 3.1 - (double)dmg, z, false));
            Minecraft.getMinecraft().getNetHandler().addToSendQueue(new C03PacketPlayer.C04PacketPlayerPosition(x, y, z, true));
        } else {
            int i = 1;
            while (i < dmg + 5) {
                if (PathUtils.isSolid(new BlockPos(x, y + (double)i, z))) {
                    if (i < 6) {
                        this.error("Not enough space. Cannot apply any damage.");
                    } else {
                        WurstClient.INSTANCE.chat.warning("Not enough space. Can only apply " + (i - 5) + " of " + dmg + " damage.");
                        dmg = i - 6;
                        break;
                    }
                }
                ++i;
            }
            i = 1;
            while (i < dmg + 5) {
                Minecraft.getMinecraft().getNetHandler().addToSendQueue(new C03PacketPlayer.C04PacketPlayerPosition(x, y + (double)i, z, false));
                ++i;
            }
            i = dmg + 4;
            while (i > 0) {
                Minecraft.getMinecraft().getNetHandler().addToSendQueue(new C03PacketPlayer.C04PacketPlayerPosition(x, y + (double)i, z, false));
                --i;
            }
            Minecraft.getMinecraft().getNetHandler().addToSendQueue(new C03PacketPlayer.C04PacketPlayerPosition(x, y, z, true));
        }
    }
}

