/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.commands;

import net.minecraft.util.BlockPos;
import tk.wurst_client.WurstClient;
import tk.wurst_client.ai.PathFinder;
import tk.wurst_client.ai.PathPoint;
import tk.wurst_client.commands.Cmd;
import tk.wurst_client.events.listeners.RenderListener;
import tk.wurst_client.utils.RenderUtils;

@Cmd.Info(help="Shows the shortest path to a specific point. Useful for labyrinths and caves.", name="path", syntax={"<x> <y> <z>", "<entity>"})
public class PathCmd
extends Cmd
implements RenderListener {
    private PathPoint path;
    private boolean enabled;

    @Override
    public void execute(String[] args) throws Cmd.Error {
        this.path = null;
        if (this.enabled) {
            WurstClient.INSTANCE.eventManager.remove(RenderListener.class, this);
            this.enabled = false;
            return;
        }
        int[] posArray = this.argsToPos(args);
        final BlockPos pos = new BlockPos(posArray[0], posArray[1], posArray[2]);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                System.out.println("Finding path");
                long startTime = System.nanoTime();
                PathFinder pathFinder = new PathFinder(pos);
                if (pathFinder.find()) {
                    PathCmd.this.path = pathFinder.getRawPath();
                    PathCmd.this.enabled = true;
                    WurstClient.INSTANCE.eventManager.add(RenderListener.class, PathCmd.this);
                } else {
                    WurstClient.INSTANCE.chat.error("Could not find a path.");
                }
                System.out.println("Done after " + (double)(System.nanoTime() - startTime) / 1000000.0 + "ms");
            }
        });
        thread.setPriority(1);
        thread.start();
    }

    @Override
    public void onRender() {
        PathPoint path2 = this.path;
        while (path2 != null) {
            RenderUtils.blockESPBox(path2.getPos());
            path2 = path2.getPrevious();
        }
    }
}

