/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.files;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import org.darkstorm.minecraft.gui.component.Frame;
import org.darkstorm.minecraft.gui.component.basic.BasicSlider;
import tk.wurst_client.WurstClient;
import tk.wurst_client.alts.Alt;
import tk.wurst_client.alts.Encryption;
import tk.wurst_client.alts.gui.GuiAltList;
import tk.wurst_client.files.DefaultAutoBuildTemplates;
import tk.wurst_client.mods.AntiAfkMod;
import tk.wurst_client.mods.ArenaBrawlMod;
import tk.wurst_client.mods.AutoBuildMod;
import tk.wurst_client.mods.AutoSignMod;
import tk.wurst_client.mods.FightBotMod;
import tk.wurst_client.mods.FollowMod;
import tk.wurst_client.mods.ForceOpMod;
import tk.wurst_client.mods.FreecamMod;
import tk.wurst_client.mods.InvisibilityMod;
import tk.wurst_client.mods.LsdMod;
import tk.wurst_client.mods.MassTpaMod;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.mods.OpSignMod;
import tk.wurst_client.mods.ProtectMod;
import tk.wurst_client.mods.RemoteViewMod;
import tk.wurst_client.mods.SpammerMod;
import tk.wurst_client.mods.XRayMod;
import tk.wurst_client.options.Friends;
import tk.wurst_client.options.Options;
import tk.wurst_client.utils.XRayUtils;

public class FileManager {
    public final File wurstDir;
    public final File autobuildDir;
    public final File skinDir;
    public final File serverlistsDir;
    public final File spamDir;
    public final File scriptsDir;
    public final File alts;
    public final File friends;
    public final File gui;
    public final File modules;
    public final File keybinds;
    public final File sliders;
    public final File options;
    public final File autoMaximize;
    public final File xray;
    private Gson gson;
    private String[] moduleBlacklist;

    public FileManager() {
        this.wurstDir = new File(Minecraft.getMinecraft().mcDataDir, "wurst");
        this.autobuildDir = new File(this.wurstDir, "autobuild");
        this.skinDir = new File(this.wurstDir, "skins");
        this.serverlistsDir = new File(this.wurstDir, "serverlists");
        this.spamDir = new File(this.wurstDir, "spam");
        this.scriptsDir = new File(this.spamDir, "autorun");
        this.alts = new File(this.wurstDir, "alts.json");
        this.friends = new File(this.wurstDir, "friends.json");
        this.gui = new File(this.wurstDir, "gui.json");
        this.modules = new File(this.wurstDir, "modules.json");
        this.keybinds = new File(this.wurstDir, "keybinds.json");
        this.sliders = new File(this.wurstDir, "sliders.json");
        this.options = new File(this.wurstDir, "options.json");
        this.autoMaximize = new File(Minecraft.getMinecraft().mcDataDir + "/wurst/automaximize.json");
        this.xray = new File(this.wurstDir, "xray.json");
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.moduleBlacklist = new String[]{AntiAfkMod.class.getName(), ArenaBrawlMod.class.getName(), AutoBuildMod.class.getName(), AutoSignMod.class.getName(), FightBotMod.class.getName(), FollowMod.class.getName(), ForceOpMod.class.getName(), FreecamMod.class.getName(), InvisibilityMod.class.getName(), LsdMod.class.getName(), MassTpaMod.class.getName(), OpSignMod.class.getName(), ProtectMod.class.getName(), RemoteViewMod.class.getName(), SpammerMod.class.getName()};
    }

    public void init() {
        if (!this.wurstDir.exists()) {
            this.wurstDir.mkdir();
        }
        if (!this.autobuildDir.exists()) {
            this.autobuildDir.mkdir();
        }
        if (!this.spamDir.exists()) {
            this.spamDir.mkdir();
        }
        if (!this.scriptsDir.exists()) {
            this.scriptsDir.mkdir();
        }
        if (!this.skinDir.exists()) {
            this.skinDir.mkdir();
        }
        if (!this.serverlistsDir.exists()) {
            this.serverlistsDir.mkdir();
        }
        if (!this.options.exists()) {
            this.saveOptions();
        } else {
            this.loadOptions();
        }
        if (!this.modules.exists()) {
            this.saveMods();
        } else {
            this.loadMods();
        }
        if (!this.keybinds.exists()) {
            this.saveKeybinds();
        } else {
            this.loadKeybinds();
        }
        if (!this.alts.exists()) {
            this.saveAlts();
        } else {
            this.loadAlts();
        }
        if (!this.friends.exists()) {
            this.saveFriends();
        } else {
            this.loadFriends();
        }
        if (!this.xray.exists()) {
            XRayUtils.initXRayBlocks();
            this.saveXRayBlocks();
        } else {
            this.loadXRayBlocks();
        }
        File[] autobuildFiles = this.autobuildDir.listFiles();
        if (autobuildFiles != null && autobuildFiles.length == 0) {
            this.createDefaultAutoBuildTemplates();
        }
        this.loadAutoBuildTemplates();
        if (WurstClient.INSTANCE.options.autobuildMode >= AutoBuildMod.names.size()) {
            WurstClient.INSTANCE.options.autobuildMode = 0;
            this.saveOptions();
        }
    }

    public void saveGUI(Frame[] frames) {
        try {
            JsonObject json = new JsonObject();
            Frame[] frameArray = frames;
            int n = frames.length;
            int n2 = 0;
            while (n2 < n) {
                Frame frame = frameArray[n2];
                if (!frame.getTitle().equalsIgnoreCase("ArenaBrawl")) {
                    JsonObject jsonFrame = new JsonObject();
                    jsonFrame.addProperty("minimized", Boolean.valueOf(frame.isMinimized()));
                    jsonFrame.addProperty("pinned", Boolean.valueOf(frame.isPinned()));
                    jsonFrame.addProperty("posX", (Number)frame.getX());
                    jsonFrame.addProperty("posY", (Number)frame.getY());
                    json.add(frame.getTitle(), (JsonElement)jsonFrame);
                }
                ++n2;
            }
            PrintWriter save = new PrintWriter(new FileWriter(this.gui));
            save.println(this.gson.toJson((JsonElement)json));
            save.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadGUI(Frame[] frames) {
        try {
            BufferedReader load = new BufferedReader(new FileReader(this.gui));
            JsonObject json = (JsonObject)new JsonParser().parse((Reader)load);
            load.close();
            for (Map.Entry entry : json.entrySet()) {
                Frame[] frameArray = frames;
                int n = frames.length;
                int n2 = 0;
                while (n2 < n) {
                    Frame frame = frameArray[n2];
                    if (frame.getTitle().equals(entry.getKey())) {
                        JsonObject jsonFrame = (JsonObject)entry.getValue();
                        frame.setMinimized(jsonFrame.get("minimized").getAsBoolean());
                        frame.setPinned(jsonFrame.get("pinned").getAsBoolean());
                        frame.setX(jsonFrame.get("posX").getAsInt());
                        frame.setY(jsonFrame.get("posY").getAsInt());
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveMods() {
        try {
            JsonObject json = new JsonObject();
            for (Mod mod : WurstClient.INSTANCE.modManager.getAllMods()) {
                JsonObject jsonMod = new JsonObject();
                jsonMod.addProperty("enabled", Boolean.valueOf(mod.isEnabled()));
                json.add(mod.getName(), (JsonElement)jsonMod);
            }
            PrintWriter save = new PrintWriter(new FileWriter(this.modules));
            save.println(this.gson.toJson((JsonElement)json));
            save.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadMods() {
        try {
            BufferedReader load = new BufferedReader(new FileReader(this.modules));
            JsonObject json = (JsonObject)new JsonParser().parse((Reader)load);
            load.close();
            for (Map.Entry entry : json.entrySet()) {
                JsonObject jsonModule;
                boolean enabled;
                Mod mod = WurstClient.INSTANCE.modManager.getModByName((String)entry.getKey());
                if (mod == null || mod.getCategory() == Mod.Category.HIDDEN || Arrays.asList(this.moduleBlacklist).contains(mod.getClass().getName()) || !(enabled = (jsonModule = (JsonObject)entry.getValue()).get("enabled").getAsBoolean())) continue;
                mod.enableOnStartup();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveKeybinds() {
        try {
            JsonObject json = new JsonObject();
            for (Map.Entry entry : WurstClient.INSTANCE.keybinds.entrySet()) {
                json.addProperty((String)entry.getKey(), (String)entry.getValue());
            }
            PrintWriter save = new PrintWriter(new FileWriter(this.keybinds));
            save.println(this.gson.toJson((JsonElement)json));
            save.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadKeybinds() {
        try {
            BufferedReader load = new BufferedReader(new FileReader(this.keybinds));
            JsonObject json = (JsonObject)new JsonParser().parse((Reader)load);
            load.close();
            WurstClient.INSTANCE.keybinds.clear();
            for (Map.Entry entry : json.entrySet()) {
                WurstClient.INSTANCE.keybinds.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveOptions() {
        try {
            PrintWriter save = new PrintWriter(new FileWriter(this.options));
            save.println(this.gson.toJson((Object)WurstClient.INSTANCE.options));
            save.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadOptions() {
        try {
            BufferedReader load = new BufferedReader(new FileReader(this.options));
            WurstClient.INSTANCE.options = (Options)this.gson.fromJson((Reader)load, Options.class);
            load.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean loadAutoMaximize() {
        boolean autoMaximizeEnabled = false;
        if (!this.autoMaximize.exists()) {
            this.saveAutoMaximize(true);
        }
        try {
            BufferedReader load = new BufferedReader(new FileReader(this.autoMaximize));
            autoMaximizeEnabled = (Boolean)this.gson.fromJson((Reader)load, Boolean.class) != false && !Minecraft.isRunningOnMac;
            load.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return autoMaximizeEnabled;
    }

    public void saveAutoMaximize(boolean autoMaximizeEnabled) {
        try {
            if (!this.autoMaximize.getParentFile().exists()) {
                this.autoMaximize.getParentFile().mkdirs();
            }
            PrintWriter save = new PrintWriter(new FileWriter(this.autoMaximize));
            save.println(this.gson.toJson((Object)autoMaximizeEnabled));
            save.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveSliders() {
        try {
            JsonObject json = new JsonObject();
            for (Mod mod : WurstClient.INSTANCE.modManager.getAllMods()) {
                if (mod.getSliders().isEmpty()) continue;
                JsonObject jsonModule = new JsonObject();
                for (BasicSlider slider : mod.getSliders()) {
                    jsonModule.addProperty(slider.getText(), (Number)((double)(Math.round(slider.getValue() / slider.getIncrement()) * 1000000L * (long)(slider.getIncrement() * 1000000.0)) / 1000000.0 / 1000000.0));
                }
                json.add(mod.getName(), (JsonElement)jsonModule);
            }
            PrintWriter save = new PrintWriter(new FileWriter(this.sliders));
            save.println(this.gson.toJson((JsonElement)json));
            save.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadSliders() {
        try {
            BufferedReader load = new BufferedReader(new FileReader(this.sliders));
            JsonObject json = (JsonObject)new JsonParser().parse((Reader)load);
            load.close();
            for (Map.Entry entry : json.entrySet()) {
                Mod mod = WurstClient.INSTANCE.modManager.getModByName((String)entry.getKey());
                if (mod == null) continue;
                JsonObject jsonModule = (JsonObject)entry.getValue();
                for (BasicSlider slider : mod.getSliders()) {
                    try {
                        slider.setValue(jsonModule.get(slider.getText()).getAsDouble());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveAlts() {
        try {
            JsonObject json = new JsonObject();
            for (Alt alt : GuiAltList.alts) {
                JsonObject jsonAlt = new JsonObject();
                jsonAlt.addProperty("name", alt.getName());
                jsonAlt.addProperty("password", alt.getPassword());
                jsonAlt.addProperty("cracked", Boolean.valueOf(alt.isCracked()));
                jsonAlt.addProperty("starred", Boolean.valueOf(alt.isStarred()));
                json.add(alt.getEmail(), (JsonElement)jsonAlt);
            }
            Files.write(this.alts.toPath(), Encryption.encrypt(this.gson.toJson((JsonElement)json)).getBytes("UTF-8"), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadAlts() {
        try {
            JsonObject json = (JsonObject)new JsonParser().parse(Encryption.decrypt(new String(Files.readAllBytes(this.alts.toPath()), "UTF-8")));
            GuiAltList.alts.clear();
            for (Map.Entry entry : json.entrySet()) {
                boolean starred;
                JsonObject jsonAlt = ((JsonElement)entry.getValue()).getAsJsonObject();
                String email = (String)entry.getKey();
                String name = jsonAlt.get("name") == null ? "" : jsonAlt.get("name").getAsString();
                String password = jsonAlt.get("password") == null ? "" : jsonAlt.get("password").getAsString();
                boolean cracked = jsonAlt.get("cracked") == null ? true : jsonAlt.get("cracked").getAsBoolean();
                boolean bl = starred = jsonAlt.get("starred") == null ? false : jsonAlt.get("starred").getAsBoolean();
                if (cracked) {
                    GuiAltList.alts.add(new Alt(email, starred));
                    continue;
                }
                GuiAltList.alts.add(new Alt(email, name, password, starred));
            }
            GuiAltList.sortAlts();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveFriends() {
        try {
            PrintWriter save = new PrintWriter(new FileWriter(this.friends));
            save.println(this.gson.toJson((Object)WurstClient.INSTANCE.friends));
            save.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadFriends() {
        try {
            BufferedReader load = new BufferedReader(new FileReader(this.friends));
            WurstClient.INSTANCE.friends = (Friends)this.gson.fromJson((Reader)load, Friends.class);
            load.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveXRayBlocks() {
        try {
            XRayUtils.sortBlocks();
            JsonArray json = new JsonArray();
            int i = 0;
            while (i < XRayMod.xrayBlocks.size()) {
                json.add(this.gson.toJsonTree((Object)Block.getIdFromBlock(XRayMod.xrayBlocks.get(i))));
                ++i;
            }
            PrintWriter save = new PrintWriter(new FileWriter(this.xray));
            save.println(this.gson.toJson((JsonElement)json));
            save.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadXRayBlocks() {
        try {
            BufferedReader load = new BufferedReader(new FileReader(this.xray));
            JsonArray json = new JsonParser().parse((Reader)load).getAsJsonArray();
            load.close();
            Iterator itr = json.iterator();
            while (itr.hasNext()) {
                try {
                    String jsonBlock = ((JsonElement)itr.next()).getAsString();
                    XRayMod.xrayBlocks.add(Block.getBlockFromName(jsonBlock));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            XRayUtils.sortBlocks();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createDefaultAutoBuildTemplates() {
        try {
            String[] comment = new String[]{"Copyright \u00a9 2014 - 2015 | Alexander01998 and contributors | All rights reserved.", "This Source Code Form is subject to the terms of the Mozilla Public", "License, v. 2.0. If a copy of the MPL was not distributed with this", "file, You can obtain one at http://mozilla.org/MPL/2.0/."};
            for (Map.Entry entry : new DefaultAutoBuildTemplates().entrySet()) {
                JsonObject json = new JsonObject();
                json.add("__comment", this.gson.toJsonTree((Object)comment, String[].class));
                json.add("blocks", this.gson.toJsonTree(entry.getValue(), int[][].class));
                PrintWriter save = new PrintWriter(new FileWriter(new File(this.autobuildDir, String.valueOf((String)entry.getKey()) + ".json")));
                save.println(this.gson.toJson((JsonElement)json));
                save.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadAutoBuildTemplates() {
        try {
            File[] files = this.autobuildDir.listFiles();
            if (files == null) {
                return;
            }
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                BufferedReader load = new BufferedReader(new FileReader(file));
                JsonObject json = (JsonObject)new JsonParser().parse((Reader)load);
                load.close();
                AutoBuildMod.templates.add((int[][])this.gson.fromJson(json.get("blocks"), int[][].class));
                AutoBuildMod.names.add(file.getName().substring(0, file.getName().indexOf(".json")));
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

