/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.gui;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.ConcurrentModificationException;
import javax.net.ssl.HttpsURLConnection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.darkstorm.minecraft.gui.util.RenderUtil;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.util.xml.XMLElement;
import org.newdawn.slick.util.xml.XMLElementList;
import org.newdawn.slick.util.xml.XMLParser;
import tk.wurst_client.WurstClient;
import tk.wurst_client.alts.gui.GuiAlts;
import tk.wurst_client.message.gui.GuiMessage;
import tk.wurst_client.utils.MiscUtils;

public class GuiWurstMainMenu
extends GuiMainMenu {
    private static final ResourceLocation title = new ResourceLocation("wurst/wurst_380.png");
    private static final ResourceLocation santaHat = new ResourceLocation("wurst/santa_hat.png");
    private static final ResourceLocation buttons = new ResourceLocation("wurst/buttons.png");
    private XMLElementList news;
    private String newsTicker;
    private int newsWidth;

    public GuiWurstMainMenu() {
        if (WurstClient.INSTANCE.options.wurstNews) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        HttpsURLConnection connection = (HttpsURLConnection)new URL("https://www.wurst-client.tk/news/feed.xml").openConnection();
                        connection.connect();
                        XMLElement xml = new XMLParser().parse("", connection.getInputStream());
                        GuiWurstMainMenu.this.news = xml.getChildrenByName("channel").get(0).getChildrenByName("item");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
        WurstClient.INSTANCE.analytics.trackPageView("/", "Main Menu");
    }

    @Override
    public void initGui() {
        GuiButton button;
        super.initGui();
        int i = 3;
        while (i <= 5) {
            ((GuiButton)this.buttonList.get((int)i)).yPosition = Math.min(((GuiButton)this.buttonList.get((int)i)).yPosition, this.height - 56);
            ++i;
        }
        i = 0;
        while (i < 3) {
            button = new GuiButton(20 + i, 8 + i * 24, this.height - 36, 20, 20, "");
            this.buttonList.add(button);
            ++i;
        }
        i = 0;
        while (i < 3) {
            button = new GuiButton(25 - i, this.width - 28 - i * 24, this.height - 36, 20, 20, "");
            this.buttonList.add(button);
            ++i;
        }
        this.newsTicker = "";
        try {
            i = 0;
            while (i < this.news.size()) {
                this.newsTicker = String.valueOf(this.newsTicker) + this.news.get(i).getChildrenByName("title").get(0).getContent() + "\u00a7e+++\u00a7r";
                ++i;
            }
        }
        catch (NullPointerException | ConcurrentModificationException runtimeException) {
            // empty catch block
        }
        this.newsWidth = this.fontRendererObj.getStringWidth(this.newsTicker);
        while (this.fontRendererObj.getStringWidth(this.newsTicker) < Math.max(this.width * 2, this.newsWidth * 2) && !this.newsTicker.isEmpty()) {
            this.newsTicker = String.valueOf(this.newsTicker) + this.newsTicker;
        }
    }

    @Override
    protected void actionPerformed(GuiButton button) throws IOException {
        super.actionPerformed(button);
        switch (button.id) {
            case 3: {
                mc.displayGuiScreen(new GuiAlts(this));
                break;
            }
            case 20: {
                MiscUtils.openLink("https://www.wurst-client.tk/youtube");
                break;
            }
            case 21: {
                MiscUtils.openLink("https://www.wurst-client.tk/twitter");
                break;
            }
            case 22: {
                MiscUtils.openLink("https://www.wurst-client.tk/gplus");
                break;
            }
            case 23: {
                MiscUtils.openLink("https://www.wurst-client.tk/github");
                break;
            }
            case 24: {
                MiscUtils.openLink("https://www.wurst-client.tk/feedback");
                break;
            }
            case 25: {
                MiscUtils.openLink("https://www.wurst-client.tk/fanshop");
            }
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.disableAlpha();
        this.renderSkybox(mouseX, mouseY, partialTicks);
        GlStateManager.enableAlpha();
        this.drawGradientRect(0, 0, this.width, this.height, -2130706433, 0xFFFFFF);
        this.drawGradientRect(0, 0, this.width, this.height, 0, Integer.MIN_VALUE);
        Tessellator tessellator = Tessellator.getInstance();
        WorldRenderer worldRenderer = tessellator.getWorldRenderer();
        GuiScreen.mc.getTextureManager().bindTexture(title);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        double x = this.width / 2 - 128;
        double y = 36.0;
        double h = 64.0;
        double w = 256.0;
        double fw = 256.0;
        double fh = 256.0;
        double u = 0.0;
        double v = 0.0;
        if (GuiMainMenu.splashText.equals("umop-apisdn!")) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-this.width), (float)((float)(-h - 60.0)), (float)0.0f);
        }
        worldRenderer.startDrawingQuads();
        worldRenderer.addVertexWithUV(x + 0.0, y + h, this.zLevel, (u + 0.0) / 256.0, (v + fh) / 256.0);
        worldRenderer.addVertexWithUV(x + w, y + h, this.zLevel, (u + fw) / 256.0, (v + fh) / 256.0);
        worldRenderer.addVertexWithUV(x + w, y + 0.0, this.zLevel, (u + fw) / 256.0, (v + 0.0) / 256.0);
        worldRenderer.addVertexWithUV(x + 0.0, y + 0.0, this.zLevel, (u + 0.0) / 256.0, (v + 0.0) / 256.0);
        tessellator.draw();
        if (Calendar.getInstance().get(2) == 11) {
            mc.getTextureManager().bindTexture(santaHat);
            x += 112.0;
            y -= 36.0;
            h = 48.0;
            w = 48.0;
            fw = 256.0;
            fh = 256.0;
            u = 0.0;
            v = 0.0;
            worldRenderer.startDrawingQuads();
            worldRenderer.addVertexWithUV(x + 0.0, y + h, 0.0, (float)(u + 0.0) * 0.00390625f, (float)(v + fh) * 0.00390625f);
            worldRenderer.addVertexWithUV(x + w, y + h, 0.0, (float)(u + fw) * 0.00390625f, (float)(v + fh) * 0.00390625f);
            worldRenderer.addVertexWithUV(x + w, y + 0.0, 0.0, (float)(u + fw) * 0.00390625f, (float)(v + 0.0) * 0.00390625f);
            worldRenderer.addVertexWithUV(x + 0.0, y + 0.0, 0.0, (float)(u + 0.0) * 0.00390625f, (float)(v + 0.0) * 0.00390625f);
            tessellator.draw();
        }
        if (GuiMainMenu.splashText.equals("umop-apisdn!")) {
            GL11.glRotatef((float)-180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-this.width), (float)((float)(-h - 60.0)), (float)0.0f);
        }
        worldRenderer.setColorOpaque_I(0xFFFFFF);
        GlStateManager.pushMatrix();
        GlStateManager.translate(this.width / 2 + 90, 72.0f, 0.0f);
        GlStateManager.rotate(-20.0f, 0.0f, 0.0f, 1.0f);
        float splashScale = 1.8f - MathHelper.abs(MathHelper.sin((float)(Minecraft.getSystemTime() % 1000L) / 1000.0f * (float)Math.PI * 2.0f) * 0.1f);
        splashScale = splashScale * 100.0f / (float)(this.fontRendererObj.getStringWidth(splashText) + 32);
        GlStateManager.scale(splashScale, splashScale, splashScale);
        this.drawCenteredString(this.fontRendererObj, splashText, 0, 0, -256);
        GlStateManager.popMatrix();
        String vMinecraft = "Minecraft 1.8";
        String cMinecraft1 = "Copyright Mojang AB";
        String cMinecraft2 = "Do not distribute!";
        this.drawString(this.fontRendererObj, vMinecraft, this.width - this.fontRendererObj.getStringWidth(vMinecraft) - 8, 8, 0xFFFFFF);
        this.drawString(this.fontRendererObj, cMinecraft1, this.width - this.fontRendererObj.getStringWidth(cMinecraft1) - 8, 18, 0xFFFFFF);
        this.drawString(this.fontRendererObj, cMinecraft2, this.width - this.fontRendererObj.getStringWidth(cMinecraft2) - 8, 28, 0xFFFFFF);
        this.drawString(this.fontRendererObj, "Wurst Client 2.5", 8, 8, 0xFFFFFF);
        this.drawString(this.fontRendererObj, "Copyright Alexander01998", 8, 18, 0xFFFFFF);
        this.drawString(this.fontRendererObj, "All rights reserved.", 8, 28, 0xFFFFFF);
        this.drawCenteredString(this.fontRendererObj, "\u00a7nwww.Wurst-Client.tk", this.width / 2, this.height - 26, 0xFFFFFF);
        for (Object button : this.buttonList) {
            ((GuiButton)button).drawButton(mc, mouseX, mouseY);
        }
        mc.getTextureManager().bindTexture(buttons);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int i = 0;
        while (i < 6) {
            x = i < 3 ? this.width - 26 - i * 24 : 10 + (5 - i) * 24;
            y = this.height - 34;
            h = 16.0;
            w = 16.0;
            fw = 43.0;
            fh = 256.0;
            u = 213 - i * 256 / 6;
            v = 0.0;
            worldRenderer.startDrawingQuads();
            worldRenderer.addVertexWithUV(x + 0.0, y + h, 0.0, (float)(u + 0.0) * 0.00390625f, (float)(v + fh) * 0.00390625f);
            worldRenderer.addVertexWithUV(x + w, y + h, 0.0, (float)(u + fw) * 0.00390625f, (float)(v + fh) * 0.00390625f);
            worldRenderer.addVertexWithUV(x + w, y + 0.0, 0.0, (float)(u + fw) * 0.00390625f, (float)(v + 0.0) * 0.00390625f);
            worldRenderer.addVertexWithUV(x + 0.0, y + 0.0, 0.0, (float)(u + 0.0) * 0.00390625f, (float)(v + 0.0) * 0.00390625f);
            tessellator.draw();
            ++i;
        }
        if (!"".isEmpty()) {
            this.drawNews(mouseX, mouseY, partialTicks);
        }
        if (!this.newsTicker.isEmpty()) {
            this.drawString(this.fontRendererObj, this.newsTicker, -((int)(Minecraft.getSystemTime() / 50L % (long)this.newsWidth)), this.height - 10, -1);
        }
        i = 0;
        while (i < this.buttonList.size()) {
            GuiButton button = (GuiButton)this.buttonList.get(i);
            if (button.isMouseOver()) {
                ArrayList<String> tooltip = new ArrayList<String>();
                switch (button.id) {
                    case 20: {
                        tooltip.add("Wurst on YouTube");
                        break;
                    }
                    case 21: {
                        tooltip.add("Wurst on Twitter");
                        break;
                    }
                    case 22: {
                        tooltip.add("Wurst on Google+");
                        break;
                    }
                    case 23: {
                        tooltip.add("Wurst on GitHub");
                        break;
                    }
                    case 24: {
                        tooltip.add("Wurst Feedback");
                        break;
                    }
                    case 25: {
                        tooltip.add("Wurst Fan Shop");
                    }
                }
                this.drawHoveringText(tooltip, mouseX, mouseY);
                break;
            }
            ++i;
        }
        if (!WurstClient.INSTANCE.startupMessageDisabled) {
            if (WurstClient.INSTANCE.updater.isOutdated()) {
                WurstClient.INSTANCE.analytics.trackEvent("updater", "update to v" + WurstClient.INSTANCE.updater.getLatestVersion(), "from " + WurstClient.INSTANCE.updater.getCurrentVersion());
                WurstClient.INSTANCE.updater.update();
            } else if (Calendar.getInstance().get(2) == 11 && Calendar.getInstance().get(5) == 24) {
                mc.displayGuiScreen(new GuiYesNo(this, "Dude, it's Christmas!", "What do you want here?", "I want a Christmas song", "I want to grief", 1));
                WurstClient.INSTANCE.analytics.trackPageView("/easter-eggs/christmas", "Dude, it's Christmas!");
            } else {
                try {
                    HttpsURLConnection connection = (HttpsURLConnection)new URL("https://www.wurst-client.tk/api/v1/messages.json").openConnection();
                    connection.connect();
                    JsonObject json = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8")).getAsJsonObject();
                    if (json.get("2.5") != null) {
                        System.out.println("Emergency message found!");
                        mc.displayGuiScreen(new GuiMessage(json.get("2.5").getAsJsonObject()));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            WurstClient.INSTANCE.startupMessageDisabled = true;
        }
    }

    @Override
    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        int linkWidth = this.fontRendererObj.getStringWidth("\u00a7nwww.Wurst-Client.tk");
        if (mouseButton == 0 && mouseY >= this.height - 26 && mouseY < this.height - 16 && mouseX > this.width / 2 - linkWidth / 2 && mouseX < this.width / 2 + linkWidth / 2) {
            MiscUtils.openLink("https://www.Wurst-Client.tk/");
            WurstClient.INSTANCE.analytics.trackPageView("/wurst-client-dot-tk", "www.Wurst-Client.tk");
        }
        if (this.news != null && mouseButton == 0 && mouseY >= this.height - 10) {
            MiscUtils.openLink("https://www.wurst-client.tk/news");
            WurstClient.INSTANCE.analytics.trackPageView("/news", "Wurst News");
        }
    }

    private void drawNews(int mouseX, int mouseY, float partialTicks) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2884);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Rectangle area = new Rectangle(this.width / 2 + 116, 104, this.width / 2 - 116 - 8, this.height - 104 - 16);
        int titleBarHeight = 14;
        GL11.glColor4f((float)0.03125f, (float)0.03125f, (float)0.03125f, (float)0.5f);
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)area.getMinX(), (double)area.getMinY());
        GL11.glVertex2d((double)area.getMaxX(), (double)area.getMinY());
        GL11.glVertex2d((double)area.getMaxX(), (double)(area.getMinY() + (double)titleBarHeight));
        GL11.glVertex2d((double)area.getMinX(), (double)(area.getMinY() + (double)titleBarHeight));
        GL11.glEnd();
        RenderUtil.setColor(new Color(64, 64, 64, 128));
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)area.getMinX(), (double)(area.getMinY() + (double)titleBarHeight));
        GL11.glVertex2d((double)area.getMaxX(), (double)(area.getMinY() + (double)titleBarHeight));
        GL11.glVertex2d((double)area.getMaxX(), (double)area.getMaxY());
        GL11.glVertex2d((double)area.getMinX(), (double)area.getMaxY());
        GL11.glEnd();
        RenderUtil.boxShadow(area.getMinX(), area.getMinY(), area.getMaxX(), area.getMaxY());
        RenderUtil.downShadow(area.getMinX(), area.getMinY() + (double)titleBarHeight, area.getMaxX(), area.getMinY() + (double)titleBarHeight + 1.0);
        this.drawString(this.fontRendererObj, "Wurst News", area.x + 3, area.y + 3, 0xFFFFFF);
        int offsetX = area.x + 2;
        int offsetY = area.y + titleBarHeight + 3;
        ArrayList<String> lines = new ArrayList<String>();
        int i = 0;
        while (i < this.news.size()) {
            ArrayList<String> title = this.lineWrap(this.news.get(i).getChildrenByName("title").get(0).getContent(), (int)((double)(area.width - 8) / 0.75));
            int line = 0;
            while (line < title.size()) {
                title.set(line, (Object)((Object)EnumChatFormatting.UNDERLINE) + title.get(line));
                ++line;
            }
            lines.addAll(title);
            lines.add("");
            ++i;
        }
        GlStateManager.pushMatrix();
        GlStateManager.translate(offsetX, offsetY, 0.0f);
        GlStateManager.scale(0.75, 0.75, 0.75);
        int line = 0;
        while (line < lines.size()) {
            this.drawString(this.fontRendererObj, (Object)((Object)EnumChatFormatting.UNDERLINE) + (String)lines.get(line), 0, line * 10, 0xFFFFFF);
            ++line;
        }
        GlStateManager.popMatrix();
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
    }

    private ArrayList<String> lineWrap(String string, int width) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = string.split(" ");
        String line = "";
        String lastLine = "";
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (this.fontRendererObj.getStringWidth(line = String.valueOf(line) + (lastLine.isEmpty() ? word : " " + word)) > width) {
                if (lastLine.isEmpty()) {
                    lines.add(line);
                    lastLine = "";
                } else {
                    lines.add(lastLine);
                    lastLine = word;
                }
                line = lastLine;
            } else {
                lastLine = line;
            }
            ++n2;
        }
        lines.add(line);
        return lines;
    }
}

