/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import tk.wurst_client.WurstClient;
import tk.wurst_client.events.listeners.UpdateListener;
import tk.wurst_client.mods.Mod;

@Mod.Info(category=Mod.Category.MISC, description="Automatically eats food when necessary.", name="AutoEat")
public class AutoEatMod
extends Mod
implements UpdateListener {
    private int oldSlot;
    private int bestSlot;

    @Override
    public void onEnable() {
        this.oldSlot = -1;
        WurstClient.INSTANCE.eventManager.add(UpdateListener.class, this);
    }

    @Override
    public void onUpdate() {
        if (this.oldSlot != -1 || Minecraft.getMinecraft().thePlayer.capabilities.isCreativeMode || Minecraft.getMinecraft().thePlayer.getFoodStats().getFoodLevel() >= 20) {
            return;
        }
        float bestSaturation = 0.0f;
        this.bestSlot = -1;
        int i = 0;
        while (i < 9) {
            ItemStack item = Minecraft.getMinecraft().thePlayer.inventory.getStackInSlot(i);
            if (item != null) {
                float saturation = 0.0f;
                if (item.getItem() instanceof ItemFood) {
                    saturation = ((ItemFood)item.getItem()).getSaturationModifier(item);
                }
                if (saturation > bestSaturation) {
                    bestSaturation = saturation;
                    this.bestSlot = i;
                }
            }
            ++i;
        }
        if (this.bestSlot == -1) {
            return;
        }
        this.oldSlot = Minecraft.getMinecraft().thePlayer.inventory.currentItem;
        WurstClient.INSTANCE.eventManager.add(UpdateListener.class, new UpdateListener(){

            @Override
            public void onUpdate() {
                if (!AutoEatMod.this.isActive() || Minecraft.getMinecraft().thePlayer.capabilities.isCreativeMode || Minecraft.getMinecraft().thePlayer.getFoodStats().getFoodLevel() >= 20) {
                    this.stop();
                    return;
                }
                ItemStack item = Minecraft.getMinecraft().thePlayer.inventory.getStackInSlot(AutoEatMod.this.bestSlot);
                if (item == null || !(item.getItem() instanceof ItemFood)) {
                    this.stop();
                    return;
                }
                Minecraft.getMinecraft().thePlayer.inventory.currentItem = AutoEatMod.this.bestSlot;
                Minecraft.getMinecraft().playerController.sendUseItem(Minecraft.getMinecraft().thePlayer, Minecraft.getMinecraft().theWorld, item);
                Minecraft.getMinecraft().gameSettings.keyBindUseItem.pressed = true;
            }

            private void stop() {
                Minecraft.getMinecraft().gameSettings.keyBindUseItem.pressed = false;
                Minecraft.getMinecraft().thePlayer.inventory.currentItem = AutoEatMod.this.oldSlot;
                AutoEatMod.this.oldSlot = -1;
                WurstClient.INSTANCE.eventManager.remove(UpdateListener.class, this);
            }
        });
    }

    @Override
    public void onDisable() {
        WurstClient.INSTANCE.eventManager.remove(UpdateListener.class, this);
    }

    public boolean isEating() {
        return this.oldSlot != -1;
    }
}

