/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.util.BlockPos;
import tk.wurst_client.WurstClient;
import tk.wurst_client.events.listeners.RenderListener;
import tk.wurst_client.events.listeners.UpdateListener;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.utils.RenderUtils;

@Mod.Info(category=Mod.Category.RENDER, description="Finds player bases by searching for man-made blocks.\nGood for finding faction bases.", name="BaseFinder")
public class BaseFinderMod
extends Mod
implements UpdateListener,
RenderListener {
    private ArrayList<Block> naturalBlocks = new ArrayList();
    private ArrayList<BlockPos> matchingBlocks = new ArrayList();
    private int range = 50;
    private int maxBlocks = 1024;
    private boolean shouldInform = true;

    public BaseFinderMod() {
        this.initBlocks();
    }

    @Override
    public void onEnable() {
        this.shouldInform = true;
        WurstClient.INSTANCE.eventManager.add(UpdateListener.class, this);
        WurstClient.INSTANCE.eventManager.add(RenderListener.class, this);
    }

    @Override
    public void onRender() {
        for (BlockPos blockPos : this.matchingBlocks) {
            RenderUtils.framelessBlockESP(blockPos, new Color(255, 0, 0));
        }
    }

    @Override
    public void onUpdate() {
        this.updateMS();
        if (this.hasTimePassedM(3000L)) {
            this.matchingBlocks.clear();
            int y = this.range;
            while (y >= -this.range) {
                int x = this.range;
                while (x >= -this.range) {
                    int z = this.range;
                    while (z >= -this.range) {
                        int posX = (int)(Minecraft.getMinecraft().thePlayer.posX + (double)x);
                        int posY = (int)(Minecraft.getMinecraft().thePlayer.posY + (double)y);
                        int posZ = (int)(Minecraft.getMinecraft().thePlayer.posZ + (double)z);
                        BlockPos pos = new BlockPos(posX, posY, posZ);
                        if (!this.naturalBlocks.contains(Minecraft.getMinecraft().theWorld.getBlockState(pos).getBlock())) {
                            this.matchingBlocks.add(pos);
                        }
                        if (this.matchingBlocks.size() >= this.maxBlocks) break;
                        --z;
                    }
                    if (this.matchingBlocks.size() >= this.maxBlocks) break;
                    --x;
                }
                if (this.matchingBlocks.size() >= this.maxBlocks) break;
                --y;
            }
            if (this.matchingBlocks.size() >= this.maxBlocks && this.shouldInform) {
                WurstClient.INSTANCE.chat.warning(String.valueOf(this.getName()) + " found \u00a7lA LOT\u00a7r of blocks.");
                WurstClient.INSTANCE.chat.message("To prevent lag, it will only show the first " + this.maxBlocks + " blocks.");
                this.shouldInform = false;
            } else if (this.matchingBlocks.size() < this.maxBlocks) {
                this.shouldInform = true;
            }
            this.updateLastMS();
        }
    }

    @Override
    public void onDisable() {
        WurstClient.INSTANCE.eventManager.remove(UpdateListener.class, this);
        WurstClient.INSTANCE.eventManager.remove(RenderListener.class, this);
    }

    private void initBlocks() {
        this.naturalBlocks.add(Block.getBlockFromName("air"));
        this.naturalBlocks.add(Block.getBlockFromName("stone"));
        this.naturalBlocks.add(Block.getBlockFromName("dirt"));
        this.naturalBlocks.add(Block.getBlockFromName("grass"));
        this.naturalBlocks.add(Block.getBlockFromName("gravel"));
        this.naturalBlocks.add(Block.getBlockFromName("sand"));
        this.naturalBlocks.add(Block.getBlockFromName("clay"));
        this.naturalBlocks.add(Block.getBlockFromName("sandstone"));
        this.naturalBlocks.add(Block.getBlockById(8));
        this.naturalBlocks.add(Block.getBlockById(9));
        this.naturalBlocks.add(Block.getBlockById(10));
        this.naturalBlocks.add(Block.getBlockById(11));
        this.naturalBlocks.add(Block.getBlockFromName("log"));
        this.naturalBlocks.add(Block.getBlockFromName("log2"));
        this.naturalBlocks.add(Block.getBlockFromName("leaves"));
        this.naturalBlocks.add(Block.getBlockFromName("leaves2"));
        this.naturalBlocks.add(Block.getBlockFromName("deadbush"));
        this.naturalBlocks.add(Block.getBlockFromName("iron_ore"));
        this.naturalBlocks.add(Block.getBlockFromName("coal_ore"));
        this.naturalBlocks.add(Block.getBlockFromName("gold_ore"));
        this.naturalBlocks.add(Block.getBlockFromName("diamond_ore"));
        this.naturalBlocks.add(Block.getBlockFromName("emerald_ore"));
        this.naturalBlocks.add(Block.getBlockFromName("redstone_ore"));
        this.naturalBlocks.add(Block.getBlockFromName("lapis_ore"));
        this.naturalBlocks.add(Block.getBlockFromName("bedrock"));
        this.naturalBlocks.add(Block.getBlockFromName("mob_spawner"));
        this.naturalBlocks.add(Block.getBlockFromName("mossy_cobblestone"));
        this.naturalBlocks.add(Block.getBlockFromName("tallgrass"));
        this.naturalBlocks.add(Block.getBlockFromName("yellow_flower"));
        this.naturalBlocks.add(Block.getBlockFromName("red_flower"));
        this.naturalBlocks.add(Block.getBlockFromName("cobweb"));
        this.naturalBlocks.add(Block.getBlockFromName("brown_mushroom"));
        this.naturalBlocks.add(Block.getBlockFromName("red_mushroom"));
        this.naturalBlocks.add(Block.getBlockFromName("snow_layer"));
        this.naturalBlocks.add(Block.getBlockFromName("vine"));
        this.naturalBlocks.add(Block.getBlockFromName("waterlily"));
        this.naturalBlocks.add(Block.getBlockFromName("double_plant"));
        this.naturalBlocks.add(Block.getBlockFromName("hardened_clay"));
        this.naturalBlocks.add(Block.getBlockFromName("red_sandstone"));
        this.naturalBlocks.add(Block.getBlockFromName("ice"));
        this.naturalBlocks.add(Block.getBlockFromName("quartz_ore"));
        this.naturalBlocks.add(Block.getBlockFromName("obsidian"));
        this.naturalBlocks.add(Block.getBlockFromName("monster_egg"));
        this.naturalBlocks.add(Block.getBlockFromName("red_mushroom_block"));
        this.naturalBlocks.add(Block.getBlockFromName("brown_mushroom_block"));
    }
}

