/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.BlockPos;
import tk.wurst_client.WurstClient;
import tk.wurst_client.events.listeners.RenderListener;
import tk.wurst_client.events.listeners.UpdateListener;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.utils.RenderUtils;

@Mod.Info(category=Mod.Category.RENDER, description="Allows you to see chests through walls.\nTip: This works with the piston crates on HiveMC.", name="ChestESP")
public class ChestEspMod
extends Mod
implements UpdateListener,
RenderListener {
    private int range = 50;
    private int maxChests = 1000;
    public boolean shouldInform = true;
    private ArrayList<BlockPos> matchingBlocks = new ArrayList();

    @Override
    public void onEnable() {
        this.shouldInform = true;
        WurstClient.INSTANCE.eventManager.add(UpdateListener.class, this);
        WurstClient.INSTANCE.eventManager.add(RenderListener.class, this);
    }

    @Override
    public void onRender() {
        int i = 0;
        for (Object o : Minecraft.getMinecraft().theWorld.loadedTileEntityList) {
            if (i >= this.maxChests) break;
            if (o instanceof TileEntityChest) {
                ++i;
                RenderUtils.blockESPBox(((TileEntityChest)o).getPos());
                continue;
            }
            if (!(o instanceof TileEntityEnderChest)) continue;
            ++i;
            RenderUtils.blockESPBox(((TileEntityEnderChest)o).getPos());
        }
        for (Object o : Minecraft.getMinecraft().theWorld.loadedEntityList) {
            if (i >= this.maxChests) break;
            if (!(o instanceof EntityMinecartChest)) continue;
            ++i;
            RenderUtils.blockESPBox(((EntityMinecartChest)o).getPosition());
        }
        for (BlockPos blockPos : this.matchingBlocks) {
            if (i >= this.maxChests) break;
            ++i;
            RenderUtils.blockESPBox(blockPos);
        }
        if (i >= this.maxChests && this.shouldInform) {
            WurstClient.INSTANCE.chat.warning(String.valueOf(this.getName()) + " found \u00a7lA LOT\u00a7r of chests.");
            WurstClient.INSTANCE.chat.message("To prevent lag, it will only show the first " + this.maxChests + " chests.");
            this.shouldInform = false;
        } else if (i < this.maxChests) {
            this.shouldInform = true;
        }
    }

    @Override
    public void onUpdate() {
        this.updateMS();
        if (this.hasTimePassedM(3000L)) {
            this.matchingBlocks.clear();
            int y = this.range;
            while (y >= -this.range) {
                int x = this.range;
                while (x >= -this.range) {
                    int z = this.range;
                    while (z >= -this.range) {
                        int posX = (int)(Minecraft.getMinecraft().thePlayer.posX + (double)x);
                        int posY = (int)(Minecraft.getMinecraft().thePlayer.posY + (double)y);
                        int posZ = (int)(Minecraft.getMinecraft().thePlayer.posZ + (double)z);
                        BlockPos pos = new BlockPos(posX, posY, posZ);
                        IBlockState state = Minecraft.getMinecraft().theWorld.getBlockState(pos);
                        Block block = state.getBlock();
                        int metadata = block.getMetaFromState(state);
                        if (Block.getIdFromBlock(block) == 33 && (metadata == 6 || metadata == 7 || metadata == 15)) {
                            this.matchingBlocks.add(pos);
                        }
                        --z;
                    }
                    --x;
                }
                --y;
            }
            this.updateLastMS();
        }
    }

    @Override
    public void onDisable() {
        WurstClient.INSTANCE.eventManager.remove(UpdateListener.class, this);
        WurstClient.INSTANCE.eventManager.remove(RenderListener.class, this);
    }
}

