/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.util.StringUtils;
import tk.wurst_client.WurstClient;
import tk.wurst_client.events.ChatInputEvent;
import tk.wurst_client.events.listeners.ChatInputListener;
import tk.wurst_client.events.listeners.UpdateListener;
import tk.wurst_client.mods.Mod;

@Mod.Info(category=Mod.Category.CHAT, description="Sends a TPA request to all players.\nStops if someone accepts.", name="MassTPA")
public class MassTpaMod
extends Mod
implements UpdateListener,
ChatInputListener {
    private float speed = 1.0f;
    private int i;
    private ArrayList<String> players;
    private Random random = new Random();

    @Override
    public void onEnable() {
        this.i = 0;
        Iterator itr = Minecraft.getMinecraft().getNetHandler().getPlayerInfo().iterator();
        this.players = new ArrayList();
        while (itr.hasNext()) {
            this.players.add(StringUtils.stripControlCodes(((NetworkPlayerInfo)itr.next()).getPlayerNameForReal()));
        }
        Collections.shuffle(this.players, this.random);
        WurstClient.INSTANCE.eventManager.add(ChatInputListener.class, this);
        WurstClient.INSTANCE.eventManager.add(UpdateListener.class, this);
    }

    @Override
    public void onUpdate() {
        this.updateMS();
        if (this.hasTimePassedS(this.speed)) {
            String name = this.players.get(this.i);
            if (!name.equals(Minecraft.getMinecraft().thePlayer.getName())) {
                Minecraft.getMinecraft().thePlayer.sendChatMessage("/tpa " + name);
            }
            this.updateLastMS();
            ++this.i;
            if (this.i == this.players.size()) {
                this.setEnabled(false);
            }
        }
    }

    @Override
    public void onDisable() {
        WurstClient.INSTANCE.eventManager.remove(ChatInputListener.class, this);
        WurstClient.INSTANCE.eventManager.remove(UpdateListener.class, this);
    }

    @Override
    public void onReceivedMessage(ChatInputEvent event) {
        String message = event.getComponent().getUnformattedText();
        if (message.startsWith("\u00a7c[\u00a76Wurst\u00a7c]\u00a7f ")) {
            return;
        }
        if (message.toLowerCase().contains("/help") || message.toLowerCase().contains("permission")) {
            event.cancel();
            WurstClient.INSTANCE.chat.message("\u00a74\u00a7lERROR:\u00a7f This server doesn't have TPA.");
            this.setEnabled(false);
        } else if (message.toLowerCase().contains("accepted") && message.toLowerCase().contains("request") || message.toLowerCase().contains("akzeptiert") && message.toLowerCase().contains("anfrage")) {
            event.cancel();
            WurstClient.INSTANCE.chat.message("Someone accepted your TPA request. Stopping.");
            this.setEnabled(false);
        }
    }
}

