/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S28PacketEffect;
import net.minecraft.network.play.server.S29PacketSoundEffect;
import net.minecraft.network.play.server.S2CPacketSpawnGlobalEntity;
import net.minecraft.util.BlockPos;
import tk.wurst_client.WurstClient;
import tk.wurst_client.events.PacketInputEvent;
import tk.wurst_client.events.listeners.PacketInputListener;
import tk.wurst_client.events.listeners.RenderListener;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.utils.BlockUtils;
import tk.wurst_client.utils.RenderUtils;

@Mod.Info(category=Mod.Category.RENDER, description="Finds far players during thunderstorms.", name="PlayerFinder")
public class PlayerFinderMod
extends Mod
implements PacketInputListener,
RenderListener {
    private BlockPos blockPos;

    @Override
    public void onEnable() {
        this.blockPos = null;
        WurstClient.INSTANCE.eventManager.add(PacketInputListener.class, this);
        WurstClient.INSTANCE.eventManager.add(RenderListener.class, this);
    }

    @Override
    public void onRender() {
        if (this.blockPos == null) {
            return;
        }
        float red = (1.0f - (float)Math.sin((double)((float)(System.currentTimeMillis() % 1000L) / 1000.0f) * Math.PI * 2.0)) / 2.0f;
        float green = (1.0f - (float)Math.sin((double)((float)((System.currentTimeMillis() + 333L) % 1000L) / 1000.0f) * Math.PI * 2.0)) / 2.0f;
        float blue = (1.0f - (float)Math.sin((double)((float)((System.currentTimeMillis() + 666L) % 1000L) / 1000.0f) * Math.PI * 2.0)) / 2.0f;
        Color color = new Color(red, green, blue);
        RenderUtils.tracerLine(this.blockPos.getX(), this.blockPos.getY(), this.blockPos.getZ(), color);
        RenderUtils.blockESPBox(this.blockPos);
    }

    @Override
    public void onDisable() {
        WurstClient.INSTANCE.eventManager.remove(PacketInputListener.class, this);
        WurstClient.INSTANCE.eventManager.remove(RenderListener.class, this);
    }

    @Override
    public void onReceivedPacket(PacketInputEvent event) {
        S2CPacketSpawnGlobalEntity lightning;
        BlockPos pos;
        if (Minecraft.getMinecraft().thePlayer == null) {
            return;
        }
        Packet packet = event.getPacket();
        if (packet instanceof S28PacketEffect) {
            S28PacketEffect effect = (S28PacketEffect)packet;
            BlockPos pos2 = effect.func_179746_d();
            if (BlockUtils.getPlayerBlockDistance(pos2) >= 160.0f) {
                this.blockPos = pos2;
            }
        } else if (packet instanceof S29PacketSoundEffect) {
            S29PacketSoundEffect sound = (S29PacketSoundEffect)packet;
            BlockPos pos3 = new BlockPos(sound.func_149207_d(), sound.func_149211_e(), sound.func_149210_f());
            if (BlockUtils.getPlayerBlockDistance(pos3) >= 160.0f) {
                this.blockPos = pos3;
            }
        } else if (packet instanceof S2CPacketSpawnGlobalEntity && BlockUtils.getPlayerBlockDistance(pos = new BlockPos((double)(lightning = (S2CPacketSpawnGlobalEntity)packet).func_149051_d() / 32.0, (double)lightning.func_149050_e() / 32.0, (double)lightning.func_149049_f() / 32.0)) >= 160.0f) {
            this.blockPos = pos;
        }
    }
}

