/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.EntityLivingBase;
import tk.wurst_client.WurstClient;
import tk.wurst_client.events.listeners.UpdateListener;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.utils.EntityUtils;

@Mod.Info(category=Mod.Category.RENDER, description="Allows you to see the world as someone else.\nUse the .rv command to make it target a specific entity.", name="RemoteView")
public class RemoteViewMod
extends Mod
implements UpdateListener {
    private EntityPlayerSP newView = null;
    private double oldX;
    private double oldY;
    private double oldZ;
    private float oldYaw;
    private float oldPitch;
    private EntityLivingBase otherView = null;
    private static UUID otherID = null;
    private boolean wasInvisible;

    @Override
    public void onEnable() {
        if (EntityUtils.getClosestEntityRaw(false) == null) {
            WurstClient.INSTANCE.chat.message("There is no nearby entity.");
            this.setEnabled(false);
            return;
        }
        this.oldX = Minecraft.getMinecraft().thePlayer.posX;
        this.oldY = Minecraft.getMinecraft().thePlayer.posY;
        this.oldZ = Minecraft.getMinecraft().thePlayer.posZ;
        this.oldYaw = Minecraft.getMinecraft().thePlayer.rotationYaw;
        this.oldPitch = Minecraft.getMinecraft().thePlayer.rotationPitch;
        Minecraft.getMinecraft().thePlayer.noClip = true;
        if (otherID == null) {
            otherID = EntityUtils.getClosestEntityRaw(false).getUniqueID();
        }
        this.otherView = EntityUtils.searchEntityByIdRaw(otherID);
        this.wasInvisible = this.otherView.isInvisibleToPlayer(Minecraft.getMinecraft().thePlayer);
        EntityOtherPlayerMP fakePlayer = new EntityOtherPlayerMP(Minecraft.getMinecraft().theWorld, Minecraft.getMinecraft().thePlayer.getGameProfile());
        fakePlayer.clonePlayer(Minecraft.getMinecraft().thePlayer, true);
        fakePlayer.copyLocationAndAnglesFrom(Minecraft.getMinecraft().thePlayer);
        fakePlayer.rotationYawHead = Minecraft.getMinecraft().thePlayer.rotationYawHead;
        Minecraft.getMinecraft().theWorld.addEntityToWorld(-69, fakePlayer);
        WurstClient.INSTANCE.chat.message("Now viewing " + this.otherView.getName() + ".");
        WurstClient.INSTANCE.eventManager.add(UpdateListener.class, this);
    }

    public static void onEnabledByCommand(String viewName) {
        try {
            if (otherID == null && !viewName.equals("")) {
                otherID = EntityUtils.searchEntityByNameRaw(viewName).getUniqueID();
            }
            WurstClient.INSTANCE.modManager.getModByClass(RemoteViewMod.class).toggle();
        }
        catch (NullPointerException e) {
            WurstClient.INSTANCE.chat.error("Entity not found.");
        }
    }

    @Override
    public void onUpdate() {
        if (EntityUtils.searchEntityByIdRaw(otherID) == null) {
            this.setEnabled(false);
            return;
        }
        this.newView = Minecraft.getMinecraft().thePlayer;
        this.otherView = EntityUtils.searchEntityByIdRaw(otherID);
        this.newView.copyLocationAndAnglesFrom(this.otherView);
        Minecraft.getMinecraft().thePlayer.motionX = 0.0;
        Minecraft.getMinecraft().thePlayer.motionY = 0.0;
        Minecraft.getMinecraft().thePlayer.motionZ = 0.0;
        Minecraft.getMinecraft().thePlayer = this.newView;
        this.otherView.setInvisible(true);
    }

    @Override
    public void onDisable() {
        WurstClient.INSTANCE.eventManager.remove(UpdateListener.class, this);
        if (this.otherView != null) {
            WurstClient.INSTANCE.chat.message("No longer viewing " + this.otherView.getName() + ".");
            this.otherView.setInvisible(this.wasInvisible);
            Minecraft.getMinecraft().thePlayer.noClip = false;
            Minecraft.getMinecraft().thePlayer.setPositionAndRotation(this.oldX, this.oldY, this.oldZ, this.oldYaw, this.oldPitch);
            Minecraft.getMinecraft().theWorld.removeEntityFromWorld(-69);
        }
        this.newView = null;
        this.otherView = null;
        otherID = null;
    }
}

