/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.opsign.gui;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import org.lwjgl.input.Keyboard;
import tk.wurst_client.WurstClient;
import tk.wurst_client.mods.OpSignMod;

public class GuiOpSign
extends GuiScreen {
    private GuiScreen prevMenu;
    private OpSignMod mod;
    private GuiTextField commandBox;

    public GuiOpSign(OpSignMod mod, GuiScreen prevMenu) {
        this.mod = mod;
        this.prevMenu = prevMenu;
    }

    @Override
    public void initGui() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonList.add(new GuiButton(0, this.width / 2 - 100, this.height / 3 * 2, 200, 20, "Done"));
        this.buttonList.add(new GuiButton(1, this.width / 2 - 100, this.height / 3 * 2 + 24, 200, 20, "Cancel"));
        this.commandBox = new GuiTextField(0, this.fontRendererObj, this.width / 2 - 100, 60, 200, 20);
        this.commandBox.setMaxStringLength(100);
        this.commandBox.setFocused(true);
        this.commandBox.setText("/op " + Minecraft.getMinecraft().session.getUsername());
        this.commandBox.setCursorPosition(0);
        this.commandBox.setSelectionPos(this.commandBox.getText().length());
        WurstClient.INSTANCE.analytics.trackPageView("/opsign", "OP Sign");
    }

    @Override
    protected void actionPerformed(GuiButton button) throws IOException {
        if (!button.enabled) {
            return;
        }
        switch (button.id) {
            case 0: {
                Minecraft.getMinecraft().displayGuiScreen(this.prevMenu);
                this.mod.setCommand(this.commandBox.getText());
                WurstClient.INSTANCE.analytics.trackEvent("opsign", "set command");
                break;
            }
            case 1: {
                Minecraft.getMinecraft().displayGuiScreen(this.prevMenu);
                this.mod.setEnabled(false);
                WurstClient.INSTANCE.analytics.trackEvent("opsign", "cancel");
                break;
            }
        }
    }

    @Override
    public void updateScreen() {
        this.commandBox.updateCursorCounter();
    }

    @Override
    protected void keyTyped(char par1, int par2) {
        this.commandBox.textboxKeyTyped(par1, par2);
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    protected void mouseClicked(int par1, int par2, int par3) throws IOException {
        super.mouseClicked(par1, par2, par3);
        this.commandBox.mouseClicked(par1, par2, par3);
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRendererObj, "OP Sign", this.width / 2, 20, 0xFFFFFF);
        this.drawString(this.fontRendererObj, "Command", this.width / 2 - 100, 47, 0xA0A0A0);
        this.drawCenteredString(this.fontRendererObj, "The command you type in here will be", this.width / 2, 100, 0xA0A0A0);
        this.drawCenteredString(this.fontRendererObj, "executed once you place & right click a sign.", this.width / 2, 110, 0xA0A0A0);
        this.commandBox.drawTextBox();
        super.drawScreen(mouseX, mouseY, partialTicks);
    }
}

