/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.options.gui;

import java.io.IOException;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import org.lwjgl.input.Keyboard;
import tk.wurst_client.WurstClient;
import tk.wurst_client.options.gui.GuiKeybindPressAKey;

public class GuiKeybindChange
extends GuiScreen {
    private GuiScreen prevMenu;
    private GuiTextField commandBox;
    private Map.Entry<String, String> entry;
    private String key = "NONE";

    public GuiKeybindChange(GuiScreen prevMenu, Map.Entry<String, String> entry) {
        this.prevMenu = prevMenu;
        this.entry = entry;
        if (entry != null) {
            this.key = entry.getKey();
        }
    }

    @Override
    public void updateScreen() {
        this.commandBox.updateCursorCounter();
    }

    @Override
    public void initGui() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonList.clear();
        this.buttonList.add(new GuiButton(0, this.width / 2 - 100, 60, "Change Key"));
        this.buttonList.add(new GuiButton(1, this.width / 2 - 100, this.height / 4 + 72, "Save"));
        this.buttonList.add(new GuiButton(2, this.width / 2 - 100, this.height / 4 + 96, "Cancel"));
        this.commandBox = new GuiTextField(0, this.fontRendererObj, this.width / 2 - 100, 100, 200, 20);
        this.commandBox.setMaxStringLength(128);
        this.commandBox.setFocused(true);
        if (this.entry != null) {
            this.commandBox.setText(this.entry.getValue());
        }
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    protected void actionPerformed(GuiButton clickedButton) {
        if (clickedButton.enabled) {
            if (clickedButton.id == 0) {
                mc.displayGuiScreen(new GuiKeybindPressAKey(this));
            } else if (clickedButton.id == 1) {
                if (this.entry != null) {
                    WurstClient.INSTANCE.keybinds.remove(this.entry.getKey());
                }
                WurstClient.INSTANCE.keybinds.put(this.key, this.commandBox.getText());
                WurstClient.INSTANCE.fileManager.saveKeybinds();
                mc.displayGuiScreen(this.prevMenu);
                WurstClient.INSTANCE.analytics.trackEvent("keybinds", "set", this.key);
            } else if (clickedButton.id == 2) {
                mc.displayGuiScreen(this.prevMenu);
            }
        }
    }

    @Override
    protected void keyTyped(char par1, int par2) {
        this.commandBox.textboxKeyTyped(par1, par2);
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    protected void mouseClicked(int par1, int par2, int par3) throws IOException {
        super.mouseClicked(par1, par2, par3);
        this.commandBox.mouseClicked(par1, par2, par3);
    }

    @Override
    public void drawScreen(int par1, int par2, float par3) {
        this.drawBackground(0);
        this.drawCenteredString(this.fontRendererObj, String.valueOf(this.entry != null ? "Edit" : "Add") + " Keybind", this.width / 2, 20, 0xFFFFFF);
        this.drawString(this.fontRendererObj, "Key: " + this.key, this.width / 2 - 100, 47, 0xA0A0A0);
        this.drawString(this.fontRendererObj, "Command", this.width / 2 - 100, 87, 0xA0A0A0);
        this.commandBox.drawTextBox();
        super.drawScreen(par1, par2, par3);
    }
}

