/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.servers.gui;

import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.multiplayer.ServerData;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;
import tk.wurst_client.WurstClient;
import tk.wurst_client.servers.ServerPinger;
import tk.wurst_client.utils.MiscUtils;

public class GuiServerFinder
extends GuiScreen {
    private GuiMultiplayer prevMenu;
    private GuiTextField ipBox;
    private GuiTextField maxThreadsBox;
    private boolean running;
    private int checked;
    private int working;
    private boolean terminated;

    public GuiServerFinder(GuiMultiplayer prevMultiplayerMenu) {
        this.prevMenu = prevMultiplayerMenu;
    }

    @Override
    public void updateScreen() {
        this.ipBox.updateCursorCounter();
        ((GuiButton)this.buttonList.get((int)0)).enabled = this.ipBox.getText().trim().length() >= 7 && this.ipBox.getText().contains(".") && !this.ipBox.getText().contains(":") && StringUtils.countMatches((CharSequence)this.ipBox.getText(), (CharSequence)".") == 3 && MiscUtils.isInteger(this.ipBox.getText().split("\\.", -1)[0]) && MiscUtils.isInteger(this.ipBox.getText().split("\\.", -1)[1]) && MiscUtils.isInteger(this.ipBox.getText().split("\\.", -1)[2]) && MiscUtils.isInteger(this.ipBox.getText().split("\\.", -1)[3]) && !this.running && MiscUtils.isInteger(this.maxThreadsBox.getText());
    }

    @Override
    public void initGui() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonList.clear();
        this.buttonList.add(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 96 + 12, "Search"));
        this.buttonList.add(new GuiButton(1, this.width / 2 - 100, this.height / 4 + 120 + 12, "Back"));
        this.ipBox = new GuiTextField(0, this.fontRendererObj, this.width / 2 - 100, this.height / 4 + 34, 200, 20);
        this.ipBox.setMaxStringLength(15);
        this.ipBox.setFocused(true);
        this.maxThreadsBox = new GuiTextField(1, this.fontRendererObj, this.width / 2 - 32, this.height / 4 + 58, 26, 12);
        this.maxThreadsBox.setMaxStringLength(3);
        this.maxThreadsBox.setFocused(false);
        this.maxThreadsBox.setText(Integer.toString(WurstClient.INSTANCE.options.serverFinderThreads));
        this.running = false;
        this.terminated = false;
        WurstClient.INSTANCE.analytics.trackPageView("/multiplayer/server-finder", "Server Finder");
    }

    @Override
    public void onGuiClosed() {
        this.terminated = true;
        if (MiscUtils.isInteger(this.maxThreadsBox.getText())) {
            WurstClient.INSTANCE.options.serverFinderThreads = Integer.valueOf(this.maxThreadsBox.getText());
            WurstClient.INSTANCE.fileManager.saveOptions();
        }
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    protected void actionPerformed(GuiButton clickedButton) {
        if (clickedButton.enabled) {
            if (clickedButton.id == 0) {
                if (MiscUtils.isInteger(this.maxThreadsBox.getText())) {
                    WurstClient.INSTANCE.options.serverFinderThreads = Integer.valueOf(this.maxThreadsBox.getText());
                    WurstClient.INSTANCE.fileManager.saveOptions();
                }
                this.running = true;
                new Thread("Server Finder"){

                    @Override
                    public void run() {
                        int[] ipParts = new int[4];
                        int i = 0;
                        while (i < GuiServerFinder.this.ipBox.getText().split("\\.").length) {
                            ipParts[i] = Integer.valueOf(GuiServerFinder.this.ipBox.getText().split("\\.")[i]);
                            ++i;
                        }
                        ArrayList pingers = new ArrayList();
                        int i2 = 3;
                        block1: while (i2 >= 0) {
                            int i22 = 0;
                            while (i22 <= 255) {
                                if (GuiServerFinder.this.terminated) break block1;
                                int[] ipParts2 = (int[])ipParts.clone();
                                ipParts2[i2] = i22;
                                String ip = String.valueOf(ipParts2[0]) + "." + ipParts2[1] + "." + ipParts2[2] + "." + ipParts2[3];
                                ServerPinger pinger = new ServerPinger();
                                pinger.ping(ip);
                                pingers.add(pinger);
                                while (pingers.size() >= WurstClient.INSTANCE.options.serverFinderThreads) {
                                    pingers = GuiServerFinder.this.updatePingers(pingers);
                                }
                                ++i22;
                            }
                            --i2;
                        }
                        while (pingers.size() > 0) {
                            pingers = GuiServerFinder.this.updatePingers(pingers);
                        }
                        WurstClient.INSTANCE.analytics.trackEvent("server finder", "complete", "complete", GuiServerFinder.this.working);
                    }
                }.start();
                WurstClient.INSTANCE.analytics.trackEvent("server finder", "start");
            } else if (clickedButton.id == 1) {
                mc.displayGuiScreen(this.prevMenu);
            }
        }
    }

    private ArrayList<ServerPinger> updatePingers(ArrayList<ServerPinger> pingers) {
        int i = 0;
        while (i < pingers.size()) {
            if (!pingers.get(i).isStillPinging()) {
                ++this.checked;
                if (pingers.get(i).isWorking()) {
                    ++this.working;
                    this.prevMenu.savedServerList.addServerData(new ServerData("Grief me #" + this.working, pingers.get((int)i).server.serverIP));
                    this.prevMenu.savedServerList.saveServerList();
                    this.prevMenu.serverListSelector.setSelectedServer(-1);
                    this.prevMenu.serverListSelector.func_148195_a(this.prevMenu.savedServerList);
                }
                pingers.remove(i);
            }
            ++i;
        }
        return pingers;
    }

    @Override
    protected void keyTyped(char par1, int par2) {
        this.ipBox.textboxKeyTyped(par1, par2);
        this.maxThreadsBox.textboxKeyTyped(par1, par2);
        if (par2 == 28 || par2 == 156) {
            this.actionPerformed((GuiButton)this.buttonList.get(0));
        }
    }

    @Override
    protected void mouseClicked(int par1, int par2, int par3) throws IOException {
        super.mouseClicked(par1, par2, par3);
        this.ipBox.mouseClicked(par1, par2, par3);
        this.maxThreadsBox.mouseClicked(par1, par2, par3);
    }

    @Override
    public void drawScreen(int par1, int par2, float par3) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRendererObj, "Server Finder", this.width / 2, 20, 0xFFFFFF);
        this.drawCenteredString(this.fontRendererObj, "This will search for servers with similar IPs", this.width / 2, 40, 0xA0A0A0);
        this.drawCenteredString(this.fontRendererObj, "to the IP you type into the field below.", this.width / 2, 50, 0xA0A0A0);
        this.drawCenteredString(this.fontRendererObj, "The servers it finds will be added to your server list.", this.width / 2, 60, 0xA0A0A0);
        this.drawString(this.fontRendererObj, "Numeric IP without port", this.width / 2 - 100, this.height / 4 + 24, 0xA0A0A0);
        this.ipBox.drawTextBox();
        this.drawString(this.fontRendererObj, "Max. threads:", this.width / 2 - 100, this.height / 4 + 60, 0xA0A0A0);
        this.maxThreadsBox.drawTextBox();
        if (!((GuiButton)this.buttonList.get((int)0)).enabled) {
            if (this.ipBox.getText().length() == 0) {
                this.drawCenteredString(this.fontRendererObj, "\u00a74IP field is empty!", this.width / 2, this.height / 4 + 73, 0xA0A0A0);
            } else if (this.ipBox.getText().contains(":")) {
                this.drawCenteredString(this.fontRendererObj, "\u00a74Ports are not supported!", this.width / 2, this.height / 4 + 73, 0xA0A0A0);
            } else if (!MiscUtils.isInteger(this.ipBox.getText().split("\\.", -1)[0])) {
                this.drawCenteredString(this.fontRendererObj, "\u00a74Hostnames are not supported!", this.width / 2, this.height / 4 + 73, 0xA0A0A0);
            } else if (StringUtils.countMatches((CharSequence)this.ipBox.getText(), (CharSequence)".") >= 1 && !MiscUtils.isInteger(this.ipBox.getText().split("\\.", -1)[1])) {
                this.drawCenteredString(this.fontRendererObj, "\u00a74Hostnames are not supported!", this.width / 2, this.height / 4 + 73, 0xA0A0A0);
            } else if (StringUtils.countMatches((CharSequence)this.ipBox.getText(), (CharSequence)".") >= 2 && !MiscUtils.isInteger(this.ipBox.getText().split("\\.", -1)[2])) {
                this.drawCenteredString(this.fontRendererObj, "\u00a74Hostnames are not supported!", this.width / 2, this.height / 4 + 73, 0xA0A0A0);
            } else if (StringUtils.countMatches((CharSequence)this.ipBox.getText(), (CharSequence)".") >= 3 && !MiscUtils.isInteger(this.ipBox.getText().split("\\.", -1)[3])) {
                this.drawCenteredString(this.fontRendererObj, "\u00a74Hostnames are not supported!", this.width / 2, this.height / 4 + 73, 0xA0A0A0);
            } else if (StringUtils.countMatches((CharSequence)this.ipBox.getText(), (CharSequence)".") < 3) {
                this.drawCenteredString(this.fontRendererObj, "\u00a74IP is too short!", this.width / 2, this.height / 4 + 73, 0xA0A0A0);
            } else if (StringUtils.countMatches((CharSequence)this.ipBox.getText(), (CharSequence)".") > 3) {
                this.drawCenteredString(this.fontRendererObj, "\u00a74IP is too long!", this.width / 2, this.height / 4 + 73, 0xA0A0A0);
            } else if (!MiscUtils.isInteger(this.maxThreadsBox.getText())) {
                this.drawCenteredString(this.fontRendererObj, "\u00a74Max. threads must be a number!", this.width / 2, this.height / 4 + 73, 0xA0A0A0);
            } else if (this.running) {
                if (this.checked == 1024) {
                    this.drawCenteredString(this.fontRendererObj, "\u00a72Done!", this.width / 2, this.height / 4 + 73, 0xA0A0A0);
                } else {
                    this.drawCenteredString(this.fontRendererObj, "\u00a72Searching...", this.width / 2, this.height / 4 + 73, 0xA0A0A0);
                }
            } else {
                this.drawCenteredString(this.fontRendererObj, "\u00a74Unknown error! Bug?", this.width / 2, this.height / 4 + 73, 0xA0A0A0);
            }
        }
        this.drawString(this.fontRendererObj, "Checked: " + this.checked + " / 1024", this.width / 2 - 100, this.height / 4 + 84, 0xA0A0A0);
        this.drawString(this.fontRendererObj, "Working: " + this.working, this.width / 2 - 100, this.height / 4 + 94, 0xA0A0A0);
        super.drawScreen(par1, par2, par3);
    }
}

