/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.update;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Updater {
    private static final Logger logger = LogManager.getLogger();
    private boolean outdated;
    private JsonArray json;
    private JsonObject latestRelease;
    private String currentVersion;
    private int currentMajor;
    private int currentMinor;
    private int currentPatch;
    private int currentPreRelease;
    private String latestVersion;
    private int latestMajor;
    private int latestMinor;
    private int latestPatch;
    private int latestPreRelease;

    public void checkForUpdate() {
        try {
            this.currentVersion = "2.5";
            this.outdated = false;
            try {
                this.currentMajor = Integer.parseInt(this.currentVersion.split("\\.")[0]);
                this.currentPreRelease = this.currentVersion.contains("pre") ? Integer.parseInt(this.currentVersion.substring(this.currentVersion.indexOf("pre") + 3)) : 0;
                this.currentPatch = this.currentVersion.split("\\.").length > 2 ? (this.currentPreRelease == 0 ? Integer.parseInt(this.currentVersion.split("\\.")[2]) : Integer.parseInt(this.currentVersion.split("\\.")[2].substring(0, this.currentVersion.split("\\.")[2].indexOf("pre")))) : 0;
                this.currentMinor = this.currentPreRelease == 0 || this.currentPatch > 0 ? Integer.parseInt(this.currentVersion.split("\\.")[1]) : Integer.parseInt(this.currentVersion.split("\\.")[1].substring(0, this.currentVersion.split("\\.")[1].indexOf("pre")));
            }
            catch (Exception e) {
                logger.error("Current version (\"" + this.currentVersion + "\") doesn't follow the semver.org syntax!", (Throwable)e);
            }
            HttpsURLConnection connection = (HttpsURLConnection)new URL("https://api.github.com/repos/Wurst-Imperium/Wurst-Client/releases").openConnection();
            BufferedReader load = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String content = load.readLine();
            String line = "";
            while ((line = load.readLine()) != null) {
                content = String.valueOf(content) + "\n" + line;
            }
            load.close();
            this.json = new JsonParser().parse(content).getAsJsonArray();
            this.latestRelease = new JsonObject();
            for (JsonElement release : this.json) {
                if (release.getAsJsonObject().get("prerelease").getAsBoolean() && this.currentPreRelease <= 0) continue;
                this.latestRelease = release.getAsJsonObject();
                break;
            }
            this.latestVersion = this.latestRelease.get("tag_name").getAsString().substring(1);
            try {
                this.latestMajor = Integer.parseInt(this.latestVersion.split("\\.")[0]);
                this.latestPreRelease = this.latestVersion.contains("pre") ? Integer.parseInt(this.latestVersion.substring(this.latestVersion.indexOf("pre") + 3)) : 0;
                this.latestPatch = this.latestVersion.split("\\.").length > 2 ? (this.latestPreRelease == 0 ? Integer.parseInt(this.latestVersion.split("\\.")[2]) : Integer.parseInt(this.latestVersion.split("\\.")[2].substring(0, this.latestVersion.split("\\.")[2].indexOf("pre")))) : 0;
                this.latestMinor = this.latestPreRelease == 0 || this.latestPatch > 0 ? Integer.parseInt(this.latestVersion.split("\\.")[1]) : Integer.parseInt(this.latestVersion.split("\\.")[1].substring(0, this.latestVersion.split("\\.")[1].indexOf("pre")));
            }
            catch (Exception e) {
                logger.error("Latest version (\"" + this.latestVersion + "\") doesn't follow the semver.org syntax!", (Throwable)e);
            }
            try {
                this.outdated = this.isLatestVersionHigher();
            }
            catch (Exception e) {
                boolean bl = this.outdated = !this.latestVersion.equals(this.currentVersion);
            }
            if (this.outdated) {
                logger.info("Update found: " + this.latestVersion);
            } else {
                logger.info("No update found.");
            }
        }
        catch (Exception e) {
            logger.error("Unable to check for updates!", (Throwable)e);
        }
    }

    private boolean isLatestVersionHigher() {
        if (this.latestMajor > this.currentMajor) {
            return true;
        }
        if (this.latestMajor < this.currentMajor) {
            return false;
        }
        if (this.latestMinor > this.currentMinor) {
            return true;
        }
        if (this.latestMinor < this.currentMinor) {
            return false;
        }
        if (this.latestPatch > this.currentPatch) {
            return true;
        }
        if (this.latestPatch < this.currentPatch) {
            return false;
        }
        return this.latestPreRelease > this.currentPreRelease || this.latestPreRelease == 0 && this.currentPreRelease > 0;
    }

    public void update() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String message;
                    int length;
                    if ((char)this.getClass().getClassLoader().getResourceAsStream("assets/minecraft/wurst/updater").read() == "0".toCharArray()[0]) {
                        return;
                    }
                    File updater = new File(Updater.class.getProtectionDomain().getCodeSource().getLocation().getPath());
                    if (!updater.isDirectory()) {
                        updater = updater.getParentFile();
                    }
                    updater = new File(updater, "Wurst-updater.jar");
                    updater = new File(updater.getAbsolutePath().replace("%20", " "));
                    InputStream input = this.getClass().getClassLoader().getResourceAsStream("assets/minecraft/wurst/Wurst-updater.jar");
                    FileOutputStream output = new FileOutputStream(updater);
                    byte[] buffer = new byte[8192];
                    while ((length = input.read(buffer)) != -1) {
                        output.write(buffer, 0, length);
                    }
                    input.close();
                    output.close();
                    String id = Updater.this.currentPreRelease > 0 ? Updater.this.json.get(0).getAsJsonObject().get("id").getAsString() : new JsonParser().parse((Reader)new InputStreamReader(new URL("https://api.github.com/repos/Wurst-Imperium/Wurst-Client/releases/latest").openStream())).getAsJsonObject().get("id").getAsString();
                    ProcessBuilder pb = new ProcessBuilder("cmd.exe", "/c", "java", "-jar", updater.getAbsolutePath(), "update", id, updater.getParentFile().getAbsolutePath().replace(" ", "%20"));
                    pb.redirectErrorStream(true);
                    Process p = pb.start();
                    BufferedReader pInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    while ((message = pInput.readLine()) != null) {
                        System.out.println(message);
                    }
                    pInput.close();
                }
                catch (Exception e) {
                    logger.error("Could not update!", (Throwable)e);
                }
            }
        }).start();
    }

    public boolean isOutdated() {
        return this.outdated;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }
}

