/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ConnectedTextures {
    private static Map[] spriteQuadMaps = null;
    private static ConnectedProperties[][] blockProperties = null;
    private static ConnectedProperties[][] tileProperties = null;
    private static boolean multipass = false;
    private static final int Y_NEG_DOWN = 0;
    private static final int Y_POS_UP = 1;
    private static final int Z_NEG_NORTH = 2;
    private static final int Z_POS_SOUTH = 3;
    private static final int X_NEG_WEST = 4;
    private static final int X_POS_EAST = 5;
    private static final int Y_AXIS = 0;
    private static final int Z_AXIS = 1;
    private static final int X_AXIS = 2;
    private static final String[] propSuffixes = new String[]{"", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    private static final int[] ctmIndexes = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 0, 0, 0, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 0, 0, 0, 0, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 0, 0, 0, 0, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 0, 0, 0, 0, 0};
    public static final alz AIR_DEFAULT_STATE = afi.a.Q();
    private static bmi emptySprite = null;

    public static synchronized bgg getConnectedTexture(adq blockAccess, alz blockState, cj blockPos, bgg quad, RenderEnv renderEnv) {
        alz stateNeighbour;
        bmi spriteIn = quad.getSprite();
        if (spriteIn == null) {
            return quad;
        }
        afh block = blockState.c();
        cq side = quad.d();
        if (block instanceof akd && spriteIn.i().startsWith("minecraft:blocks/glass_pane_top") && (stateNeighbour = blockAccess.p(blockPos.a(quad.d()))) == blockState) {
            return ConnectedTextures.getQuad(emptySprite, block, blockState, quad);
        }
        bmi sprite = ConnectedTextures.getConnectedTextureMultiPass(blockAccess, blockState, blockPos, side, spriteIn, renderEnv);
        if (sprite == spriteIn) {
            return quad;
        }
        return ConnectedTextures.getQuad(sprite, block, blockState, quad);
    }

    private static bgg getQuad(bmi sprite, afh block, alz blockState, bgg quadIn) {
        bgg quad;
        if (spriteQuadMaps == null) {
            return quadIn;
        }
        int spriteIndex = sprite.getIndexInMap();
        if (spriteIndex < 0 || spriteIndex >= spriteQuadMaps.length) {
            return quadIn;
        }
        IdentityHashMap<bgg, bgg> quadMap = spriteQuadMaps[spriteIndex];
        if (quadMap == null) {
            ConnectedTextures.spriteQuadMaps[spriteIndex] = quadMap = new IdentityHashMap<bgg, bgg>(1);
        }
        if ((quad = (bgg)quadMap.get(quadIn)) == null) {
            quad = ConnectedTextures.makeSpriteQuad(quadIn, sprite);
            quadMap.put(quadIn, quad);
        }
        return quad;
    }

    private static bgg makeSpriteQuad(bgg quad, bmi sprite) {
        int[] data = (int[])quad.a().clone();
        bmi spriteFrom = quad.getSprite();
        for (int i2 = 0; i2 < 4; ++i2) {
            ConnectedTextures.fixVertex(data, i2, spriteFrom, sprite);
        }
        bgg bq = new bgg(data, quad.c(), quad.d(), sprite);
        return bq;
    }

    private static void fixVertex(int[] data, int vertex, bmi spriteFrom, bmi spriteTo) {
        int mul = data.length / 4;
        int pos = mul * vertex;
        float u = Float.intBitsToFloat(data[pos + 4]);
        float v = Float.intBitsToFloat(data[pos + 4 + 1]);
        double su16 = spriteFrom.getSpriteU16(u);
        double sv16 = spriteFrom.getSpriteV16(v);
        data[pos + 4] = Float.floatToRawIntBits(spriteTo.a(su16));
        data[pos + 4 + 1] = Float.floatToRawIntBits(spriteTo.b(sv16));
    }

    private static bmi getConnectedTextureMultiPass(adq blockAccess, alz blockState, cj blockPos, cq side, bmi icon, RenderEnv renderEnv) {
        bmi newMpIcon;
        bmi newIcon = ConnectedTextures.getConnectedTextureSingle(blockAccess, blockState, blockPos, side, icon, true, renderEnv);
        if (!multipass) {
            return newIcon;
        }
        if (newIcon == icon) {
            return newIcon;
        }
        bmi mpIcon = newIcon;
        for (int i2 = 0; i2 < 3 && (newMpIcon = ConnectedTextures.getConnectedTextureSingle(blockAccess, blockState, blockPos, side, mpIcon, false, renderEnv)) != mpIcon; ++i2) {
            mpIcon = newMpIcon;
        }
        return mpIcon;
    }

    public static bmi getConnectedTextureSingle(adq blockAccess, alz blockState, cj blockPos, cq facing, bmi icon, boolean checkBlocks, RenderEnv renderEnv) {
        int blockId;
        ConnectedProperties cp;
        int i2;
        int side;
        int metadata;
        ConnectedProperties[] cps;
        int iconId;
        afh block = blockState.c();
        if (tileProperties != null && (iconId = icon.getIndexInMap()) >= 0 && iconId < tileProperties.length && (cps = tileProperties[iconId]) != null) {
            metadata = renderEnv.getMetadata();
            side = ConnectedTextures.getSide(facing);
            for (i2 = 0; i2 < cps.length; ++i2) {
                bmi newIcon;
                int blockId2;
                cp = cps[i2];
                if (cp == null || !cp.matchesBlock(blockId2 = renderEnv.getBlockId()) || (newIcon = ConnectedTextures.getConnectedTexture(cp, blockAccess, blockState, blockPos, side, icon, metadata, renderEnv)) == null) continue;
                return newIcon;
            }
        }
        if (blockProperties != null && checkBlocks && (blockId = renderEnv.getBlockId()) >= 0 && blockId < blockProperties.length && (cps = blockProperties[blockId]) != null) {
            metadata = renderEnv.getMetadata();
            side = ConnectedTextures.getSide(facing);
            for (i2 = 0; i2 < cps.length; ++i2) {
                bmi newIcon;
                cp = cps[i2];
                if (cp == null || !cp.matchesIcon(icon) || (newIcon = ConnectedTextures.getConnectedTexture(cp, blockAccess, blockState, blockPos, side, icon, metadata, renderEnv)) == null) continue;
                return newIcon;
            }
        }
        return icon;
    }

    public static int getSide(cq facing) {
        if (facing == null) {
            return -1;
        }
        switch (facing) {
            case a: {
                return 0;
            }
            case b: {
                return 1;
            }
            case f: {
                return 5;
            }
            case e: {
                return 4;
            }
            case c: {
                return 2;
            }
            case d: {
                return 3;
            }
        }
        return -1;
    }

    private static cq getFacing(int side) {
        switch (side) {
            case 0: {
                return cq.a;
            }
            case 1: {
                return cq.b;
            }
            case 5: {
                return cq.f;
            }
            case 4: {
                return cq.e;
            }
            case 2: {
                return cq.c;
            }
            case 3: {
                return cq.d;
            }
        }
        return cq.b;
    }

    private static bmi getConnectedTexture(ConnectedProperties cp, adq blockAccess, alz blockState, cj blockPos, int side, bmi icon, int metadata, RenderEnv renderEnv) {
        int y = blockPos.o();
        if (y < cp.minHeight || y > cp.maxHeight) {
            return null;
        }
        if (cp.biomes != null) {
            ady blockBiome = blockAccess.b(blockPos);
            boolean biomeOk = false;
            for (int i2 = 0; i2 < cp.biomes.length; ++i2) {
                ady biome = cp.biomes[i2];
                if (blockBiome != biome) continue;
                biomeOk = true;
                break;
            }
            if (!biomeOk) {
                return null;
            }
        }
        int vertAxis = 0;
        int metadataCheck = metadata;
        afh block = blockState.c();
        if (block instanceof ajg) {
            vertAxis = ConnectedTextures.getWoodAxis(side, metadata);
            metadataCheck &= 3;
        }
        if (block instanceof aiw) {
            vertAxis = ConnectedTextures.getQuartzAxis(side, metadata);
            if (metadataCheck > 2) {
                metadataCheck = 2;
            }
        }
        if (side >= 0 && cp.faces != 63) {
            int sideCheck = side;
            if (vertAxis != 0) {
                sideCheck = ConnectedTextures.fixSideByAxis(side, vertAxis);
            }
            if ((1 << sideCheck & cp.faces) == 0) {
                return null;
            }
        }
        if (cp.metadatas != null) {
            int[] mds = cp.metadatas;
            boolean metadataFound = false;
            for (int i3 = 0; i3 < mds.length; ++i3) {
                if (mds[i3] != metadataCheck) continue;
                metadataFound = true;
                break;
            }
            if (!metadataFound) {
                return null;
            }
        }
        switch (cp.method) {
            case 1: {
                return ConnectedTextures.getConnectedTextureCtm(cp, blockAccess, blockState, blockPos, side, icon, metadata, renderEnv);
            }
            case 2: {
                return ConnectedTextures.getConnectedTextureHorizontal(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
            }
            case 6: {
                return ConnectedTextures.getConnectedTextureVertical(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
            }
            case 3: {
                return ConnectedTextures.getConnectedTextureTop(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
            }
            case 4: {
                return ConnectedTextures.getConnectedTextureRandom(cp, blockPos, side);
            }
            case 5: {
                return ConnectedTextures.getConnectedTextureRepeat(cp, blockPos, side);
            }
            case 7: {
                return ConnectedTextures.getConnectedTextureFixed(cp);
            }
            case 8: {
                return ConnectedTextures.getConnectedTextureHorizontalVertical(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
            }
            case 9: {
                return ConnectedTextures.getConnectedTextureVerticalHorizontal(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
            }
        }
        return null;
    }

    private static int fixSideByAxis(int side, int vertAxis) {
        switch (vertAxis) {
            case 0: {
                return side;
            }
            case 1: {
                switch (side) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 0;
                    }
                }
                return side;
            }
            case 2: {
                switch (side) {
                    case 0: {
                        return 4;
                    }
                    case 1: {
                        return 5;
                    }
                    case 4: {
                        return 1;
                    }
                    case 5: {
                        return 0;
                    }
                }
                return side;
            }
        }
        return side;
    }

    private static int getWoodAxis(int side, int metadata) {
        int orient = (metadata & 0xC) >> 2;
        switch (orient) {
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
        }
        return 0;
    }

    private static int getQuartzAxis(int side, int metadata) {
        switch (metadata) {
            case 3: {
                return 2;
            }
            case 4: {
                return 1;
            }
        }
        return 0;
    }

    private static bmi getConnectedTextureRandom(ConnectedProperties cp, cj blockPos, int side) {
        if (cp.tileIcons.length == 1) {
            return cp.tileIcons[0];
        }
        int face = side / cp.symmetry * cp.symmetry;
        int rand = Config.getRandom(blockPos, face) & Integer.MAX_VALUE;
        int index = 0;
        if (cp.weights == null) {
            index = rand % cp.tileIcons.length;
        } else {
            int randWeight = rand % cp.sumAllWeights;
            int[] sumWeights = cp.sumWeights;
            for (int i2 = 0; i2 < sumWeights.length; ++i2) {
                if (randWeight >= sumWeights[i2]) continue;
                index = i2;
                break;
            }
        }
        return cp.tileIcons[index];
    }

    private static bmi getConnectedTextureFixed(ConnectedProperties cp) {
        return cp.tileIcons[0];
    }

    private static bmi getConnectedTextureRepeat(ConnectedProperties cp, cj blockPos, int side) {
        if (cp.tileIcons.length == 1) {
            return cp.tileIcons[0];
        }
        int x = blockPos.n();
        int y = blockPos.o();
        int z = blockPos.p();
        int nx2 = 0;
        int ny = 0;
        switch (side) {
            case 0: {
                nx2 = x;
                ny = z;
                break;
            }
            case 1: {
                nx2 = x;
                ny = z;
                break;
            }
            case 2: {
                nx2 = -x - 1;
                ny = -y;
                break;
            }
            case 3: {
                nx2 = x;
                ny = -y;
                break;
            }
            case 4: {
                nx2 = z;
                ny = -y;
                break;
            }
            case 5: {
                nx2 = -z - 1;
                ny = -y;
            }
        }
        ny %= cp.height;
        if ((nx2 %= cp.width) < 0) {
            nx2 += cp.width;
        }
        if (ny < 0) {
            ny += cp.height;
        }
        int index = ny * cp.width + nx2;
        return cp.tileIcons[index];
    }

    private static bmi getConnectedTextureCtm(ConnectedProperties cp, adq blockAccess, alz blockState, cj blockPos, int side, bmi icon, int metadata, RenderEnv renderEnv) {
        boolean[] borders = renderEnv.getBorderFlags();
        switch (side) {
            case 0: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                break;
            }
            case 1: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                break;
            }
            case 2: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                break;
            }
            case 3: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                break;
            }
            case 4: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                break;
            }
            case 5: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a(), side, icon, metadata);
            }
        }
        int index = 0;
        if (borders[0] & !borders[1] & !borders[2] & !borders[3]) {
            index = 3;
        } else if (!borders[0] & borders[1] & !borders[2] & !borders[3]) {
            index = 1;
        } else if (!borders[0] & !borders[1] & borders[2] & !borders[3]) {
            index = 12;
        } else if (!borders[0] & !borders[1] & !borders[2] & borders[3]) {
            index = 36;
        } else if (borders[0] & borders[1] & !borders[2] & !borders[3]) {
            index = 2;
        } else if (!borders[0] & !borders[1] & borders[2] & borders[3]) {
            index = 24;
        } else if (borders[0] & !borders[1] & borders[2] & !borders[3]) {
            index = 15;
        } else if (borders[0] & !borders[1] & !borders[2] & borders[3]) {
            index = 39;
        } else if (!borders[0] & borders[1] & borders[2] & !borders[3]) {
            index = 13;
        } else if (!borders[0] & borders[1] & !borders[2] & borders[3]) {
            index = 37;
        } else if (!borders[0] & borders[1] & borders[2] & borders[3]) {
            index = 25;
        } else if (borders[0] & !borders[1] & borders[2] & borders[3]) {
            index = 27;
        } else if (borders[0] & borders[1] & !borders[2] & borders[3]) {
            index = 38;
        } else if (borders[0] & borders[1] & borders[2] & !borders[3]) {
            index = 14;
        } else if (borders[0] & borders[1] & borders[2] & borders[3]) {
            index = 26;
        }
        if (index == 0) {
            return cp.tileIcons[index];
        }
        if (!Config.isConnectedTexturesFancy()) {
            return cp.tileIcons[index];
        }
        boolean[] edges = borders;
        switch (side) {
            case 0: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().c(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e().c(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().d(), side, icon, metadata);
                edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e().d(), side, icon, metadata);
                break;
            }
            case 1: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().d(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e().d(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().c(), side, icon, metadata);
                edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e().c(), side, icon, metadata);
                break;
            }
            case 2: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e().b(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().b(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e().a(), side, icon, metadata);
                edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().a(), side, icon, metadata);
                break;
            }
            case 3: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().b(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e().b(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().a(), side, icon, metadata);
                edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e().a(), side, icon, metadata);
                break;
            }
            case 4: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b().d(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b().c(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a().d(), side, icon, metadata);
                edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a().c(), side, icon, metadata);
                break;
            }
            case 5: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b().c(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b().d(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a().c(), side, icon, metadata);
                boolean bl = edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a().d(), side, icon, metadata);
            }
        }
        if (index == 13 && edges[0]) {
            index = 4;
        } else if (index == 15 && edges[1]) {
            index = 5;
        } else if (index == 37 && edges[2]) {
            index = 16;
        } else if (index == 39 && edges[3]) {
            index = 17;
        } else if (index == 14 && edges[0] && edges[1]) {
            index = 7;
        } else if (index == 25 && edges[0] && edges[2]) {
            index = 6;
        } else if (index == 27 && edges[3] && edges[1]) {
            index = 19;
        } else if (index == 38 && edges[3] && edges[2]) {
            index = 18;
        } else if (index == 14 && !edges[0] && edges[1]) {
            index = 31;
        } else if (index == 25 && edges[0] && !edges[2]) {
            index = 30;
        } else if (index == 27 && !edges[3] && edges[1]) {
            index = 41;
        } else if (index == 38 && edges[3] && !edges[2]) {
            index = 40;
        } else if (index == 14 && edges[0] && !edges[1]) {
            index = 29;
        } else if (index == 25 && !edges[0] && edges[2]) {
            index = 28;
        } else if (index == 27 && edges[3] && !edges[1]) {
            index = 43;
        } else if (index == 38 && !edges[3] && edges[2]) {
            index = 42;
        } else if (index == 26 && edges[0] && edges[1] && edges[2] && edges[3]) {
            index = 46;
        } else if (index == 26 && !edges[0] && edges[1] && edges[2] && edges[3]) {
            index = 9;
        } else if (index == 26 && edges[0] && !edges[1] && edges[2] && edges[3]) {
            index = 21;
        } else if (index == 26 && edges[0] && edges[1] && !edges[2] && edges[3]) {
            index = 8;
        } else if (index == 26 && edges[0] && edges[1] && edges[2] && !edges[3]) {
            index = 20;
        } else if (index == 26 && edges[0] && edges[1] && !edges[2] && !edges[3]) {
            index = 11;
        } else if (index == 26 && !edges[0] && !edges[1] && edges[2] && edges[3]) {
            index = 22;
        } else if (index == 26 && !edges[0] && edges[1] && !edges[2] && edges[3]) {
            index = 23;
        } else if (index == 26 && edges[0] && !edges[1] && edges[2] && !edges[3]) {
            index = 10;
        } else if (index == 26 && edges[0] && !edges[1] && !edges[2] && edges[3]) {
            index = 34;
        } else if (index == 26 && !edges[0] && edges[1] && edges[2] && !edges[3]) {
            index = 35;
        } else if (index == 26 && edges[0] && !edges[1] && !edges[2] && !edges[3]) {
            index = 32;
        } else if (index == 26 && !edges[0] && edges[1] && !edges[2] && !edges[3]) {
            index = 33;
        } else if (index == 26 && !edges[0] && !edges[1] && edges[2] && !edges[3]) {
            index = 44;
        } else if (index == 26 && !edges[0] && !edges[1] && !edges[2] && edges[3]) {
            index = 45;
        }
        return cp.tileIcons[index];
    }

    private static boolean isNeighbour(ConnectedProperties cp, adq iblockaccess, alz blockState, cj blockPos, int side, bmi icon, int metadata) {
        alz neighbourState = iblockaccess.p(blockPos);
        if (blockState == neighbourState) {
            return true;
        }
        if (cp.connect == 2) {
            if (neighbourState == null) {
                return false;
            }
            if (neighbourState == AIR_DEFAULT_STATE) {
                return false;
            }
            bmi neighbourIcon = ConnectedTextures.getNeighbourIcon(iblockaccess, blockPos, neighbourState, side);
            return neighbourIcon == icon;
        }
        if (cp.connect == 3) {
            if (neighbourState == null) {
                return false;
            }
            if (neighbourState == AIR_DEFAULT_STATE) {
                return false;
            }
            return neighbourState.c().t() == blockState.c().t();
        }
        return false;
    }

    private static bmi getNeighbourIcon(adq iblockaccess, cj blockPos, alz neighbourState, int side) {
        neighbourState = neighbourState.c().a(neighbourState, iblockaccess, blockPos);
        boq model = ave.A().ae().a().b(neighbourState);
        if (model == null) {
            return null;
        }
        cq facing = ConnectedTextures.getFacing(side);
        List quads = model.a(facing);
        if (quads.size() > 0) {
            bgg quad = (bgg)quads.get(0);
            return quad.getSprite();
        }
        List quadsGeneral = model.a();
        for (int i2 = 0; i2 < quadsGeneral.size(); ++i2) {
            bgg quad = (bgg)quadsGeneral.get(i2);
            if (quad.d() != facing) continue;
            return quad.getSprite();
        }
        return null;
    }

    private static bmi getConnectedTextureHorizontal(ConnectedProperties cp, adq blockAccess, alz blockState, cj blockPos, int vertAxis, int side, bmi icon, int metadata) {
        boolean left = false;
        boolean right = false;
        block0 : switch (vertAxis) {
            case 0: {
                switch (side) {
                    case 0: 
                    case 1: {
                        return null;
                    }
                    case 2: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                        break;
                    }
                    case 3: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        break;
                    }
                    case 4: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                        break;
                    }
                    case 5: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                    }
                }
                break;
            }
            case 1: {
                switch (side) {
                    case 2: 
                    case 3: {
                        return null;
                    }
                    case 0: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        break;
                    }
                    case 1: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        break;
                    }
                    case 4: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                        break;
                    }
                    case 5: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                    }
                }
                break;
            }
            case 2: {
                switch (side) {
                    case 4: 
                    case 5: {
                        return null;
                    }
                    case 2: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                        break block0;
                    }
                    case 3: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                        break block0;
                    }
                    case 0: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                        break block0;
                    }
                    case 1: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                    }
                }
            }
        }
        int index = 3;
        index = left ? (right ? 1 : 2) : (right ? 0 : 3);
        return cp.tileIcons[index];
    }

    private static bmi getConnectedTextureVertical(ConnectedProperties cp, adq blockAccess, alz blockState, cj blockPos, int vertAxis, int side, bmi icon, int metadata) {
        boolean bottom = false;
        boolean top = false;
        switch (vertAxis) {
            case 0: {
                if (side == 1 || side == 0) {
                    return null;
                }
                bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                break;
            }
            case 1: {
                if (side == 3 || side == 2) {
                    return null;
                }
                bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                break;
            }
            case 2: {
                if (side == 5 || side == 4) {
                    return null;
                }
                bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
            }
        }
        int index = 3;
        index = bottom ? (top ? 1 : 2) : (top ? 0 : 3);
        return cp.tileIcons[index];
    }

    private static bmi getConnectedTextureHorizontalVertical(ConnectedProperties cp, adq blockAccess, alz blockState, cj blockPos, int vertAxis, int side, bmi icon, int metadata) {
        bmi[] tileIcons = cp.tileIcons;
        bmi iconH = ConnectedTextures.getConnectedTextureHorizontal(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        if (iconH != null && iconH != icon && iconH != tileIcons[3]) {
            return iconH;
        }
        bmi iconV = ConnectedTextures.getConnectedTextureVertical(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        if (iconV == tileIcons[0]) {
            return tileIcons[4];
        }
        if (iconV == tileIcons[1]) {
            return tileIcons[5];
        }
        if (iconV == tileIcons[2]) {
            return tileIcons[6];
        }
        return iconV;
    }

    private static bmi getConnectedTextureVerticalHorizontal(ConnectedProperties cp, adq blockAccess, alz blockState, cj blockPos, int vertAxis, int side, bmi icon, int metadata) {
        bmi[] tileIcons = cp.tileIcons;
        bmi iconV = ConnectedTextures.getConnectedTextureVertical(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        if (iconV != null && iconV != icon && iconV != tileIcons[3]) {
            return iconV;
        }
        bmi iconH = ConnectedTextures.getConnectedTextureHorizontal(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        if (iconH == tileIcons[0]) {
            return tileIcons[4];
        }
        if (iconH == tileIcons[1]) {
            return tileIcons[5];
        }
        if (iconH == tileIcons[2]) {
            return tileIcons[6];
        }
        return iconH;
    }

    private static bmi getConnectedTextureTop(ConnectedProperties cp, adq blockAccess, alz blockState, cj blockPos, int vertAxis, int side, bmi icon, int metadata) {
        boolean top = false;
        switch (vertAxis) {
            case 0: {
                if (side == 1 || side == 0) {
                    return null;
                }
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                break;
            }
            case 1: {
                if (side == 3 || side == 2) {
                    return null;
                }
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                break;
            }
            case 2: {
                if (side == 5 || side == 4) {
                    return null;
                }
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
            }
        }
        if (top) {
            return cp.tileIcons[0];
        }
        return null;
    }

    public static void updateIcons(bmh textureMap) {
        blockProperties = null;
        tileProperties = null;
        if (!Config.isConnectedTextures()) {
            return;
        }
        bnk[] rps = Config.getResourcePacks();
        for (int i2 = rps.length - 1; i2 >= 0; --i2) {
            bnk rp = rps[i2];
            ConnectedTextures.updateIcons(textureMap, rp);
        }
        ConnectedTextures.updateIcons(textureMap, (bnk)Config.getDefaultResourcePack());
        jy locEmpty = new jy("mcpatcher/ctm/default/empty");
        emptySprite = textureMap.a(locEmpty);
        spriteQuadMaps = new Map[textureMap.getCountRegisteredSprites() + 1];
    }

    private static void updateIconEmpty(bmh textureMap) {
    }

    public static void updateIcons(bmh textureMap, bnk rp) {
        Object[] names = ConnectedTextures.collectFiles(rp, "mcpatcher/ctm/", ".properties");
        Arrays.sort(names);
        List tileList = ConnectedTextures.makePropertyList(tileProperties);
        List blockList = ConnectedTextures.makePropertyList(blockProperties);
        for (int i2 = 0; i2 < names.length; ++i2) {
            Object name = names[i2];
            Config.dbg("ConnectedTextures: " + (String)name);
            try {
                jy locFile = new jy((String)name);
                InputStream in = rp.a(locFile);
                if (in == null) {
                    Config.warn("ConnectedTextures file not found: " + (String)name);
                    continue;
                }
                Properties props = new Properties();
                props.load(in);
                ConnectedProperties cp = new ConnectedProperties(props, (String)name);
                if (!cp.isValid((String)name)) continue;
                cp.updateIcons(textureMap);
                ConnectedTextures.addToTileList(cp, tileList);
                ConnectedTextures.addToBlockList(cp, blockList);
                continue;
            }
            catch (FileNotFoundException e2) {
                Config.warn("ConnectedTextures file not found: " + (String)name);
                continue;
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
        blockProperties = ConnectedTextures.propertyListToArray(blockList);
        tileProperties = ConnectedTextures.propertyListToArray(tileList);
        multipass = ConnectedTextures.detectMultipass();
        Config.dbg("Multipass connected textures: " + multipass);
    }

    private static List makePropertyList(ConnectedProperties[][] propsArr) {
        ArrayList<ArrayList<ConnectedProperties>> list = new ArrayList<ArrayList<ConnectedProperties>>();
        if (propsArr != null) {
            for (int i2 = 0; i2 < propsArr.length; ++i2) {
                ConnectedProperties[] props = propsArr[i2];
                ArrayList<ConnectedProperties> propList = null;
                if (props != null) {
                    propList = new ArrayList<ConnectedProperties>(Arrays.asList(props));
                }
                list.add(propList);
            }
        }
        return list;
    }

    private static boolean detectMultipass() {
        ConnectedProperties[] cps;
        int i2;
        ArrayList<ConnectedProperties> propList = new ArrayList<ConnectedProperties>();
        for (i2 = 0; i2 < tileProperties.length; ++i2) {
            cps = tileProperties[i2];
            if (cps == null) continue;
            propList.addAll(Arrays.asList(cps));
        }
        for (i2 = 0; i2 < blockProperties.length; ++i2) {
            cps = blockProperties[i2];
            if (cps == null) continue;
            propList.addAll(Arrays.asList(cps));
        }
        ConnectedProperties[] props = propList.toArray(new ConnectedProperties[propList.size()]);
        HashSet<bmi> matchIconSet = new HashSet<bmi>();
        HashSet<bmi> tileIconSet = new HashSet<bmi>();
        for (int i3 = 0; i3 < props.length; ++i3) {
            ConnectedProperties cp = props[i3];
            if (cp.matchTileIcons != null) {
                matchIconSet.addAll(Arrays.asList(cp.matchTileIcons));
            }
            if (cp.tileIcons == null) continue;
            tileIconSet.addAll(Arrays.asList(cp.tileIcons));
        }
        matchIconSet.retainAll(tileIconSet);
        return !matchIconSet.isEmpty();
    }

    private static ConnectedProperties[][] propertyListToArray(List list) {
        ConnectedProperties[][] propArr = new ConnectedProperties[list.size()][];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            List subList = (List)list.get(i2);
            if (subList == null) continue;
            ConnectedProperties[] subArr = subList.toArray(new ConnectedProperties[subList.size()]);
            propArr[i2] = subArr;
        }
        return propArr;
    }

    private static void addToTileList(ConnectedProperties cp, List tileList) {
        if (cp.matchTileIcons == null) {
            return;
        }
        for (int i2 = 0; i2 < cp.matchTileIcons.length; ++i2) {
            bmi icon = cp.matchTileIcons[i2];
            if (!(icon instanceof bmi)) {
                Config.warn("TextureAtlasSprite is not TextureAtlasSprite: " + icon + ", name: " + icon.i());
                continue;
            }
            bmi ts2 = icon;
            int tileId = ts2.getIndexInMap();
            if (tileId < 0) {
                Config.warn("Invalid tile ID: " + tileId + ", icon: " + ts2.i());
                continue;
            }
            ConnectedTextures.addToList(cp, tileList, tileId);
        }
    }

    private static void addToBlockList(ConnectedProperties cp, List blockList) {
        if (cp.matchBlocks == null) {
            return;
        }
        for (int i2 = 0; i2 < cp.matchBlocks.length; ++i2) {
            int blockId = cp.matchBlocks[i2];
            if (blockId < 0) {
                Config.warn("Invalid block ID: " + blockId);
                continue;
            }
            ConnectedTextures.addToList(cp, blockList, blockId);
        }
    }

    private static void addToList(ConnectedProperties cp, List list, int id) {
        while (id >= list.size()) {
            list.add(null);
        }
        ArrayList<ConnectedProperties> subList = (ArrayList<ConnectedProperties>)list.get(id);
        if (subList == null) {
            subList = new ArrayList<ConnectedProperties>();
            list.set(id, subList);
        }
        subList.add(cp);
    }

    private static String[] collectFiles(bnk rp, String prefix, String suffix) {
        if (rp instanceof bna) {
            return ConnectedTextures.collectFilesDefault(rp);
        }
        if (!(rp instanceof bmx)) {
            return new String[0];
        }
        bmx arp = (bmx)rp;
        File tpFile = ResourceUtils.getResourcePackFile(arp);
        if (tpFile == null) {
            return new String[0];
        }
        if (tpFile.isDirectory()) {
            return ConnectedTextures.collectFilesFolder(tpFile, "", prefix, suffix);
        }
        if (tpFile.isFile()) {
            return ConnectedTextures.collectFilesZIP(tpFile, prefix, suffix);
        }
        return new String[0];
    }

    private static String[] collectFilesDefault(bnk rp) {
        ArrayList<String> list = new ArrayList<String>();
        String[] names = ConnectedTextures.getDefaultCtmPaths();
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            jy loc = new jy(name);
            if (!rp.b(loc)) continue;
            list.add(name);
        }
        String[] nameArr = list.toArray(new String[list.size()]);
        return nameArr;
    }

    private static String[] getDefaultCtmPaths() {
        ArrayList<String> list = new ArrayList<String>();
        String defPath = "mcpatcher/ctm/default/";
        if (Config.isFromDefaultResourcePack(new jy("textures/blocks/glass.png"))) {
            list.add(defPath + "glass.properties");
            list.add(defPath + "glasspane.properties");
        }
        if (Config.isFromDefaultResourcePack(new jy("textures/blocks/bookshelf.png"))) {
            list.add(defPath + "bookshelf.properties");
        }
        if (Config.isFromDefaultResourcePack(new jy("textures/blocks/sandstone_normal.png"))) {
            list.add(defPath + "sandstone.properties");
        }
        String[] colors = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "silver", "cyan", "purple", "blue", "brown", "green", "red", "black"};
        for (int i2 = 0; i2 < colors.length; ++i2) {
            String color = colors[i2];
            if (!Config.isFromDefaultResourcePack(new jy("textures/blocks/glass_" + color + ".png"))) continue;
            list.add(defPath + i2 + "_glass_" + color + "/glass_" + color + ".properties");
            list.add(defPath + i2 + "_glass_" + color + "/glass_pane_" + color + ".properties");
        }
        String[] paths = list.toArray(new String[list.size()]);
        return paths;
    }

    private static String[] collectFilesFolder(File tpFile, String basePath, String prefix, String suffix) {
        ArrayList<String> list = new ArrayList<String>();
        String prefixAssets = "assets/minecraft/";
        File[] files = tpFile.listFiles();
        if (files == null) {
            return new String[0];
        }
        for (int i2 = 0; i2 < files.length; ++i2) {
            File file = files[i2];
            if (file.isFile()) {
                String name = basePath + file.getName();
                if (!name.startsWith(prefixAssets) || !(name = name.substring(prefixAssets.length())).startsWith(prefix) || !name.endsWith(suffix)) continue;
                list.add(name);
                continue;
            }
            if (!file.isDirectory()) continue;
            String dirPath = basePath + file.getName() + "/";
            String[] names = ConnectedTextures.collectFilesFolder(file, dirPath, prefix, suffix);
            for (int n2 = 0; n2 < names.length; ++n2) {
                String name = names[n2];
                list.add(name);
            }
        }
        String[] names = list.toArray(new String[list.size()]);
        return names;
    }

    private static String[] collectFilesZIP(File tpFile, String prefix, String suffix) {
        ArrayList<String> list = new ArrayList<String>();
        String prefixAssets = "assets/minecraft/";
        try {
            ZipFile zf = new ZipFile(tpFile);
            Enumeration<? extends ZipEntry> en = zf.entries();
            while (en.hasMoreElements()) {
                ZipEntry ze2 = en.nextElement();
                String name = ze2.getName();
                if (!name.startsWith(prefixAssets) || !(name = name.substring(prefixAssets.length())).startsWith(prefix) || !name.endsWith(suffix)) continue;
                list.add(name);
            }
            zf.close();
            String[] names = list.toArray(new String[list.size()]);
            return names;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return new String[0];
        }
    }

    public static int getPaneTextureIndex(boolean linkP, boolean linkN, boolean linkYp, boolean linkYn) {
        if (linkN && linkP) {
            if (linkYp) {
                if (linkYn) {
                    return 34;
                }
                return 50;
            }
            if (linkYn) {
                return 18;
            }
            return 2;
        }
        if (linkN && !linkP) {
            if (linkYp) {
                if (linkYn) {
                    return 35;
                }
                return 51;
            }
            if (linkYn) {
                return 19;
            }
            return 3;
        }
        if (!linkN && linkP) {
            if (linkYp) {
                if (linkYn) {
                    return 33;
                }
                return 49;
            }
            if (linkYn) {
                return 17;
            }
            return 1;
        }
        if (linkYp) {
            if (linkYn) {
                return 32;
            }
            return 48;
        }
        if (linkYn) {
            return 16;
        }
        return 0;
    }

    public static int getReversePaneTextureIndex(int texNum) {
        int col = texNum % 16;
        if (col == 1) {
            return texNum + 2;
        }
        if (col == 3) {
            return texNum - 2;
        }
        return texNum;
    }

    public static bmi getCtmTexture(ConnectedProperties cp, int ctmIndex, bmi icon) {
        if (cp.method != 1) {
            return icon;
        }
        if (ctmIndex < 0 || ctmIndex >= ctmIndexes.length) {
            return icon;
        }
        int index = ctmIndexes[ctmIndex];
        bmi[] ctmIcons = cp.tileIcons;
        if (index < 0 || index >= ctmIcons.length) {
            return icon;
        }
        return ctmIcons[index];
    }
}

