/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import javax.imageio.ImageIO;

public class CustomColorizer {
    private static int[] grassColors = null;
    private static int[] waterColors = null;
    private static int[] foliageColors = null;
    private static int[] foliagePineColors = null;
    private static int[] foliageBirchColors = null;
    private static int[] swampFoliageColors = null;
    private static int[] swampGrassColors = null;
    private static int[][] blockPalettes = null;
    private static int[][] paletteColors = null;
    private static int[] skyColors = null;
    private static int[] fogColors = null;
    private static int[] underwaterColors = null;
    private static float[][][] lightMapsColorsRgb = null;
    private static int[] lightMapsHeight = null;
    private static float[][] sunRgbs = new float[16][3];
    private static float[][] torchRgbs = new float[16][3];
    private static int[] redstoneColors = null;
    private static int[] stemColors = null;
    private static int[] myceliumParticleColors = null;
    private static boolean useDefaultColorMultiplier = true;
    private static int particleWaterColor = -1;
    private static int particlePortalColor = -1;
    private static int lilyPadColor = -1;
    private static aui fogColorNether = null;
    private static aui fogColorEnd = null;
    private static aui skyColorEnd = null;
    private static final int TYPE_NONE = 0;
    private static final int TYPE_GRASS = 1;
    private static final int TYPE_FOLIAGE = 2;
    private static Random random = new Random();

    public static void update() {
        grassColors = null;
        waterColors = null;
        foliageColors = null;
        foliageBirchColors = null;
        foliagePineColors = null;
        swampGrassColors = null;
        swampFoliageColors = null;
        skyColors = null;
        fogColors = null;
        underwaterColors = null;
        redstoneColors = null;
        stemColors = null;
        myceliumParticleColors = null;
        lightMapsColorsRgb = null;
        lightMapsHeight = null;
        lilyPadColor = -1;
        particleWaterColor = -1;
        particlePortalColor = -1;
        fogColorNether = null;
        fogColorEnd = null;
        skyColorEnd = null;
        blockPalettes = null;
        paletteColors = null;
        useDefaultColorMultiplier = true;
        String mcpColormap = "mcpatcher/colormap/";
        grassColors = CustomColorizer.getCustomColors("textures/colormap/grass.png", 65536);
        foliageColors = CustomColorizer.getCustomColors("textures/colormap/foliage.png", 65536);
        String[] waterPaths = new String[]{"water.png", "watercolorX.png"};
        waterColors = CustomColorizer.getCustomColors(mcpColormap, waterPaths, 65536);
        if (!Config.isCustomColors()) {
            return;
        }
        String[] pinePaths = new String[]{"pine.png", "pinecolor.png"};
        foliagePineColors = CustomColorizer.getCustomColors(mcpColormap, pinePaths, 65536);
        String[] birchPaths = new String[]{"birch.png", "birchcolor.png"};
        foliageBirchColors = CustomColorizer.getCustomColors(mcpColormap, birchPaths, 65536);
        String[] swampGrassPaths = new String[]{"swampgrass.png", "swampgrasscolor.png"};
        swampGrassColors = CustomColorizer.getCustomColors(mcpColormap, swampGrassPaths, 65536);
        String[] swampFoliagePaths = new String[]{"swampfoliage.png", "swampfoliagecolor.png"};
        swampFoliageColors = CustomColorizer.getCustomColors(mcpColormap, swampFoliagePaths, 65536);
        String[] sky0Paths = new String[]{"sky0.png", "skycolor0.png"};
        skyColors = CustomColorizer.getCustomColors(mcpColormap, sky0Paths, 65536);
        String[] fog0Paths = new String[]{"fog0.png", "fogcolor0.png"};
        fogColors = CustomColorizer.getCustomColors(mcpColormap, fog0Paths, 65536);
        String[] underwaterPaths = new String[]{"underwater.png", "underwatercolor.png"};
        underwaterColors = CustomColorizer.getCustomColors(mcpColormap, underwaterPaths, 65536);
        String[] redstonePaths = new String[]{"redstone.png", "redstonecolor.png"};
        redstoneColors = CustomColorizer.getCustomColors(mcpColormap, redstonePaths, 16);
        String[] stemPaths = new String[]{"stem.png", "stemcolor.png"};
        stemColors = CustomColorizer.getCustomColors(mcpColormap, stemPaths, 8);
        String[] myceliumPaths = new String[]{"myceliumparticle.png", "myceliumparticlecolor.png"};
        myceliumParticleColors = CustomColorizer.getCustomColors(mcpColormap, myceliumPaths, -1);
        int[][] lightMapsColors = new int[3][];
        lightMapsColorsRgb = new float[3][][];
        lightMapsHeight = new int[3];
        for (int i2 = 0; i2 < lightMapsColors.length; ++i2) {
            String path = "mcpatcher/lightmap/world" + (i2 - 1) + ".png";
            lightMapsColors[i2] = CustomColorizer.getCustomColors(path, -1);
            if (lightMapsColors[i2] != null) {
                CustomColorizer.lightMapsColorsRgb[i2] = CustomColorizer.toRgb(lightMapsColors[i2]);
            }
            CustomColorizer.lightMapsHeight[i2] = CustomColorizer.getTextureHeight(path, 32);
        }
        CustomColorizer.readColorProperties("mcpatcher/color.properties");
        CustomColorizer.updateUseDefaultColorMultiplier();
    }

    private static int getTextureHeight(String path, int defHeight) {
        try {
            InputStream in = Config.getResourceStream(new jy(path));
            if (in == null) {
                return defHeight;
            }
            BufferedImage bi = ImageIO.read(in);
            if (bi == null) {
                return defHeight;
            }
            return bi.getHeight();
        }
        catch (IOException e2) {
            return defHeight;
        }
    }

    private static float[][] toRgb(int[] cols) {
        float[][] colsRgb = new float[cols.length][3];
        for (int i2 = 0; i2 < cols.length; ++i2) {
            int col = cols[i2];
            float rf = (float)(col >> 16 & 0xFF) / 255.0f;
            float gf = (float)(col >> 8 & 0xFF) / 255.0f;
            float bf = (float)(col & 0xFF) / 255.0f;
            float[] colRgb = colsRgb[i2];
            colRgb[0] = rf;
            colRgb[1] = gf;
            colRgb[2] = bf;
        }
        return colsRgb;
    }

    private static void readColorProperties(String fileName) {
        try {
            jy loc = new jy(fileName);
            InputStream in = Config.getResourceStream(loc);
            if (in == null) {
                return;
            }
            Config.log("Loading " + fileName);
            Properties props = new Properties();
            props.load(in);
            lilyPadColor = CustomColorizer.readColor(props, "lilypad");
            particleWaterColor = CustomColorizer.readColor(props, new String[]{"particle.water", "drop.water"});
            particlePortalColor = CustomColorizer.readColor(props, "particle.portal");
            fogColorNether = CustomColorizer.readColorVec3(props, "fog.nether");
            fogColorEnd = CustomColorizer.readColorVec3(props, "fog.end");
            skyColorEnd = CustomColorizer.readColorVec3(props, "sky.end");
            CustomColorizer.readCustomPalettes(props, fileName);
        }
        catch (FileNotFoundException e2) {
            return;
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void readCustomPalettes(Properties props, String fileName) {
        void var6_9;
        blockPalettes = new int[256][1];
        for (int i2 = 0; i2 < 256; ++i2) {
            CustomColorizer.blockPalettes[i2][0] = -1;
        }
        String palettePrefix = "palette.block.";
        HashMap<String, String> map = new HashMap<String, String>();
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(palettePrefix)) continue;
            map.put(string, value);
        }
        String[] propNames = map.keySet().toArray(new String[map.size()]);
        paletteColors = new int[propNames.length][];
        boolean bl = false;
        while (var6_9 < propNames.length) {
            String name = propNames[var6_9];
            String value = props.getProperty(name);
            Config.log("Block palette: " + name + " = " + value);
            String path = name.substring(palettePrefix.length());
            String basePath = TextureUtils.getBasePath(fileName);
            path = TextureUtils.fixResourcePath(path, basePath);
            int[] colors = CustomColorizer.getCustomColors(path, 65536);
            CustomColorizer.paletteColors[var6_9] = colors;
            String[] indexStrs = Config.tokenize(value, " ,;");
            for (int ix = 0; ix < indexStrs.length; ++ix) {
                int blockIndex;
                String blockStr = indexStrs[ix];
                int metadata = -1;
                if (blockStr.contains(":")) {
                    String[] blockStrs = Config.tokenize(blockStr, ":");
                    blockStr = blockStrs[0];
                    String metadataStr = blockStrs[1];
                    metadata = Config.parseInt(metadataStr, -1);
                    if (metadata < 0 || metadata > 15) {
                        Config.log("Invalid block metadata: " + blockStr + " in palette: " + name);
                        continue;
                    }
                }
                if ((blockIndex = Config.parseInt(blockStr, -1)) < 0 || blockIndex > 255) {
                    Config.log("Invalid block index: " + blockIndex + " in palette: " + name);
                    continue;
                }
                if (blockIndex == afh.a((afh)afi.c) || blockIndex == afh.a((afh)afi.H) || blockIndex == afh.a((afh)afi.t) || blockIndex == afh.a((afh)afi.bn)) continue;
                if (metadata == -1) {
                    CustomColorizer.blockPalettes[blockIndex][0] = var6_9;
                    continue;
                }
                if (blockPalettes[blockIndex].length < 16) {
                    CustomColorizer.blockPalettes[blockIndex] = new int[16];
                    Arrays.fill(blockPalettes[blockIndex], -1);
                }
                CustomColorizer.blockPalettes[blockIndex][metadata] = var6_9;
            }
            ++var6_9;
        }
    }

    private static int readColor(Properties props, String[] names) {
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            int col = CustomColorizer.readColor(props, name);
            if (col < 0) continue;
            return col;
        }
        return -1;
    }

    private static int readColor(Properties props, String name) {
        String str = props.getProperty(name);
        if (str == null) {
            return -1;
        }
        try {
            int val = Integer.parseInt(str, 16) & 0xFFFFFF;
            Config.log("Custom color: " + name + " = " + str);
            return val;
        }
        catch (NumberFormatException e2) {
            Config.log("Invalid custom color: " + name + " = " + str);
            return -1;
        }
    }

    private static aui readColorVec3(Properties props, String name) {
        int col = CustomColorizer.readColor(props, name);
        if (col < 0) {
            return null;
        }
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        return new aui((double)redF, (double)greenF, (double)blueF);
    }

    private static int[] getCustomColors(String basePath, String[] paths, int length) {
        for (int i2 = 0; i2 < paths.length; ++i2) {
            String path = paths[i2];
            path = basePath + path;
            int[] cols = CustomColorizer.getCustomColors(path, length);
            if (cols == null) continue;
            return cols;
        }
        return null;
    }

    private static int[] getCustomColors(String path, int length) {
        try {
            jy loc = new jy(path);
            InputStream in = Config.getResourceStream(loc);
            if (in == null) {
                return null;
            }
            int[] colors = bml.a(Config.getResourceManager(), loc);
            if (colors == null) {
                return null;
            }
            if (length > 0 && colors.length != length) {
                Config.log("Invalid custom colors length: " + colors.length + ", path: " + path);
                return null;
            }
            Config.log("Loading custom colors: " + path);
            return colors;
        }
        catch (FileNotFoundException e2) {
            return null;
        }
        catch (IOException e3) {
            e3.printStackTrace();
            return null;
        }
    }

    public static void updateUseDefaultColorMultiplier() {
        useDefaultColorMultiplier = foliageBirchColors == null && foliagePineColors == null && swampGrassColors == null && swampFoliageColors == null && blockPalettes == null && Config.isSwampColors() && Config.isSmoothBiomes();
    }

    public static int getColorMultiplier(bgg quad, afh block, adq blockAccess, cj blockPos, RenderEnv renderEnv) {
        int metadata;
        if (useDefaultColorMultiplier) {
            return -1;
        }
        int[] colors = null;
        int[] swampColors = null;
        if (blockPalettes != null) {
            int blockId = renderEnv.getBlockId();
            if (blockId >= 0 && blockId < 256) {
                int[] metadataPals = blockPalettes[blockId];
                int paletteIx = -1;
                if (metadataPals.length > 1) {
                    metadata = renderEnv.getMetadata();
                    paletteIx = metadataPals[metadata];
                } else {
                    paletteIx = metadataPals[0];
                }
                if (paletteIx >= 0) {
                    colors = paletteColors[paletteIx];
                }
            }
            if (colors != null) {
                if (Config.isSmoothBiomes()) {
                    return CustomColorizer.getSmoothColorMultiplier(block, blockAccess, blockPos, colors, colors, 0, 0, renderEnv);
                }
                return CustomColorizer.getCustomColor(colors, blockAccess, blockPos);
            }
        }
        if (!quad.b()) {
            return -1;
        }
        if (block == afi.bx) {
            return CustomColorizer.getLilypadColorMultiplier(blockAccess, blockPos);
        }
        if (block instanceof ajx) {
            return CustomColorizer.getStemColorMultiplier(block, blockAccess, blockPos, renderEnv);
        }
        boolean useSwampColors = Config.isSwampColors();
        boolean smoothColors = false;
        int type = 0;
        metadata = 0;
        if (block == afi.c || block == afi.H) {
            type = 1;
            smoothColors = Config.isSmoothBiomes();
            colors = grassColors;
            swampColors = useSwampColors ? swampGrassColors : colors;
        } else if (block == afi.t) {
            type = 2;
            smoothColors = Config.isSmoothBiomes();
            metadata = renderEnv.getMetadata();
            if ((metadata & 3) == 1) {
                colors = foliagePineColors;
            } else if ((metadata & 3) == 2) {
                colors = foliageBirchColors;
            } else {
                colors = foliageColors;
                swampColors = useSwampColors ? swampFoliageColors : colors;
            }
        } else if (block == afi.bn) {
            type = 2;
            smoothColors = Config.isSmoothBiomes();
            colors = foliageColors;
            swampColors = useSwampColors ? swampFoliageColors : colors;
        }
        if (smoothColors) {
            return CustomColorizer.getSmoothColorMultiplier(block, blockAccess, blockPos, colors, swampColors, type, metadata, renderEnv);
        }
        if (swampColors != colors && blockAccess.b(blockPos) == ady.v) {
            colors = swampColors;
        }
        if (colors != null) {
            return CustomColorizer.getCustomColor(colors, blockAccess, blockPos);
        }
        return -1;
    }

    private static int getSmoothColorMultiplier(afh block, adq blockAccess, cj blockPos, int[] colors, int[] swampColors, int type, int metadata, RenderEnv renderEnv) {
        int sumRed = 0;
        int sumGreen = 0;
        int sumBlue = 0;
        int x = blockPos.n();
        int y = blockPos.o();
        int z = blockPos.p();
        BlockPosM posM = renderEnv.getColorizerBlockPos();
        for (int ix = x - 1; ix <= x + 1; ++ix) {
            for (int iz = z - 1; iz <= z + 1; ++iz) {
                posM.setXyz(ix, y, iz);
                int[] cols = colors;
                if (swampColors != cols && blockAccess.b((cj)posM) == ady.v) {
                    cols = swampColors;
                }
                int col = 0;
                if (cols == null) {
                    switch (type) {
                        case 1: {
                            col = blockAccess.b((cj)posM).b((cj)posM);
                            break;
                        }
                        case 2: {
                            if ((metadata & 3) == 1) {
                                col = adj.a();
                                break;
                            }
                            if ((metadata & 3) == 2) {
                                col = adj.b();
                                break;
                            }
                            col = blockAccess.b((cj)posM).c((cj)posM);
                            break;
                        }
                        default: {
                            col = block.d(blockAccess, (cj)posM);
                            break;
                        }
                    }
                } else {
                    col = CustomColorizer.getCustomColor(cols, blockAccess, posM);
                }
                sumRed += col >> 16 & 0xFF;
                sumGreen += col >> 8 & 0xFF;
                sumBlue += col & 0xFF;
            }
        }
        int r2 = sumRed / 9;
        int g2 = sumGreen / 9;
        int b2 = sumBlue / 9;
        return r2 << 16 | g2 << 8 | b2;
    }

    public static int getFluidColor(afh block, adq blockAccess, cj blockPos) {
        if (block.t() != arm.h) {
            return block.d(blockAccess, blockPos);
        }
        if (waterColors != null) {
            if (Config.isSmoothBiomes()) {
                return CustomColorizer.getSmoothColor(waterColors, blockAccess, blockPos.n(), blockPos.o(), blockPos.p(), 3, 1);
            }
            return CustomColorizer.getCustomColor(waterColors, blockAccess, blockPos);
        }
        if (!Config.isSwampColors()) {
            return 0xFFFFFF;
        }
        return block.d(blockAccess, blockPos);
    }

    private static int getCustomColor(int[] colors, adq blockAccess, cj blockPos) {
        ady bgb2 = blockAccess.b(blockPos);
        double temperature = ns.a(bgb2.a(blockPos), 0.0f, 1.0f);
        double rainfall = ns.a(bgb2.i(), 0.0f, 1.0f);
        int cx = (int)((1.0 - temperature) * 255.0);
        int cy2 = (int)((1.0 - (rainfall *= temperature)) * 255.0);
        return colors[cy2 << 8 | cx] & 0xFFFFFF;
    }

    public static void updatePortalFX(beb fx) {
        if (particlePortalColor < 0) {
            return;
        }
        int col = particlePortalColor;
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx.b(redF, greenF, blueF);
    }

    public static void updateMyceliumFX(beb fx) {
        if (myceliumParticleColors == null) {
            return;
        }
        int col = myceliumParticleColors[random.nextInt(myceliumParticleColors.length)];
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx.b(redF, greenF, blueF);
    }

    public static void updateReddustFX(beb fx, adq blockAccess, double x, double y, double z) {
        if (redstoneColors == null) {
            return;
        }
        alz state = blockAccess.p(new cj(x, y, z));
        int level = CustomColorizer.getRedstoneLevel(state, 15);
        int col = CustomColorizer.getRedstoneColor(level);
        if (col == -1) {
            return;
        }
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx.b(redF, greenF, blueF);
    }

    private static int getRedstoneLevel(alz state, int def) {
        afh block = state.c();
        if (!(block instanceof ajb)) {
            return def;
        }
        Comparable val = state.b((amo)ajb.P);
        if (!(val instanceof Integer)) {
            return def;
        }
        Integer valInt = (Integer)val;
        return valInt;
    }

    public static int getRedstoneColor(int level) {
        if (redstoneColors == null) {
            return -1;
        }
        if (level < 0 || level > 15) {
            return -1;
        }
        return redstoneColors[level] & 0xFFFFFF;
    }

    public static void updateWaterFX(beb fx, adq blockAccess, double x, double y, double z) {
        if (waterColors == null) {
            return;
        }
        int col = CustomColorizer.getFluidColor((afh)afi.j, blockAccess, new cj(x, y, z));
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        if (particleWaterColor >= 0) {
            int redDrop = particleWaterColor >> 16 & 0xFF;
            int greenDrop = particleWaterColor >> 8 & 0xFF;
            int blueDrop = particleWaterColor & 0xFF;
            redF *= (float)redDrop / 255.0f;
            greenF *= (float)greenDrop / 255.0f;
            blueF *= (float)blueDrop / 255.0f;
        }
        fx.b(redF, greenF, blueF);
    }

    public static int getLilypadColorMultiplier(adq blockAccess, cj blockPos) {
        if (lilyPadColor < 0) {
            return afi.bx.d(blockAccess, blockPos);
        }
        return lilyPadColor;
    }

    public static aui getFogColorNether(aui col) {
        if (fogColorNether == null) {
            return col;
        }
        return fogColorNether;
    }

    public static aui getFogColorEnd(aui col) {
        if (fogColorEnd == null) {
            return col;
        }
        return fogColorEnd;
    }

    public static aui getSkyColorEnd(aui col) {
        if (skyColorEnd == null) {
            return col;
        }
        return skyColorEnd;
    }

    public static aui getSkyColor(aui skyColor3d, adq blockAccess, double x, double y, double z) {
        if (skyColors == null) {
            return skyColor3d;
        }
        int col = CustomColorizer.getSmoothColor(skyColors, blockAccess, x, y, z, 7, 1);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        float cRed = (float)skyColor3d.a / 0.5f;
        float cGreen = (float)skyColor3d.b / 0.66275f;
        float cBlue = (float)skyColor3d.c;
        return new aui((double)(redF *= cRed), (double)(greenF *= cGreen), (double)(blueF *= cBlue));
    }

    public static aui getFogColor(aui fogColor3d, adq blockAccess, double x, double y, double z) {
        if (fogColors == null) {
            return fogColor3d;
        }
        int col = CustomColorizer.getSmoothColor(fogColors, blockAccess, x, y, z, 7, 1);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        float cRed = (float)fogColor3d.a / 0.753f;
        float cGreen = (float)fogColor3d.b / 0.8471f;
        float cBlue = (float)fogColor3d.c;
        return new aui((double)(redF *= cRed), (double)(greenF *= cGreen), (double)(blueF *= cBlue));
    }

    public static aui getUnderwaterColor(adq blockAccess, double x, double y, double z) {
        if (underwaterColors == null) {
            return null;
        }
        int col = CustomColorizer.getSmoothColor(underwaterColors, blockAccess, x, y, z, 7, 1);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        return new aui((double)redF, (double)greenF, (double)blueF);
    }

    public static int getSmoothColor(int[] colors, adq blockAccess, double x, double y, double z, int samples, int step) {
        if (colors == null) {
            return -1;
        }
        int x0 = ns.c(x);
        int y0 = ns.c(y);
        int z0 = ns.c(z);
        int n2 = samples * step / 2;
        int sumRed = 0;
        int sumGreen = 0;
        int sumBlue = 0;
        int count = 0;
        BlockPosM blockPosM = new BlockPosM(0, 0, 0);
        for (int ix = x0 - n2; ix <= x0 + n2; ix += step) {
            for (int iz = z0 - n2; iz <= z0 + n2; iz += step) {
                blockPosM.setXyz(ix, y0, iz);
                int col = CustomColorizer.getCustomColor(colors, blockAccess, blockPosM);
                sumRed += col >> 16 & 0xFF;
                sumGreen += col >> 8 & 0xFF;
                sumBlue += col & 0xFF;
                ++count;
            }
        }
        int r2 = sumRed / count;
        int g2 = sumGreen / count;
        int b2 = sumBlue / count;
        return r2 << 16 | g2 << 8 | b2;
    }

    public static int mixColors(int c1, int c2, float w1) {
        if (w1 <= 0.0f) {
            return c2;
        }
        if (w1 >= 1.0f) {
            return c1;
        }
        float w2 = 1.0f - w1;
        int r1 = c1 >> 16 & 0xFF;
        int g1 = c1 >> 8 & 0xFF;
        int b1 = c1 & 0xFF;
        int r2 = c2 >> 16 & 0xFF;
        int g2 = c2 >> 8 & 0xFF;
        int b2 = c2 & 0xFF;
        int r3 = (int)((float)r1 * w1 + (float)r2 * w2);
        int g3 = (int)((float)g1 * w1 + (float)g2 * w2);
        int b3 = (int)((float)b1 * w1 + (float)b2 * w2);
        return r3 << 16 | g3 << 8 | b3;
    }

    private static int averageColor(int c1, int c2) {
        int r1 = c1 >> 16 & 0xFF;
        int g1 = c1 >> 8 & 0xFF;
        int b1 = c1 & 0xFF;
        int r2 = c2 >> 16 & 0xFF;
        int g2 = c2 >> 8 & 0xFF;
        int b2 = c2 & 0xFF;
        int r3 = (r1 + r2) / 2;
        int g3 = (g1 + g2) / 2;
        int b3 = (b1 + b2) / 2;
        return r3 << 16 | g3 << 8 | b3;
    }

    public static int getStemColorMultiplier(afh blockStem, adq blockAccess, cj blockPos, RenderEnv renderEnv) {
        if (stemColors == null) {
            return blockStem.d(blockAccess, blockPos);
        }
        int level = renderEnv.getMetadata();
        if (level < 0) {
            level = 0;
        }
        if (level >= stemColors.length) {
            level = stemColors.length - 1;
        }
        return stemColors[level];
    }

    public static boolean updateLightmap(adm world, float torchFlickerX, int[] lmColors, boolean nightvision) {
        if (world == null) {
            return false;
        }
        if (lightMapsColorsRgb == null) {
            return false;
        }
        if (!Config.isCustomColors()) {
            return false;
        }
        int worldType = world.t.q();
        if (worldType < -1 || worldType > 1) {
            return false;
        }
        int lightMapIndex = worldType + 1;
        float[][] lightMapRgb = lightMapsColorsRgb[lightMapIndex];
        if (lightMapRgb == null) {
            return false;
        }
        int height = lightMapsHeight[lightMapIndex];
        if (nightvision && height < 64) {
            return false;
        }
        int width = lightMapRgb.length / height;
        if (width < 16) {
            Config.warn("Invalid lightmap width: " + width + " for: /environment/lightmap" + worldType + ".png");
            CustomColorizer.lightMapsColorsRgb[lightMapIndex] = null;
            return false;
        }
        int startIndex = 0;
        if (nightvision) {
            startIndex = width * 16 * 2;
        }
        float sun = 1.1666666f * (world.b(1.0f) - 0.2f);
        if (world.ac() > 0) {
            sun = 1.0f;
        }
        sun = Config.limitTo1(sun);
        float sunX = sun * (float)(width - 1);
        float torchX = Config.limitTo1(torchFlickerX + 0.5f) * (float)(width - 1);
        float gamma = Config.limitTo1(Config.getGameSettings().aI);
        boolean hasGamma = gamma > 1.0E-4f;
        CustomColorizer.getLightMapColumn(lightMapRgb, sunX, startIndex, width, sunRgbs);
        CustomColorizer.getLightMapColumn(lightMapRgb, torchX, startIndex + 16 * width, width, torchRgbs);
        float[] rgb = new float[3];
        for (int is = 0; is < 16; ++is) {
            for (int it = 0; it < 16; ++it) {
                for (int ic = 0; ic < 3; ++ic) {
                    float comp = Config.limitTo1(sunRgbs[is][ic] + torchRgbs[it][ic]);
                    if (hasGamma) {
                        float cg = 1.0f - comp;
                        cg = 1.0f - cg * cg * cg * cg;
                        comp = gamma * cg + (1.0f - gamma) * comp;
                    }
                    rgb[ic] = comp;
                }
                int r2 = (int)(rgb[0] * 255.0f);
                int g2 = (int)(rgb[1] * 255.0f);
                int b2 = (int)(rgb[2] * 255.0f);
                lmColors[is * 16 + it] = 0xFF000000 | r2 << 16 | g2 << 8 | b2;
            }
        }
        return true;
    }

    private static void getLightMapColumn(float[][] origMap, float x, int offset, int width, float[][] colRgb) {
        int xHigh;
        int xLow = (int)Math.floor(x);
        if (xLow == (xHigh = (int)Math.ceil(x))) {
            for (int y = 0; y < 16; ++y) {
                float[] rgbLow = origMap[offset + y * width + xLow];
                float[] rgb = colRgb[y];
                for (int i2 = 0; i2 < 3; ++i2) {
                    rgb[i2] = rgbLow[i2];
                }
            }
            return;
        }
        float dLow = 1.0f - (x - (float)xLow);
        float dHigh = 1.0f - ((float)xHigh - x);
        for (int y = 0; y < 16; ++y) {
            float[] rgbLow = origMap[offset + y * width + xLow];
            float[] rgbHigh = origMap[offset + y * width + xHigh];
            float[] rgb = colRgb[y];
            for (int i3 = 0; i3 < 3; ++i3) {
                rgb[i3] = rgbLow[i3] * dLow + rgbHigh[i3] * dHigh;
            }
        }
    }

    public static aui getWorldFogColor(aui fogVec, bdb world, pk renderViewEntity, float partialTicks) {
        int worldType = world.t.q();
        switch (worldType) {
            case -1: {
                fogVec = CustomColorizer.getFogColorNether(fogVec);
                break;
            }
            case 0: {
                ave mc = ave.A();
                fogVec = CustomColorizer.getFogColor(fogVec, (adq)mc.f, renderViewEntity.s, renderViewEntity.t + 1.0, renderViewEntity.u);
                break;
            }
            case 1: {
                fogVec = CustomColorizer.getFogColorEnd(fogVec);
            }
        }
        return fogVec;
    }

    public static aui getWorldSkyColor(aui skyVec, bdb world, pk renderViewEntity, float partialTicks) {
        int worldType = world.t.q();
        switch (worldType) {
            case 0: {
                ave mc = ave.A();
                skyVec = CustomColorizer.getSkyColor(skyVec, (adq)mc.f, renderViewEntity.s, renderViewEntity.t + 1.0, renderViewEntity.u);
                break;
            }
            case 1: {
                skyVec = CustomColorizer.getSkyColorEnd(skyVec);
            }
        }
        return skyVec;
    }
}

