/*
 * Decompiled with CFR 0.152.
 */
package optifine;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.launchwrapper.IClassTransformer;

public class OptiFineClassTransformer
implements IClassTransformer {
    private ZipFile ofZipFile = null;

    public OptiFineClassTransformer() {
        try {
            URLClassLoader ucl = (URLClassLoader)OptiFineClassTransformer.class.getClassLoader();
            URL[] urls = ucl.getURLs();
            int i2 = 0;
            while (i2 < urls.length) {
                URL url = urls[i2];
                ZipFile zipFile = OptiFineClassTransformer.getOptiFineZipFile(url);
                if (zipFile != null) {
                    this.ofZipFile = zipFile;
                    OptiFineClassTransformer.dbg("OptiFine ClassTransformer");
                    OptiFineClassTransformer.dbg("OptiFine URL: " + url);
                    OptiFineClassTransformer.dbg("OptiFine ZIP file: " + zipFile);
                    break;
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        if (this.ofZipFile == null) {
            OptiFineClassTransformer.dbg("*** Can not find the OptiFine JAR in the classpath ***");
            OptiFineClassTransformer.dbg("*** OptiFine will not be loaded! ***");
        }
    }

    private static ZipFile getOptiFineZipFile(URL url) {
        ZipFile zipFile;
        block3: {
            try {
                URI uri = url.toURI();
                File file = new File(uri);
                zipFile = new ZipFile(file);
                if (zipFile.getEntry("optifine/OptiFineClassTransformer.class") != null) break block3;
                zipFile.close();
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return zipFile;
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        byte[] ofBytes = this.getOptiFineClass(name);
        if (ofBytes != null) {
            return ofBytes;
        }
        return bytes;
    }

    private byte[] getOptiFineClass(String name) {
        byte[] bytes;
        block5: {
            if (this.ofZipFile == null) {
                return null;
            }
            String fullName = String.valueOf(name) + ".class";
            ZipEntry ze2 = this.ofZipFile.getEntry(fullName);
            if (ze2 == null) {
                return null;
            }
            try {
                InputStream in = this.ofZipFile.getInputStream(ze2);
                bytes = OptiFineClassTransformer.readAll(in);
                if ((long)bytes.length == ze2.getSize()) break block5;
                OptiFineClassTransformer.dbg("Invalid size for " + fullName + ": " + bytes.length + ", should be: " + ze2.getSize());
                return null;
            }
            catch (IOException e2) {
                e2.printStackTrace();
                return null;
            }
        }
        return bytes;
    }

    public static byte[] readAll(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = is.read(buf)) >= 0) {
            baos.write(buf, 0, len);
        }
        is.close();
        byte[] bytes = baos.toByteArray();
        return bytes;
    }

    private static void dbg(String str) {
        System.out.println(str);
    }
}

