/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConnectedParser {
    private String context = null;

    public ConnectedParser(String context) {
        this.context = context;
    }

    public String parseName(String path) {
        int pos2;
        String str = path;
        int pos = str.lastIndexOf(47);
        if (pos >= 0) {
            str = str.substring(pos + 1);
        }
        if ((pos2 = str.lastIndexOf(46)) >= 0) {
            str = str.substring(0, pos2);
        }
        return str;
    }

    public String parseBasePath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos < 0) {
            return "";
        }
        return path.substring(0, pos);
    }

    public MatchBlock[] parseMatchBlocks(String propMatchBlocks) {
        if (propMatchBlocks == null) {
            return null;
        }
        ArrayList<MatchBlock> list = new ArrayList<MatchBlock>();
        String[] blockStrs = Config.tokenize(propMatchBlocks, " ");
        for (int i2 = 0; i2 < blockStrs.length; ++i2) {
            String blockStr = blockStrs[i2];
            MatchBlock[] mbs = this.parseMatchBlock(blockStr);
            if (mbs == null) {
                return null;
            }
            list.addAll(Arrays.asList(mbs));
        }
        MatchBlock[] mbs = list.toArray(new MatchBlock[list.size()]);
        return mbs;
    }

    public MatchBlock[] parseMatchBlock(String blockStr) {
        if (blockStr == null) {
            return null;
        }
        if ((blockStr = blockStr.trim()).length() <= 0) {
            return null;
        }
        String[] parts = Config.tokenize(blockStr, ":");
        String domain = "minecraft";
        int blockIndex = 0;
        if (parts.length > 1 && this.isFullBlockName(parts)) {
            domain = parts[0];
            blockIndex = 1;
        } else {
            domain = "minecraft";
            blockIndex = 0;
        }
        String blockPart = parts[blockIndex];
        String[] params = Arrays.copyOfRange(parts, blockIndex + 1, parts.length);
        afh[] blocks = this.parseBlockPart(domain, blockPart);
        MatchBlock[] datas = new MatchBlock[blocks.length];
        for (int i2 = 0; i2 < blocks.length; ++i2) {
            MatchBlock bd2;
            afh block = blocks[i2];
            int blockId = afh.a((afh)block);
            int[] metadatas = this.parseBlockMetadatas(block, params);
            datas[i2] = bd2 = new MatchBlock(blockId, metadatas);
        }
        return datas;
    }

    public boolean isFullBlockName(String[] parts) {
        if (parts.length < 2) {
            return false;
        }
        String part1 = parts[1];
        if (part1.length() < 1) {
            return false;
        }
        if (this.startsWithDigit(part1)) {
            return false;
        }
        return !part1.contains("=");
    }

    public boolean startsWithDigit(String str) {
        if (str == null) {
            return false;
        }
        if (str.length() < 1) {
            return false;
        }
        char ch = str.charAt(0);
        return Character.isDigit(ch);
    }

    public afh[] parseBlockPart(String domain, String blockPart) {
        if (this.startsWithDigit(blockPart)) {
            int[] ids = this.parseIntList(blockPart);
            if (ids == null) {
                return null;
            }
            afh[] blocks = new afh[ids.length];
            for (int i2 = 0; i2 < ids.length; ++i2) {
                int id = ids[i2];
                afh block = afh.c((int)id);
                if (block == null) {
                    this.warn("Block not found for id: " + id);
                    return null;
                }
                blocks[i2] = block;
            }
            return blocks;
        }
        String fullName = domain + ":" + blockPart;
        afh block = afh.b((String)fullName);
        if (block == null) {
            this.warn("Block not found for name: " + fullName);
            return null;
        }
        afh[] blocks = new afh[]{block};
        return blocks;
    }

    public int[] parseBlockMetadatas(afh block, String[] params) {
        if (params.length <= 0) {
            return null;
        }
        String param0 = params[0];
        if (this.startsWithDigit(param0)) {
            int[] mds = this.parseIntList(param0);
            return mds;
        }
        alz stateDefault = block.Q();
        Collection properties = stateDefault.a();
        HashMap mapPropValues = new HashMap();
        for (int i2 = 0; i2 < params.length; ++i2) {
            String param = params[i2];
            if (param.length() <= 0) continue;
            String[] parts = Config.tokenize(param, "=");
            if (parts.length != 2) {
                this.warn("Invalid block property: " + param);
                return null;
            }
            String key = parts[0];
            String valStr = parts[1];
            amo prop = ConnectedProperties.getProperty(key, properties);
            if (prop == null) {
                this.warn("Property not found: " + key + ", block: " + block);
                return null;
            }
            ArrayList<Comparable> list = (ArrayList<Comparable>)mapPropValues.get(key);
            if (list == null) {
                list = new ArrayList<Comparable>();
                mapPropValues.put(prop, list);
            }
            String[] vals = Config.tokenize(valStr, ",");
            for (int v = 0; v < vals.length; ++v) {
                String val = vals[v];
                Comparable propVal = ConnectedParser.parsePropertyValue(prop, val);
                if (propVal == null) {
                    this.warn("Property value not found: " + val + ", property: " + key + ", block: " + block);
                    return null;
                }
                list.add(propVal);
            }
        }
        if (mapPropValues.isEmpty()) {
            return null;
        }
        ArrayList<Integer> listMetadatas = new ArrayList<Integer>();
        for (int i3 = 0; i3 < 16; ++i3) {
            int md = i3;
            alz bs = block.a(md);
            if (!this.matchState(bs, mapPropValues)) continue;
            listMetadatas.add(md);
        }
        if (listMetadatas.size() == 16) {
            return null;
        }
        int[] metadatas = new int[listMetadatas.size()];
        for (int i4 = 0; i4 < metadatas.length; ++i4) {
            metadatas[i4] = (Integer)listMetadatas.get(i4);
        }
        return metadatas;
    }

    public static Comparable parsePropertyValue(amo prop, String valStr) {
        Class valueClass = prop.b();
        Comparable valueObj = ConnectedParser.parseValue(valStr, valueClass);
        if (valueObj == null) {
            Collection propertyValues = prop.c();
            valueObj = ConnectedParser.getPropertyValue(valStr, propertyValues);
        }
        return valueObj;
    }

    public static Comparable getPropertyValue(String value, Collection propertyValues) {
        for (Comparable obj : propertyValues) {
            if (!String.valueOf(obj).equals(value)) continue;
            return obj;
        }
        return null;
    }

    public static Comparable parseValue(String str, Class cls) {
        if (cls == String.class) {
            return str;
        }
        if (cls == Boolean.class) {
            return Boolean.valueOf(str);
        }
        if (cls == Float.class) {
            return Float.valueOf(str);
        }
        if (cls == Double.class) {
            return Double.valueOf(str);
        }
        if (cls == Integer.class) {
            return Integer.valueOf(str);
        }
        if (cls == Long.class) {
            return Long.valueOf(str);
        }
        return null;
    }

    public boolean matchState(alz bs, Map mapPropValues) {
        Set entries = mapPropValues.entrySet();
        for (Map.Entry entry : entries) {
            amo prop = (amo)entry.getKey();
            List vals = (List)entry.getValue();
            Comparable bsVal = bs.b(prop);
            if (bsVal == null) {
                return false;
            }
            if (vals.contains(bsVal)) continue;
            return false;
        }
        return true;
    }

    public ady[] parseBiomes(String str) {
        if (str == null) {
            return null;
        }
        String[] biomeNames = Config.tokenize(str, " ");
        ArrayList<ady> list = new ArrayList<ady>();
        for (int i2 = 0; i2 < biomeNames.length; ++i2) {
            String biomeName = biomeNames[i2];
            ady biome = this.findBiome(biomeName);
            if (biome == null) {
                this.warn("Biome not found: " + biomeName);
                continue;
            }
            list.add(biome);
        }
        ady[] biomeArr = list.toArray(new ady[list.size()]);
        return biomeArr;
    }

    public ady findBiome(String biomeName) {
        biomeName = biomeName.toLowerCase();
        ady[] biomeList = ady.n();
        for (int i2 = 0; i2 < biomeList.length; ++i2) {
            String name;
            ady biome = biomeList[i2];
            if (biome == null || !(name = biome.ah.replace(" ", "").toLowerCase()).equals(biomeName)) continue;
            return biome;
        }
        return null;
    }

    public int parseInt(String str) {
        if (str == null) {
            return -1;
        }
        int num = Config.parseInt(str, -1);
        if (num < 0) {
            this.warn("Invalid number: " + str);
        }
        return num;
    }

    public int parseInt(String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        int num = Config.parseInt(str, -1);
        if (num < 0) {
            this.warn("Invalid number: " + str);
            return defVal;
        }
        return num;
    }

    public int[] parseIntList(String str) {
        if (str == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        String[] intStrs = Config.tokenize(str, " ,");
        for (int i2 = 0; i2 < intStrs.length; ++i2) {
            String intStr = intStrs[i2];
            if (intStr.contains("-")) {
                String[] subStrs = Config.tokenize(intStr, "-");
                if (subStrs.length != 2) {
                    this.warn("Invalid interval: " + intStr + ", when parsing: " + str);
                    continue;
                }
                int min = Config.parseInt(subStrs[0], -1);
                int max = Config.parseInt(subStrs[1], -1);
                if (min < 0 || max < 0 || min > max) {
                    this.warn("Invalid interval: " + intStr + ", when parsing: " + str);
                    continue;
                }
                for (int n2 = min; n2 <= max; ++n2) {
                    list.add(n2);
                }
                continue;
            }
            int val = Config.parseInt(intStr, -1);
            if (val < 0) {
                this.warn("Invalid number: " + intStr + ", when parsing: " + str);
                continue;
            }
            list.add(val);
        }
        int[] ints = new int[list.size()];
        for (int i3 = 0; i3 < ints.length; ++i3) {
            ints[i3] = (Integer)list.get(i3);
        }
        return ints;
    }

    public boolean[] parseFaces(String str, boolean[] defVal) {
        if (str == null) {
            return defVal;
        }
        EnumSet<cq> setFaces = EnumSet.allOf(cq.class);
        String[] faceStrs = Config.tokenize(str, " ,");
        for (int i2 = 0; i2 < faceStrs.length; ++i2) {
            String faceStr = faceStrs[i2];
            if (faceStr.equals("sides")) {
                setFaces.add(cq.c);
                setFaces.add(cq.d);
                setFaces.add(cq.e);
                setFaces.add(cq.f);
                continue;
            }
            if (faceStr.equals("all")) {
                setFaces.addAll(Arrays.asList(cq.n));
                continue;
            }
            cq face = this.parseFace(faceStr);
            if (face == null) continue;
            setFaces.add(face);
        }
        boolean[] faces = new boolean[cq.n.length];
        for (int i3 = 0; i3 < faces.length; ++i3) {
            faces[i3] = setFaces.contains((Object)cq.n[i3]);
        }
        return faces;
    }

    public cq parseFace(String str) {
        if ((str = str.toLowerCase()).equals("bottom") || str.equals("down")) {
            return cq.a;
        }
        if (str.equals("top") || str.equals("up")) {
            return cq.b;
        }
        if (str.equals("north")) {
            return cq.c;
        }
        if (str.equals("south")) {
            return cq.d;
        }
        if (str.equals("east")) {
            return cq.f;
        }
        if (str.equals("west")) {
            return cq.e;
        }
        Config.warn("Unknown face: " + str);
        return null;
    }

    public void dbg(String str) {
        Config.dbg("" + this.context + ": " + str);
    }

    public void warn(String str) {
        Config.warn("" + this.context + ": " + str);
    }

    public RangeListInt parseRangeListInt(String str) {
        if (str == null) {
            return null;
        }
        RangeListInt list = new RangeListInt();
        String[] parts = Config.tokenize(str, " ,");
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String part = parts[i2];
            RangeInt ri = this.parseRangeInt(part);
            if (ri == null) {
                return null;
            }
            list.addRange(ri);
        }
        return list;
    }

    private RangeInt parseRangeInt(String str) {
        if (str == null) {
            return null;
        }
        if (str.indexOf(45) >= 0) {
            String[] parts = Config.tokenize(str, "-");
            if (parts.length != 2) {
                this.warn("Invalid range: " + str);
                return null;
            }
            int min = Config.parseInt(parts[0], -1);
            int max = Config.parseInt(parts[1], -1);
            if (min < 0 || max < 0) {
                this.warn("Invalid range: " + str);
                return null;
            }
            return new RangeInt(min, max);
        }
        int val = Config.parseInt(str, -1);
        if (val < 0) {
            this.warn("Invalid integer: " + str);
            return null;
        }
        return new RangeInt(val, val);
    }
}

