/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ConnectedUtils {
    public static String[] collectFiles(bnk rp, String prefix, String suffix, String[] defaultPaths) {
        if (rp instanceof bna) {
            return ConnectedUtils.collectFilesFixed(rp, defaultPaths);
        }
        if (!(rp instanceof bmx)) {
            return new String[0];
        }
        bmx arp = (bmx)rp;
        File tpFile = ResourceUtils.getResourcePackFile(arp);
        if (tpFile == null) {
            return new String[0];
        }
        if (tpFile.isDirectory()) {
            return ConnectedUtils.collectFilesFolder(tpFile, "", prefix, suffix);
        }
        if (tpFile.isFile()) {
            return ConnectedUtils.collectFilesZIP(tpFile, prefix, suffix);
        }
        return new String[0];
    }

    private static String[] collectFilesFixed(bnk rp, String[] paths) {
        if (paths == null) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i2 = 0; i2 < paths.length; ++i2) {
            String path = paths[i2];
            jy loc = new jy(path);
            if (!rp.b(loc)) continue;
            list.add(path);
        }
        String[] pathArr = list.toArray(new String[list.size()]);
        return pathArr;
    }

    private static String[] collectFilesFolder(File tpFile, String basePath, String prefix, String suffix) {
        ArrayList<String> list = new ArrayList<String>();
        String prefixAssets = "assets/minecraft/";
        File[] files = tpFile.listFiles();
        if (files == null) {
            return new String[0];
        }
        for (int i2 = 0; i2 < files.length; ++i2) {
            File file = files[i2];
            if (file.isFile()) {
                String name = basePath + file.getName();
                if (!name.startsWith(prefixAssets) || !(name = name.substring(prefixAssets.length())).startsWith(prefix) || !name.endsWith(suffix)) continue;
                list.add(name);
                continue;
            }
            if (!file.isDirectory()) continue;
            String dirPath = basePath + file.getName() + "/";
            String[] names = ConnectedUtils.collectFilesFolder(file, dirPath, prefix, suffix);
            for (int n2 = 0; n2 < names.length; ++n2) {
                String name = names[n2];
                list.add(name);
            }
        }
        String[] names = list.toArray(new String[list.size()]);
        return names;
    }

    private static String[] collectFilesZIP(File tpFile, String prefix, String suffix) {
        ArrayList<String> list = new ArrayList<String>();
        String prefixAssets = "assets/minecraft/";
        try {
            ZipFile zf = new ZipFile(tpFile);
            Enumeration<? extends ZipEntry> en = zf.entries();
            while (en.hasMoreElements()) {
                ZipEntry ze2 = en.nextElement();
                String name = ze2.getName();
                if (!name.startsWith(prefixAssets) || !(name = name.substring(prefixAssets.length())).startsWith(prefix) || !name.endsWith(suffix)) continue;
                list.add(name);
            }
            zf.close();
            String[] names = list.toArray(new String[list.size()]);
            return names;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return new String[0];
        }
    }

    public static int getAverage(int[] vals) {
        if (vals.length <= 0) {
            return 0;
        }
        int sum = 0;
        for (int i2 = 0; i2 < vals.length; ++i2) {
            int val = vals[i2];
            sum += val;
        }
        int avg = sum / vals.length;
        return avg;
    }
}

