/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.Method;

public class ReflectorMethod {
    private ReflectorClass reflectorClass = null;
    private String targetMethodName = null;
    private Class[] targetMethodParameterTypes = null;
    private boolean checked = false;
    private Method targetMethod = null;

    public ReflectorMethod(ReflectorClass reflectorClass, String targetMethodName) {
        this(reflectorClass, targetMethodName, null);
    }

    public ReflectorMethod(ReflectorClass reflectorClass, String targetMethodName, Class[] targetMethodParameterTypes) {
        this.reflectorClass = reflectorClass;
        this.targetMethodName = targetMethodName;
        this.targetMethodParameterTypes = targetMethodParameterTypes;
        Method m2 = this.getTargetMethod();
    }

    public Method getTargetMethod() {
        if (this.checked) {
            return this.targetMethod;
        }
        this.checked = true;
        Class cls = this.reflectorClass.getTargetClass();
        if (cls == null) {
            return null;
        }
        Method[] ms = cls.getDeclaredMethods();
        for (int i2 = 0; i2 < ms.length; ++i2) {
            Class[] types;
            Method m2 = ms[i2];
            if (!m2.getName().equals(this.targetMethodName) || this.targetMethodParameterTypes != null && !Reflector.matchesTypes(this.targetMethodParameterTypes, types = m2.getParameterTypes())) continue;
            this.targetMethod = m2;
            if (!this.targetMethod.isAccessible()) {
                this.targetMethod.setAccessible(true);
            }
            return this.targetMethod;
        }
        Config.log("(Reflector) Method not present: " + cls.getName() + "." + this.targetMethodName);
        return null;
    }

    public boolean exists() {
        if (this.checked) {
            return this.targetMethod != null;
        }
        return this.getTargetMethod() != null;
    }

    public Class getReturnType() {
        Method tm2 = this.getTargetMethod();
        if (tm2 == null) {
            return null;
        }
        return tm2.getReturnType();
    }

    public void deactivate() {
        this.checked = true;
        this.targetMethod = null;
    }
}

