/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting;

import chylex.bettersprinting.BetterSprintingMod;
import java.io.File;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BetterSprintingConfig {
    private final Configuration config;
    private String currentCategory = "unknown";

    BetterSprintingConfig(File file) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.config = new Configuration(file);
        this.reload();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (e.modID.equals("BetterSprinting")) {
            this.reload();
        }
    }

    private void reload() {
        BetterSprintingMod.proxy.loadSidedConfig(this);
    }

    public void update() {
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public String getFileName() {
        return this.config.toString();
    }

    @SideOnly(value=Side.CLIENT)
    public List<IConfigElement> getClientGuiElements(String category) {
        return new ConfigElement(this.config.getCategory(category)).getChildElements();
    }

    public void setCategory(String newCategory) {
        this.currentCategory = newCategory;
    }

    public void setComment(String name, String comment) {
        this.config.getCategory((String)this.currentCategory).get((String)name).comment = comment;
    }

    public Property getBool(String name, boolean defValue) {
        return this.config.get(this.currentCategory, name, defValue, "");
    }

    public Property getInt(String name, int defValue) {
        return this.config.get(this.currentCategory, name, defValue, "");
    }

    public void setBool(String name, boolean value) {
        this.config.get(this.currentCategory, name, value).set(value);
    }

    public void setInt(String name, int value) {
        this.config.get(this.currentCategory, name, value).set(value);
    }
}

