/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.client;

import chylex.bettersprinting.client.ClientModManager;
import chylex.bettersprinting.client.ClientNetwork;
import chylex.bettersprinting.client.ClientSettings;
import chylex.bettersprinting.client.compatibility.OldNotificationPacket;
import chylex.bettersprinting.client.gui.GuiControlsCustom;
import chylex.bettersprinting.client.update.UpdateNotificationManager;
import chylex.bettersprinting.system.PacketPipeline;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiControls;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class ClientEventHandler {
    private boolean stopChecking;

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
    }

    @SubscribeEvent
    public void onPlayerLoginClient(PlayerEvent.PlayerLoggedInEvent e) {
        UpdateNotificationManager.run();
    }

    @SubscribeEvent
    public void onPlayerJoinWorld(EntityJoinWorldEvent e) {
        if (this.stopChecking || e.entity != Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        this.stopChecking = true;
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.func_71387_A() && mc.func_147104_D() != null && !ClientSettings.disableMod) {
            PacketPipeline.sendToServer(ClientNetwork.writeModNotification(10));
            OldNotificationPacket.sendServerNotification(mc.field_71439_g.field_71174_a);
        }
    }

    @SubscribeEvent
    public void onClientDisconnectedFromServer(FMLNetworkEvent.ClientDisconnectionFromServerEvent e) {
        ClientModManager.svDisableMod = false;
        ClientModManager.svRunInAllDirs = false;
        ClientModManager.svSurvivalFlyingBoost = false;
        this.stopChecking = false;
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent e) {
        if (e.gui != null && e.gui.getClass() == GuiControls.class) {
            e.gui = new GuiControlsCustom((GuiControls)e.gui);
        }
    }

    private ClientEventHandler() {
    }
}

