/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.server;

import chylex.bettersprinting.BetterSprintingMod;
import chylex.bettersprinting.server.ServerNetwork;
import chylex.bettersprinting.server.ServerSettings;
import chylex.bettersprinting.system.PacketPipeline;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;

public class ServerCommandConfig
extends CommandBase {
    public String func_71517_b() {
        return "bettersprinting";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/bettersprinting [...]";
    }

    public int func_82362_a() {
        return 3;
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            this.sendMessage(sender, EnumChatFormatting.GREEN + "[Better Sprinting]");
            this.sendMessage(sender, "/bettersprinting info");
            this.sendMessage(sender, "/bettersprinting disablemod <true|false>");
            this.sendMessage(sender, "/bettersprinting setting <survivalFlyBoost|runInAllDirs> <true|false>");
        } else if (args[0].equalsIgnoreCase("info")) {
            this.sendMessageTranslated(sender, "bs.command.info");
        } else if (args[0].equalsIgnoreCase("disablemod")) {
            if (this.isValidBool(args, 1)) {
                ServerSettings.disableClientMod = this.getBool(args, 1);
                ServerSettings.update(BetterSprintingMod.config);
                this.sendMessageTranslated(sender, ServerSettings.disableClientMod ? "bs.command.disableMod" : "bs.command.enableMod");
                PacketPipeline.sendToAll(ServerNetwork.writeDisableMod(ServerSettings.disableClientMod));
            } else {
                this.sendMessageTranslated(sender, "bs.command.invalidSyntax");
            }
        } else if (args[0].equalsIgnoreCase("setting")) {
            if (args.length <= 1 || !this.isValidBool(args, 2)) {
                this.sendMessageTranslated(sender, "bs.command.invalidSyntax");
            } else if (args[1].equalsIgnoreCase("survivalFlyBoost")) {
                ServerSettings.enableSurvivalFlyBoost = this.getBool(args, 2);
                ServerSettings.update(BetterSprintingMod.config);
                this.sendMessageTranslated(sender, ServerSettings.enableSurvivalFlyBoost ? "bs.command.enableFlyBoost" : "bs.command.disableFlyBoost");
                PacketPipeline.sendToAll(ServerNetwork.writeSettings(ServerSettings.enableSurvivalFlyBoost, ServerSettings.enableAllDirs));
            } else if (args[1].equalsIgnoreCase("runInAllDirs")) {
                ServerSettings.enableAllDirs = this.getBool(args, 2);
                ServerSettings.update(BetterSprintingMod.config);
                this.sendMessageTranslated(sender, ServerSettings.enableAllDirs ? "bs.command.enableAllDirs" : "bs.command.disableAllDirs");
                PacketPipeline.sendToAll(ServerNetwork.writeSettings(ServerSettings.enableSurvivalFlyBoost, ServerSettings.enableAllDirs));
            }
        } else {
            this.sendMessageTranslated(sender, "bs.command.invalidSyntax");
        }
    }

    private void sendMessage(ICommandSender sender, String text) {
        sender.func_145747_a((IChatComponent)new ChatComponentText(text));
    }

    private void sendMessageTranslated(ICommandSender sender, String translationName) {
        if (sender instanceof EntityPlayer && !ServerNetwork.hasBetterSprinting((EntityPlayer)sender)) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)translationName)));
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation(translationName, new Object[0]));
        }
    }

    private boolean isValidBool(String[] args, int index) {
        if (index >= args.length) {
            return false;
        }
        return args[index].equalsIgnoreCase("true") || args[index].equalsIgnoreCase("false");
    }

    private boolean getBool(String[] args, int index) {
        return args[index].equalsIgnoreCase("true");
    }
}

