package atomicstryker.ruins.common;

import java.util.ArrayList;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldSavedData;

public class ChunkLoggerData extends WorldSavedData
{
    private final ArrayList<Integer> xCoords;
    private final ArrayList<Integer> zCoords;

    public ChunkLoggerData(String name)
    {
        super(name);
        xCoords = new ArrayList<Integer>();
        zCoords = new ArrayList<Integer>();
    }

    @Override
    public void func_76184_a(NBTTagCompound nbt)
    {
        int[] xload = nbt.func_74759_k("xcoords");
        System.out.println("Ruins chunks logged: "+xload.length);
        if (xload.length > 0)
        {
            xCoords.clear();
            for (int i : xload)
            {
                xCoords.add(i);
            }
        }
        int[] zload = nbt.func_74759_k("zcoords");
        if (zload.length > 0)
        {
            zCoords.clear();
            for (int i : zload)
            {
                zCoords.add(i);
            }
        }
    }

    @Override
    public void func_76187_b(NBTTagCompound nbt)
    {
        int[] xsave = new int[xCoords.size()];
        int[] zsave = new int[zCoords.size()];
        for (int i = 0; i < xsave.length; i++)
        {
            xsave[i] = xCoords.get(i);
            zsave[i] = zCoords.get(i);
        }
        nbt.func_74783_a("xcoords", xsave);
        nbt.func_74783_a("zcoords", zsave);
    }
    
    public boolean catchChunkBug(int chunkX, int chunkZ)
    {
        for (int i = 0; i < xCoords.size(); i++)
        {
            if (chunkX == xCoords.get(i) && chunkZ == zCoords.get(i))
            {
                return true;
            }
        }
        
        xCoords.add(chunkX);
        zCoords.add(chunkZ);
        func_76186_a(true);
        
        return false;
    }

}