package atomicstryker.ruins.common;

import java.io.File;
import java.io.PrintWriter;

import net.minecraft.block.Block;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraftforge.common.MinecraftForge;

public class CommandTestTemplate extends CommandBase
{

    public static RuinTemplate parsedRuin;

    @Override
    public String func_71517_b()
    {
        return "testruin";
    }

    @Override
    public String func_71518_a(ICommandSender var1)
    {
        return "/testruin TEMPLATENAME [X Y Z ROTATION] manually spawns the target Ruin of the templateparser folder, [] optional";
    }

    @Override
    public int func_82362_a()
    {
        return 2;
    }

    @Override
    public void func_71515_b(ICommandSender sender, String[] args)
    {
        EntityPlayer player = sender.func_130014_f_().func_72924_a(sender.func_70005_c_());
        int xpos, ypos, zpos;
        xpos = sender.func_180425_c().func_177958_n();
        ypos = sender.func_180425_c().func_177956_o();
        zpos = sender.func_180425_c().func_177952_p();
        if (player != null && args.length < 4)
        {
            if (args.length < 1)
            {
                if (parsedRuin != null)
                {
                    parsedRuin.doBuild(sender.func_130014_f_(), sender.func_130014_f_().field_73012_v, xpos, ypos-1, zpos, RuinsMod.DIR_NORTH);
                    parsedRuin = null;
                }
                else
                {
                    player.func_145747_a(new ChatComponentText(
                            "You need to use the command with the target template name, eg. /parseruin beach/LightHouse"));
                }
            }
            else
            {
                tryBuild(sender, args, xpos, ypos-1, zpos);
            }
        }
        else if (args.length >= 4)
        {
        	try
        	{
                if (args[2].equals("_"))
                {
                    tryBuild(sender, args, (int)func_175769_b(xpos, args[1], -30000000, 30000000, false), -1, 
                    		(int)func_175769_b(zpos, args[3], -30000000, 30000000, false));
                }
                else
                {
                    tryBuild(sender, args, (int)func_175769_b(xpos, args[1], -30000000, 30000000, false), 
                    		(int)func_175769_b(ypos, args[2], -30000000, 30000000, false)-1, 
                    		(int)func_175769_b(zpos, args[3], -30000000, 30000000, false));
                }
        	}
        	catch (NumberInvalidException e)
        	{
        		sender.func_145747_a(new ChatComponentText("Invalid coordinates specified"));
			}
        }
        else
        {
            sender.func_145747_a(new ChatComponentText("Command is only available for ingame player entities, or with coordinates specified"));
        }
    }
    
    private void tryBuild(ICommandSender sender, String[] args, int x, int y, int z)
    {
        String target = args[0];
        if (!target.contains("/"))
        {
            target = "templateparser/" + target;
        }

        File file = new File(RuinsMod.getMinecraftBaseDir(), "mods/resources/ruins/" + target + ".tml");
        if (file.exists() && file.canWrite())
        {
            try
            {
                parsedRuin = new RuinTemplate(new PrintWriter(System.out, true), file.getCanonicalPath(), file.getName(), true);
                int rotation = (args.length > 4) ? Integer.parseInt(args[4]) : RuinsMod.DIR_NORTH;
                
                if (parsedRuin != null)
                {
                    if (y < 0)
                    {
                        for (y = RuinGenerator.WORLD_MAX_HEIGHT - 1; y > 7; y--)
                        {
                            final Block b = sender.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_177230_c();
                            if (parsedRuin.isIgnoredBlock(b, sender.func_130014_f_(), x, y, z))
                            {
                                continue;
                            }
                            
                            if (parsedRuin.isAcceptableSurface(b))
                            {
                                break;
                            }
                            sender.func_145747_a(new ChatComponentText("Could not find acceptable Y coordinate"));
                            return;
                        }
                    }
                    
                    if (MinecraftForge.EVENT_BUS.post(new EventRuinTemplateSpawn(sender.func_130014_f_(), parsedRuin, x, y, z, rotation, true, true)))
                    {
                        sender.func_145747_a(new ChatComponentText("EventRuinTemplateSpawn returned as cancelled, not building that."));
                    }
                    else
                    {
                        int resultY = parsedRuin.doBuild(sender.func_130014_f_(), sender.func_130014_f_().field_73012_v, x, y, z, rotation);
                        if (resultY > 0)
                        {
                            MinecraftForge.EVENT_BUS.post(new EventRuinTemplateSpawn(sender.func_130014_f_(), parsedRuin, x, resultY, z, rotation, true, false));
                        }
                        parsedRuin = null;
                    }
                }
                else
                {
                    sender.func_145747_a(new ChatComponentText("Could not parse Ruin of file " + file));
                }
            }
            catch (Exception e)
            {
                e.printStackTrace();
            }
        }
        else
        {
            sender.func_145747_a(new ChatComponentText("Could not open/write file " + file));
        }
    }

}
