package atomicstryker.ruins.common;

import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent.BreakEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CommandParseTemplate extends CommandBase
{

    private EntityPlayer player;
    private String templateName;

    public CommandParseTemplate()
    {
        MinecraftForge.EVENT_BUS.register(this);
    }

    @SubscribeEvent
    public void onBlockBroken(BreakEvent event)
    {
        if (event.getPlayer() == player)
        {
            new World2TemplateParser(player, event.pos.func_177958_n(), event.pos.func_177956_o(), event.pos.func_177952_p(), templateName).start();
            player = null;
            event.setCanceled(true);
        }
    }

    @Override
    public String func_71517_b()
    {
        return "parseruin";
    }

    @Override
    public String func_71518_a(ICommandSender var1)
    {
        return "/parseruin TEMPLATENAME sets the Ruins World2Template parser to wait for the next block you break, which will be considered part of the template baseplate";
    }
    
    @Override
    public int func_82362_a()
    {
        return 2;
    }

    @Override
    public void func_71515_b(ICommandSender sender, String[] args)
    {
        player = sender.func_130014_f_().func_72924_a(sender.func_70005_c_());
        if (player != null)
        {
            if (args.length != 1)
            {
                player.func_145747_a(new ChatComponentText("You need to use the command with the target template name, eg. /parseruin funhouse"));
                player = null;
            }
            else
            {
                templateName = args[0];
                player.func_145747_a(new ChatComponentText("Template parser ready to create " + templateName
                        + ". Break any block of the baseplate now."));
            }
        }
        else
        {
            sender.func_145747_a(new ChatComponentText("Command only available for ingame player entities."));
        }
    }

}
