/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.oredict.OreDictionary;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomTeleporter;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.QuestLogData;
import noppes.npcs.Server;
import noppes.npcs.api.constants.EnumOptionType;
import noppes.npcs.api.event.RoleEvent;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.containers.ContainerNPCBankInterface;
import noppes.npcs.containers.ContainerNPCFollower;
import noppes.npcs.containers.ContainerNPCFollowerHire;
import noppes.npcs.controllers.Bank;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.BankData;
import noppes.npcs.controllers.Dialog;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.DialogOption;
import noppes.npcs.controllers.Line;
import noppes.npcs.controllers.PlayerBankData;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.PlayerQuestData;
import noppes.npcs.controllers.PlayerTransportData;
import noppes.npcs.controllers.QuestData;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.TransportLocation;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleDialog;
import noppes.npcs.roles.RoleFollower;

public class NoppesUtilPlayer {
    public static void changeFollowerState(EntityPlayerMP player, EntityNPCInterface npc) {
        if (npc.advanced.role != 2) {
            return;
        }
        RoleFollower role = (RoleFollower)npc.roleInterface;
        EntityPlayer owner = role.owner;
        if (owner == null || !owner.func_70005_c_().equals(player.func_70005_c_())) {
            return;
        }
        role.isFollowing = !role.isFollowing;
    }

    public static void hireFollower(EntityPlayerMP player, EntityNPCInterface npc) {
        if (npc.advanced.role != 2) {
            return;
        }
        Container con = player.field_71070_bA;
        if (con == null || !(con instanceof ContainerNPCFollowerHire)) {
            return;
        }
        ContainerNPCFollowerHire container = (ContainerNPCFollowerHire)con;
        RoleFollower role = (RoleFollower)npc.roleInterface;
        NoppesUtilPlayer.followerBuy(role, (IInventory)container.currencyMatrix, player, npc);
    }

    public static void extendFollower(EntityPlayerMP player, EntityNPCInterface npc) {
        if (npc.advanced.role != 2) {
            return;
        }
        Container con = player.field_71070_bA;
        if (con == null || !(con instanceof ContainerNPCFollower)) {
            return;
        }
        ContainerNPCFollower container = (ContainerNPCFollower)con;
        RoleFollower role = (RoleFollower)npc.roleInterface;
        NoppesUtilPlayer.followerBuy(role, container.currencyMatrix, player, npc);
    }

    public static void transport(EntityPlayerMP player, EntityNPCInterface npc, String location) {
        TransportLocation loc = TransportController.getInstance().getTransport(location);
        PlayerTransportData playerdata = PlayerDataController.instance.getPlayerData((EntityPlayer)player).transportData;
        if (loc == null || !loc.isDefault() && !playerdata.transports.contains(loc.id)) {
            return;
        }
        RoleEvent.TransporterUseEvent event = new RoleEvent.TransporterUseEvent((EntityPlayer)player, npc.wrappedNPC);
        if (EventHooks.onNPCRole(npc, event)) {
            return;
        }
        NoppesUtilPlayer.teleportPlayer(player, loc.pos, loc.dimension);
    }

    public static void teleportPlayer(EntityPlayerMP player, BlockPos pos, int dimension) {
        if (player.field_71093_bK != dimension) {
            int dim = player.field_71093_bK;
            MinecraftServer server = MinecraftServer.func_71276_C();
            WorldServer wor = server.func_71218_a(dimension);
            if (wor == null) {
                player.func_145747_a((IChatComponent)new ChatComponentText("Broken transporter. Dimenion does not exist"));
                return;
            }
            player.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), player.field_70177_z, player.field_70125_A);
            server.func_71203_ab().transferPlayerToDimension(player, dimension, (Teleporter)new CustomTeleporter(wor));
            player.field_71135_a.func_147364_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), player.field_70177_z, player.field_70125_A);
            if (!wor.field_73010_i.contains(player)) {
                wor.func_72838_d((Entity)player);
            }
        } else {
            player.field_71135_a.func_147364_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), player.field_70177_z, player.field_70125_A);
        }
        player.field_70170_p.func_72866_a((Entity)player, false);
    }

    private static void followerBuy(RoleFollower role, IInventory currencyInv, EntityPlayerMP player, EntityNPCInterface npc) {
        ItemStack currency = currencyInv.func_70301_a(0);
        if (currency == null) {
            return;
        }
        HashMap<ItemStack, Integer> cd = new HashMap<ItemStack, Integer>();
        for (int i : role.inventory.items.keySet()) {
            ItemStack is = role.inventory.items.get(i);
            if (is == null || is.func_77973_b() != currency.func_77973_b() || is.func_77981_g() && is.func_77952_i() != currency.func_77952_i()) continue;
            int days = 1;
            if (role.rates.containsKey(i)) {
                days = role.rates.get(i);
            }
            cd.put(is, days);
        }
        if (cd.size() == 0) {
            return;
        }
        int stackSize = currency.field_77994_a;
        int days = 0;
        int possibleDays = 0;
        int possibleSize = stackSize;
        while (true) {
            for (ItemStack item : cd.keySet()) {
                int newStackSize;
                int size;
                int posDays;
                int rDays = (Integer)cd.get(item);
                int rValue = item.field_77994_a;
                if (rValue > stackSize || possibleDays > (posDays = (size = stackSize - (newStackSize = stackSize % rValue)) / rValue * rDays)) continue;
                possibleDays = posDays;
                possibleSize = newStackSize;
            }
            if (stackSize == possibleSize) break;
            stackSize = possibleSize;
            days += possibleDays;
            possibleDays = 0;
        }
        RoleEvent.FollowerHireEvent event = new RoleEvent.FollowerHireEvent((EntityPlayer)player, npc.wrappedNPC, days);
        if (EventHooks.onNPCRole(npc, event)) {
            return;
        }
        if (event.days == 0) {
            return;
        }
        if (stackSize <= 0) {
            currencyInv.func_70299_a(0, null);
        } else {
            currency = currency.func_77979_a(stackSize);
        }
        npc.say((EntityPlayer)player, new Line(NoppesStringUtils.formatText(role.dialogHire.replace("{days}", days + ""), new Object[]{player, npc})));
        role.setOwner((EntityPlayer)player);
        role.addDays(days);
    }

    public static void bankUpgrade(EntityPlayerMP player, EntityNPCInterface npc) {
        if (npc.advanced.role != 3) {
            return;
        }
        Container con = player.field_71070_bA;
        if (con == null || !(con instanceof ContainerNPCBankInterface)) {
            return;
        }
        ContainerNPCBankInterface container = (ContainerNPCBankInterface)con;
        Bank bank = BankController.getInstance().getBank(container.bankid);
        ItemStack item = bank.upgradeInventory.func_70301_a(container.slot);
        if (item == null) {
            return;
        }
        int price = item.field_77994_a;
        ItemStack currency = container.currencyMatrix.func_70301_a(0);
        if (currency == null || price > currency.field_77994_a) {
            return;
        }
        if (currency.field_77994_a - price == 0) {
            container.currencyMatrix.func_70299_a(0, null);
        } else {
            currency = currency.func_77979_a(price);
        }
        player.func_71128_l();
        PlayerBankData data = PlayerDataController.instance.getBankData((EntityPlayer)player, bank.id);
        BankData bankData = data.getBank(bank.id);
        bankData.upgradedSlots.put(container.slot, true);
        RoleEvent.BankUpgradedEvent event = new RoleEvent.BankUpgradedEvent((EntityPlayer)player, npc.wrappedNPC, container.slot);
        EventHooks.onNPCRole(npc, event);
        bankData.openBankGui((EntityPlayer)player, npc, bank.id, container.slot);
    }

    public static void bankUnlock(EntityPlayerMP player, EntityNPCInterface npc) {
        if (npc.advanced.role != 3) {
            return;
        }
        Container con = player.field_71070_bA;
        if (con == null || !(con instanceof ContainerNPCBankInterface)) {
            return;
        }
        ContainerNPCBankInterface container = (ContainerNPCBankInterface)con;
        Bank bank = BankController.getInstance().getBank(container.bankid);
        ItemStack item = bank.currencyInventory.func_70301_a(container.slot);
        if (item == null) {
            return;
        }
        int price = item.field_77994_a;
        ItemStack currency = container.currencyMatrix.func_70301_a(0);
        if (currency == null || price > currency.field_77994_a) {
            return;
        }
        if (currency.field_77994_a - price == 0) {
            container.currencyMatrix.func_70299_a(0, null);
        } else {
            currency = currency.func_77979_a(price);
        }
        player.func_71128_l();
        PlayerBankData data = PlayerDataController.instance.getBankData((EntityPlayer)player, bank.id);
        BankData bankData = data.getBank(bank.id);
        if (bankData.unlockedSlots + 1 <= bank.maxSlots) {
            ++bankData.unlockedSlots;
        }
        RoleEvent.BankUnlockedEvent event = new RoleEvent.BankUnlockedEvent((EntityPlayer)player, npc.wrappedNPC, container.slot);
        EventHooks.onNPCRole(npc, event);
        bankData.openBankGui((EntityPlayer)player, npc, bank.id, container.slot);
    }

    public static void sendData(EnumPlayerPacket enu, Object ... obs) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        try {
            if (!Server.fillBuffer((ByteBuf)buffer, enu, obs)) {
                return;
            }
            CustomNpcs.ChannelPlayer.sendToServer(new FMLProxyPacket(buffer, "CustomNPCsPlayer"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void dialogSelected(int dialogId, int optionId, EntityPlayerMP player, EntityNPCInterface npc) {
        if (dialogId < 0 && npc.advanced.role == 7) {
            String text = ((RoleDialog)npc.roleInterface).optionsTexts.get(optionId);
            if (text != null && !text.isEmpty()) {
                Dialog d = new Dialog();
                d.text = text;
                NoppesUtilServer.openDialog((EntityPlayer)player, npc, d);
            }
            return;
        }
        Dialog dialog = DialogController.instance.dialogs.get(dialogId);
        if (dialog == null) {
            return;
        }
        if (!dialog.hasDialogs((EntityPlayer)player) && !dialog.hasOtherOptions()) {
            return;
        }
        DialogOption option = dialog.options.get(optionId);
        if (option == null) {
            return;
        }
        if (EventHooks.onNPCDialogOption(npc, player, dialog, option)) {
            Server.sendData(player, EnumPacketClient.GUI_CLOSE, new Object[0]);
            return;
        }
        if (option.optionType == EnumOptionType.DIALOG_OPTION && (!option.isAvailable((EntityPlayer)player) || !option.hasDialog()) || option.optionType == EnumOptionType.DISABLED || option.optionType == EnumOptionType.QUIT_OPTION) {
            return;
        }
        if (option.optionType == EnumOptionType.ROLE_OPTION) {
            if (npc.roleInterface != null) {
                npc.roleInterface.interact((EntityPlayer)player);
            } else {
                Server.sendData(player, EnumPacketClient.GUI_CLOSE, new Object[0]);
            }
        } else if (option.optionType == EnumOptionType.DIALOG_OPTION) {
            NoppesUtilServer.openDialog((EntityPlayer)player, npc, option.getDialog());
        } else if (option.optionType == EnumOptionType.COMMAND_BLOCK) {
            Server.sendData(player, EnumPacketClient.GUI_CLOSE, new Object[0]);
            NoppesUtilServer.runCommand(npc, npc.func_70005_c_(), option.command, (EntityPlayer)player);
        } else {
            Server.sendData(player, EnumPacketClient.GUI_CLOSE, new Object[0]);
        }
    }

    public static void sendQuestLogData(EntityPlayerMP player) {
        if (!PlayerQuestController.hasActiveQuests((EntityPlayer)player)) {
            return;
        }
        QuestLogData data = new QuestLogData();
        data.setData((EntityPlayer)player);
        Server.sendData(player, EnumPacketClient.GUI_DATA, data.writeNBT());
    }

    public static void questCompletion(EntityPlayerMP player, int questId) {
        PlayerQuestData playerdata = PlayerDataController.instance.getPlayerData((EntityPlayer)player).questData;
        QuestData data = playerdata.activeQuests.get(questId);
        if (data == null) {
            return;
        }
        if (!data.quest.questInterface.isCompleted((EntityPlayer)player)) {
            return;
        }
        EventHooks.onQuestTurnedIn(player, data.quest);
        data.quest.questInterface.handleComplete((EntityPlayer)player);
        if (data.quest.rewardExp > 0) {
            player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.8f));
            player.func_71023_q(data.quest.rewardExp);
        }
        data.quest.factionOptions.addPoints((EntityPlayer)player);
        if (data.quest.mail.isValid()) {
            PlayerDataController.instance.addPlayerMessage(player.func_70005_c_(), data.quest.mail);
        }
        if (!data.quest.randomReward) {
            for (ItemStack item : data.quest.rewardItems.items.values()) {
                NoppesUtilServer.GivePlayerItem((Entity)player, (EntityPlayer)player, item);
            }
        } else {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (ItemStack item : data.quest.rewardItems.items.values()) {
                if (item == null || item.func_77973_b() == null) continue;
                list.add(item);
            }
            if (!list.isEmpty()) {
                NoppesUtilServer.GivePlayerItem((Entity)player, (EntityPlayer)player, (ItemStack)list.get(player.func_70681_au().nextInt(list.size())));
            }
        }
        if (!data.quest.command.isEmpty()) {
            NoppesUtilServer.runCommand((EntityPlayer)player, "QuestCompletion", data.quest.command);
        }
        PlayerQuestController.setQuestFinished(data.quest, (EntityPlayer)player);
        if (data.quest.hasNewQuest()) {
            PlayerQuestController.addActiveQuest(data.quest.getNextQuest(), (EntityPlayer)player);
        }
    }

    public static boolean compareItems(ItemStack item, ItemStack item2, boolean ignoreDamage, boolean ignoreNBT) {
        if (item2 == null || item == null) {
            return false;
        }
        boolean oreMatched = false;
        OreDictionary.itemMatches((ItemStack)item, (ItemStack)item2, (boolean)false);
        int[] ids = OreDictionary.getOreIDs((ItemStack)item);
        if (ids.length > 0) {
            for (int id : ids) {
                boolean match1 = false;
                boolean match2 = false;
                for (ItemStack is : OreDictionary.getOres((String)OreDictionary.getOreName((int)id))) {
                    if (NoppesUtilPlayer.compareItemDetails(item, is, ignoreDamage, ignoreNBT)) {
                        match1 = true;
                    }
                    if (!NoppesUtilPlayer.compareItemDetails(item2, is, ignoreDamage, ignoreNBT)) continue;
                    match2 = true;
                }
                if (!match1 || !match2) continue;
                return true;
            }
        }
        return NoppesUtilPlayer.compareItemDetails(item, item2, ignoreDamage, ignoreNBT);
    }

    private static boolean compareItemDetails(ItemStack item, ItemStack item2, boolean ignoreDamage, boolean ignoreNBT) {
        if (item.func_77973_b() != item2.func_77973_b()) {
            return false;
        }
        if (!ignoreDamage && item.func_77952_i() != -1 && item.func_77952_i() != item2.func_77952_i()) {
            return false;
        }
        if (!(ignoreNBT || item.func_77978_p() == null || item2.func_77978_p() != null && item.func_77978_p().equals((Object)item2.func_77978_p()))) {
            return false;
        }
        return ignoreNBT || item2.func_77978_p() == null || item.func_77978_p() != null;
    }

    public static boolean compareItems(EntityPlayer player, ItemStack item, boolean ignoreDamage, boolean ignoreNBT) {
        int size = 0;
        for (ItemStack is : player.field_71071_by.field_70462_a) {
            if (is == null || !NoppesUtilPlayer.compareItems(item, is, ignoreDamage, ignoreNBT)) continue;
            size += is.field_77994_a;
        }
        return size >= item.field_77994_a;
    }

    public static void consumeItem(EntityPlayer player, ItemStack item, boolean ignoreDamage, boolean ignoreNBT) {
        if (item == null) {
            return;
        }
        int size = item.field_77994_a;
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            ItemStack is = player.field_71071_by.field_70462_a[i];
            if (is == null || !NoppesUtilPlayer.compareItems(item, is, ignoreDamage, ignoreNBT)) continue;
            if (size >= is.field_77994_a) {
                size -= is.field_77994_a;
                player.field_71071_by.field_70462_a[i] = null;
                continue;
            }
            player.field_71071_by.field_70462_a[i].func_77979_a(size);
            break;
        }
    }
}

