/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.Vec3;
import noppes.npcs.ai.RandomPositionGeneratorAlt;
import noppes.npcs.constants.AiMutex;
import noppes.npcs.entity.EntityNPCInterface;

public class EntityAIAvoidTarget
extends EntityAIBase {
    private EntityNPCInterface npc;
    private Entity closestLivingEntity;
    private float distanceFromEntity;
    private float health;
    private PathEntity entityPathEntity;
    private PathNavigate entityPathNavigate;
    private Class targetEntityClass;

    public EntityAIAvoidTarget(EntityNPCInterface par1EntityNPC) {
        this.npc = par1EntityNPC;
        this.distanceFromEntity = this.npc.stats.aggroRange;
        this.health = this.npc.func_110143_aJ();
        this.entityPathNavigate = par1EntityNPC.func_70661_as();
        this.func_75248_a(AiMutex.PASSIVE + AiMutex.LOOK);
    }

    public boolean func_75250_a() {
        boolean var4;
        boolean var3;
        EntityLivingBase target = this.npc.func_70638_az();
        if (target == null) {
            return false;
        }
        this.targetEntityClass = target.getClass();
        if (this.targetEntityClass == EntityPlayer.class) {
            this.closestLivingEntity = this.npc.field_70170_p.func_72890_a((Entity)this.npc, (double)this.distanceFromEntity);
            if (this.closestLivingEntity == null) {
                return false;
            }
        } else {
            List var1 = this.npc.field_70170_p.func_72872_a(this.targetEntityClass, this.npc.func_174813_aQ().func_72314_b((double)this.distanceFromEntity, 3.0, (double)this.distanceFromEntity));
            if (var1.isEmpty()) {
                return false;
            }
            this.closestLivingEntity = (Entity)var1.get(0);
        }
        if (!this.npc.func_70635_at().func_75522_a(this.closestLivingEntity) && this.npc.ai.directLOS) {
            return false;
        }
        Vec3 var2 = RandomPositionGeneratorAlt.findRandomTargetBlockAwayFrom(this.npc, 16, 7, new Vec3(this.closestLivingEntity.field_70165_t, this.closestLivingEntity.field_70163_u, this.closestLivingEntity.field_70161_v));
        boolean bl = var3 = this.npc.inventory.getProjectile() == null;
        boolean bl2 = var3 ? this.health == this.npc.func_110143_aJ() : (var4 = this.npc.getRangedTask() != null && !this.npc.getRangedTask().hasFired());
        if (var2 == null) {
            return false;
        }
        if (this.closestLivingEntity.func_70092_e(var2.field_72450_a, var2.field_72448_b, var2.field_72449_c) < this.closestLivingEntity.func_70068_e((Entity)this.npc)) {
            return false;
        }
        if (this.npc.ai.tacticalVariant == 3 && var4) {
            return false;
        }
        this.entityPathEntity = this.entityPathNavigate.func_75488_a(var2.field_72450_a, var2.field_72448_b, var2.field_72449_c);
        return this.entityPathEntity == null ? false : this.entityPathEntity.func_75880_b(var2);
    }

    public boolean func_75253_b() {
        return !this.entityPathNavigate.func_75500_f();
    }

    public void func_75249_e() {
        this.entityPathNavigate.func_75484_a(this.entityPathEntity, 1.0);
    }

    public void func_75251_c() {
        this.closestLivingEntity = null;
        this.npc.func_70624_b(null);
    }

    public void func_75246_d() {
        if (this.npc.isInRange(this.closestLivingEntity, 7.0)) {
            this.npc.func_70661_as().func_75489_a(1.2);
        } else {
            this.npc.func_70661_as().func_75489_a(1.0);
        }
        if (this.npc.ai.tacticalVariant == 3 && (!this.npc.isInRange(this.closestLivingEntity, this.distanceFromEntity) || this.npc.isInRange(this.closestLivingEntity, this.npc.ai.getTacticalRange()))) {
            this.health = this.npc.func_110143_aJ();
        }
    }
}

