/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import noppes.npcs.CustomNpcs;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IItemStack;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.block.IBlock;
import noppes.npcs.api.entity.ICustomNpc;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.handler.IFactionHandler;
import noppes.npcs.api.handler.IRecipeHandler;
import noppes.npcs.api.wrapper.AnimalWrapper;
import noppes.npcs.api.wrapper.BlockFluidContainerWrapper;
import noppes.npcs.api.wrapper.BlockScriptedDoorWrapper;
import noppes.npcs.api.wrapper.BlockScriptedWrapper;
import noppes.npcs.api.wrapper.BlockWrapper;
import noppes.npcs.api.wrapper.EntityLivingBaseWrapper;
import noppes.npcs.api.wrapper.EntityLivingWrapper;
import noppes.npcs.api.wrapper.EntityWrapper;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.api.wrapper.MonsterWrapper;
import noppes.npcs.api.wrapper.PlayerWrapper;
import noppes.npcs.api.wrapper.WrapperEntityData;
import noppes.npcs.blocks.BlockScripted;
import noppes.npcs.blocks.BlockScriptedDoor;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;

public class WrapperNpcAPI
extends NpcAPI {
    public static final EventBus EVENT_BUS = new EventBus();
    private static final String key = "NPCWrappedObject";
    private static NpcAPI instance = null;

    @Override
    public IEntity getIEntity(Entity entity) {
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return null;
        }
        if (entity instanceof EntityNPCInterface) {
            return ((EntityNPCInterface)entity).wrappedNPC;
        }
        WrapperEntityData data = (WrapperEntityData)entity.getExtendedProperties(key);
        if (data != null) {
            return data.base;
        }
        data = entity instanceof EntityPlayerMP ? new WrapperEntityData(new PlayerWrapper((EntityPlayerMP)entity)) : (entity instanceof EntityAnimal ? new WrapperEntityData(new AnimalWrapper((EntityAnimal)entity)) : (entity instanceof EntityMob ? new WrapperEntityData(new MonsterWrapper((EntityMob)entity)) : (entity instanceof EntityLiving ? new WrapperEntityData(new EntityLivingWrapper((EntityLiving)entity)) : (entity instanceof EntityLivingBase ? new WrapperEntityData(new EntityLivingBaseWrapper((EntityLivingBase)entity)) : new WrapperEntityData(new EntityWrapper(entity))))));
        entity.registerExtendedProperties(key, (IExtendedEntityProperties)data);
        return data.base;
    }

    @Override
    public ICustomNpc createNPC(World world) {
        if (world.field_72995_K) {
            return null;
        }
        EntityCustomNpc npc = new EntityCustomNpc(world);
        return npc.wrappedNPC;
    }

    @Override
    public ICustomNpc spawnNPC(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return null;
        }
        EntityCustomNpc npc = new EntityCustomNpc(world);
        npc.func_70080_a((double)x + 0.5, y, (double)z + 0.5, 0.0f, 0.0f);
        npc.ai.setStartPos(new BlockPos(x, y, z));
        npc.func_70606_j(npc.func_110138_aP());
        world.func_72838_d((Entity)npc);
        return npc.wrappedNPC;
    }

    public static NpcAPI Instance() {
        if (instance == null) {
            instance = new WrapperNpcAPI();
        }
        return instance;
    }

    @Override
    public EventBus events() {
        return EVENT_BUS;
    }

    @Override
    public IBlock getIBlock(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == null || block.isAir((IBlockAccess)world, pos)) {
            return null;
        }
        if (block instanceof BlockScripted) {
            return new BlockScriptedWrapper(world, block, pos);
        }
        if (block instanceof BlockScriptedDoor) {
            return new BlockScriptedDoorWrapper(world, block, pos);
        }
        if (block instanceof BlockFluidBase) {
            return new BlockFluidContainerWrapper(world, block, pos);
        }
        return new BlockWrapper(world, block, pos);
    }

    @Override
    public IItemStack getIItemStack(ItemStack itemstack) {
        if (itemstack == null) {
            return null;
        }
        return new ItemStackWrapper(itemstack);
    }

    @Override
    public IFactionHandler getFactions() {
        this.checkWorld();
        return FactionController.getInstance();
    }

    private void checkWorld() {
        if (MinecraftServer.func_71276_C() == null || MinecraftServer.func_71276_C().func_71241_aa()) {
            throw new CustomNPCsException("No world is loaded right now", new Object[0]);
        }
    }

    @Override
    public IRecipeHandler getRecipes() {
        this.checkWorld();
        return RecipeController.instance;
    }

    @Override
    public File getGlobalDir() {
        return CustomNpcs.Dir;
    }

    @Override
    public File getWorldDir() {
        return CustomNpcs.getWorldSaveDirectory();
    }
}

